/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.controlflow.ConstantConditionsInterpreter;
import org.eclipse.xtext.xbase.controlflow.EvaluationContext;
import org.eclipse.xtext.xbase.controlflow.IConstantEvaluationResult;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.LocalVariableCapturer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AnnotationValueTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.CapturedLocalElementsAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ConstructorBodyComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.FieldTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.OperationBodyComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typesystem.util.LocalTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public class LogicalContainerAwareReentrantTypeResolver
extends DefaultReentrantTypeResolver {
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private ConstantConditionsInterpreter constantConditionsInterpreter;
    @Inject
    private ReadAndWriteTracking readAndWriteTracking;
    protected Set<EObject> rootedInstances;

    protected JvmType getRootJvmType() {
        EObject result = this.getRoot();
        if (result instanceof JvmType) {
            return (JvmType)result;
        }
        throw new IllegalStateException();
    }

    @Override
    protected void clear() {
        this.rootedInstances.clear();
        super.clear();
    }

    @Override
    protected void setAllRootedExpressions(final Set<EObject> allRootedExpressions) {
        super.setAllRootedExpressions(allRootedExpressions);
        this.rootedInstances = new HashSet<EObject>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(EObject e) {
                if (!allRootedExpressions.add(e)) {
                    throw new IllegalStateException("Cannot root object twice: " + e);
                }
                return super.add(e);
            }
        };
    }

    @Override
    protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
        JvmIdentifiableElement container2 = this.logicalContainerProvider.getNearestLogicalContainer(identifiableElement);
        if (container2 != null) {
            return super.isHandled(container2);
        }
        return super.isHandled(identifiableElement);
    }

    @Override
    protected boolean isHandled(XExpression expression) {
        if (this.rootedInstances.contains(expression)) {
            return true;
        }
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(expression);
        if (logicalContainer == null) {
            return false;
        }
        XExpression associatedExpression = this.logicalContainerProvider.getAssociatedExpression(logicalContainer);
        if (associatedExpression != null && EcoreUtil.isAncestor(associatedExpression, (EObject)expression) && this.rootedInstances.contains(associatedExpression)) {
            return true;
        }
        EObject root = expression;
        EObject container2 = root.eContainer();
        while (this.isPartOfExpressionTree(container2)) {
            root = container2;
            container2 = root.eContainer();
        }
        return this.rootedInstances.contains(root);
    }

    protected boolean isPartOfExpressionTree(EObject container2) {
        if (container2 instanceof XExpression) {
            return true;
        }
        EClass type = container2.eClass();
        return type == XbasePackage.Literals.XCASE_PART || type == XbasePackage.Literals.XCATCH_CLAUSE || type == XAnnotationsPackage.Literals.XANNOTATION_ELEMENT_VALUE_PAIR;
    }

    @Override
    protected boolean isHandled(EObject context) {
        if (context instanceof XExpression) {
            return this.isHandled((XExpression)context);
        }
        if (context instanceof JvmIdentifiableElement) {
            return this.isHandled((JvmIdentifiableElement)context);
        }
        if (this.isPartOfExpressionTree(context)) {
            return this.isHandled((XExpression)context.eContainer());
        }
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(context);
        if (logicalContainer == null) {
            return false;
        }
        return this.isHandled(logicalContainer);
    }

    protected Map<JvmIdentifiableElement, ResolvedTypes> prepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession) {
        HashMap<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext = Maps.newHashMapWithExpectedSize(3);
        JvmType root = this.getRootJvmType();
        this.rootedInstances.add(root);
        this.recordExpressions(root);
        this.doPrepare(resolvedTypes, featureScopeSession, root, resolvedTypesByContext);
        return resolvedTypesByContext;
    }

    protected void recordExpressions(JvmIdentifiableElement element) {
        XExpression expression = this.getLogicalContainerProvider().getAssociatedExpression(element);
        if (expression != null) {
            this.rootedInstances.add(expression);
        }
        if (element instanceof JvmDeclaredType) {
            this._recordExpressions((JvmDeclaredType)element);
        } else if (element instanceof JvmExecutable) {
            this._recordExpressions((JvmExecutable)element);
        } else if (element instanceof JvmFeature) {
            this._recordExpressions((JvmFeature)element);
        }
    }

    protected void _recordExpressions(JvmFeature feature) {
        EList<JvmGenericType> localClasses = feature.getLocalClasses();
        int size = localClasses.size();
        for (int i = 0; i < size; ++i) {
            this.recordExpressions((JvmIdentifiableElement)localClasses.get(i));
        }
        this.recordAnnotationExpressions(feature);
    }

    protected void _recordExpressions(JvmExecutable executable) {
        EList<JvmGenericType> localClasses = executable.getLocalClasses();
        int size = localClasses.size();
        for (int i = 0; i < size; ++i) {
            this.recordExpressions((JvmIdentifiableElement)localClasses.get(i));
        }
        this.recordAnnotationExpressions(executable);
    }

    protected void _recordExpressions(JvmDeclaredType type) {
        EList<JvmMember> members = type.getMembers();
        int size = members.size();
        for (int i = 0; i < size; ++i) {
            this.recordExpressions((JvmIdentifiableElement)members.get(i));
        }
        this.recordAnnotationExpressions(type);
    }

    protected void doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmIdentifiableElement element, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        XExpression expression = this.getLogicalContainerProvider().getAssociatedExpression(element);
        if (expression != null && !this.rootedInstances.contains(expression)) {
            throw new IllegalStateException("Expression not yet recorded: " + expression);
        }
        if (element instanceof JvmDeclaredType) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmDeclaredType)element, resolvedTypesByContext);
        } else if (element instanceof JvmConstructor) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmConstructor)element, resolvedTypesByContext);
        } else if (element instanceof JvmField) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmField)element, resolvedTypesByContext);
        } else if (element instanceof JvmOperation) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmOperation)element, resolvedTypesByContext);
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByType) {
        IFeatureScopeSession childSession = this.addThisAndSuper(featureScopeSession, resolvedTypes.getReferenceOwner(), type);
        this.prepareMembers(resolvedTypes, childSession, type, resolvedTypesByType);
    }

    protected void prepareMembers(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByType) {
        IFeatureScopeSession childSession = this.addExtensionsToMemberSession(resolvedTypes, featureScopeSession, type);
        StackedResolvedTypes childResolvedTypes = this.declareTypeParameters(resolvedTypes, type, resolvedTypesByType);
        JvmTypeReference superType = this.getExtendedClass(type);
        ITypeReferenceOwner referenceOwner = childResolvedTypes.getReferenceOwner();
        if (superType != null) {
            LightweightTypeReference lightweightSuperType = referenceOwner.toLightweightTypeReference(superType);
            childResolvedTypes.reassignTypeWithoutMerge(superType.getType(), lightweightSuperType);
        }
        LightweightTypeReference lightweightThisType = referenceOwner.toLightweightTypeReference(type);
        childResolvedTypes.reassignTypeWithoutMerge(type, lightweightThisType);
        EList<JvmMember> members = type.getMembers();
        int size = members.size();
        for (int i = 0; i < size; ++i) {
            this.doPrepare(childResolvedTypes, childSession, (JvmIdentifiableElement)members.get(i), resolvedTypesByType);
        }
    }

    protected StackedResolvedTypes declareTypeParameters(ResolvedTypes resolvedTypes, JvmIdentifiableElement declarator, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        StackedResolvedTypes childResolvedTypes = resolvedTypes.pushTypes();
        if (declarator instanceof JvmTypeParameterDeclarator) {
            JvmTypeParameterDeclarator casted = (JvmTypeParameterDeclarator)((Object)declarator);
            if (this.isStatic(declarator) && !(declarator instanceof JvmConstructor)) {
                childResolvedTypes.replaceDeclaredTypeParameters(casted.getTypeParameters());
            } else {
                childResolvedTypes.addDeclaredTypeParameters(casted.getTypeParameters());
            }
        }
        resolvedTypesByContext.put(declarator, childResolvedTypes);
        return childResolvedTypes;
    }

    protected boolean isStatic(JvmIdentifiableElement declarator) {
        if (declarator instanceof JvmFeature) {
            return ((JvmFeature)declarator).isStatic();
        }
        if (declarator instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)declarator).isStatic();
        }
        return false;
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmField field, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        StackedResolvedTypes childResolvedTypes = this.declareTypeParameters(resolvedTypes, field, resolvedTypesByContext);
        JvmTypeReference knownType = field.getType();
        if (InferredTypeIndicator.isInferred(knownType)) {
            XComputedTypeReference casted = (XComputedTypeReference)knownType;
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypesByContext, childResolvedTypes, featureScopeSession, field, (InferredTypeIndicator)casted.getTypeProvider(), false);
            casted.setEquivalent(reference);
        } else if (knownType != null) {
            LightweightTypeReference lightweightReference = childResolvedTypes.getReferenceOwner().toLightweightTypeReference(knownType);
            childResolvedTypes.setType(field, lightweightReference);
        } else {
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypesByContext, childResolvedTypes, featureScopeSession, field, null, false);
            field.setType(reference);
        }
    }

    protected AbstractDemandTypeReferenceProvider getComputedTypeReference(JvmTypeReference knownType) {
        IJvmTypeReferenceProvider typeProvider;
        XComputedTypeReference casted;
        JvmTypeReference equivalent;
        if (InferredTypeIndicator.isInferred(knownType) && (equivalent = (casted = (XComputedTypeReference)knownType).getEquivalent()) instanceof XComputedTypeReference && (typeProvider = ((XComputedTypeReference)equivalent).getTypeProvider()) instanceof AbstractDemandTypeReferenceProvider) {
            return (AbstractDemandTypeReferenceProvider)typeProvider;
        }
        return null;
    }

    protected void markComputing(JvmTypeReference knownType) {
        AbstractDemandTypeReferenceProvider demandTypeReferenceProvider = this.getComputedTypeReference(knownType);
        if (demandTypeReferenceProvider != null) {
            demandTypeReferenceProvider.markComputing();
        }
    }

    protected void unmarkComputing(JvmTypeReference knownType) {
        AbstractDemandTypeReferenceProvider demandTypeReferenceProvider = this.getComputedTypeReference(knownType);
        if (demandTypeReferenceProvider != null) {
            demandTypeReferenceProvider.unmarkComputing();
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmConstructor constructor, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        StackedResolvedTypes childResolvedTypes = this.declareTypeParameters(resolvedTypes, constructor, resolvedTypesByContext);
        JvmDeclaredType producedType = constructor.getDeclaringType();
        LightweightTypeReference lightweightReference = childResolvedTypes.getReferenceOwner().toLightweightTypeReference(producedType);
        childResolvedTypes.setType(constructor, lightweightReference);
    }

    protected void recordAnnotationExpressions(JvmExecutable executable) {
        EList<JvmFormalParameter> parameters = executable.getParameters();
        for (JvmFormalParameter parameter : parameters) {
            this.recordAnnotationExpressions(parameter);
        }
        this.recordAnnotationExpressions((JvmAnnotationTarget)executable);
    }

    protected void recordAnnotationExpressions(JvmAnnotationTarget annotable) {
        EList<JvmAnnotationReference> annotations = annotable.getAnnotations();
        this.recordAnnotationExpressions(annotations);
    }

    protected void recordAnnotationExpressions(List<JvmAnnotationReference> annotations) {
        for (JvmAnnotationReference annotation2 : annotations) {
            EObject sourceElement = this.getSourceElement(annotation2);
            if (sourceElement != annotation2) {
                this.rootedInstances.add(sourceElement);
                continue;
            }
            for (JvmAnnotationValue value : annotation2.getExplicitValues()) {
                if (value instanceof JvmCustomAnnotationValue) {
                    JvmCustomAnnotationValue custom = (JvmCustomAnnotationValue)value;
                    for (Object e : custom.getValues()) {
                        if (!(e instanceof XExpression)) continue;
                        this.rootedInstances.add(sourceElement);
                    }
                    continue;
                }
                if (!(value instanceof JvmAnnotationAnnotationValue)) continue;
                this.recordAnnotationExpressions(((JvmAnnotationAnnotationValue)value).getValues());
            }
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
        StackedResolvedTypes childResolvedTypes = this.declareTypeParameters(resolvedTypes, operation, resolvedTypesByContext);
        JvmTypeReference knownType = operation.getReturnType();
        if (InferredTypeIndicator.isInferred(knownType)) {
            XComputedTypeReference casted = (XComputedTypeReference)knownType;
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypesByContext, childResolvedTypes, featureScopeSession, operation, (InferredTypeIndicator)casted.getTypeProvider(), true);
            casted.setEquivalent(reference);
        } else if (knownType != null) {
            LightweightTypeReference lightweightReference = childResolvedTypes.getReferenceOwner().toLightweightTypeReference(knownType);
            childResolvedTypes.setType(operation, lightweightReference);
        } else {
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypesByContext, childResolvedTypes, featureScopeSession, operation, null, true);
            operation.setReturnType(reference);
        }
    }

    protected JvmTypeReference createComputedTypeReference(Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member, InferredTypeIndicator indicator, boolean returnType) {
        XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
        if (indicator == null || indicator.getExpression() == null) {
            result.setTypeProvider(this.createTypeProvider(resolvedTypesByContext, resolvedTypes, featureScopeSession, member, returnType));
        } else {
            result.setTypeProvider(this.createTypeProvider(resolvedTypesByContext, resolvedTypes, featureScopeSession, member, indicator.getExpression(), returnType));
        }
        return result;
    }

    protected AbstractReentrantTypeReferenceProvider createTypeProvider(Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member, boolean returnType) {
        XExpression expression = this.logicalContainerProvider.getAssociatedExpression(member);
        return this.createTypeProvider(resolvedTypesByContext, resolvedTypes, featureScopeSession, member, expression, returnType);
    }

    protected AbstractReentrantTypeReferenceProvider createTypeProvider(Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member, XExpression expression, boolean returnType) {
        if (expression != null) {
            this.markToBeInferred(resolvedTypes, expression);
            return new DemandTypeReferenceProvider(member, expression, resolvedTypesByContext, resolvedTypes, featureScopeSession, returnType);
        }
        return new AnyTypeReferenceProvider(member, resolvedTypes, this);
    }

    protected void markToBeInferred(ResolvedTypes resolvedTypes, XExpression expression) {
        resolvedTypes.markToBeInferred(expression);
    }

    protected XExpression getInferredFrom(JvmTypeReference typeReference) {
        XComputedTypeReference inferred;
        IJvmTypeReferenceProvider typeProvider;
        XComputedTypeReference computed;
        if (InferredTypeIndicator.isInferred(typeReference) && (computed = (XComputedTypeReference)typeReference).getEquivalent() instanceof XComputedTypeReference && (typeProvider = (inferred = (XComputedTypeReference)computed.getEquivalent()).getTypeProvider()) instanceof DemandTypeReferenceProvider) {
            return ((DemandTypeReferenceProvider)typeProvider).expression;
        }
        return null;
    }

    @Override
    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        EObject root = this.getRoot();
        if (root instanceof JvmType) {
            Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes = this.prepare(resolvedTypes, session);
            this.computeTypes(preparedResolvedTypes, resolvedTypes, session, root);
        } else {
            super.computeTypes(resolvedTypes, session);
        }
    }

    protected void computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, EObject element) {
        if (element instanceof JvmDeclaredType) {
            this._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, (JvmDeclaredType)element);
        } else if (element instanceof JvmConstructor) {
            this._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, (JvmConstructor)element);
        } else if (element instanceof JvmField) {
            this._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, (JvmField)element);
        } else if (element instanceof JvmOperation) {
            this._computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, (JvmOperation)element);
        } else {
            this.computeTypes(resolvedTypes, featureScopeSession, element);
        }
    }

    @Override
    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, EObject element) {
        if (element instanceof JvmConstructor) {
            throw new IllegalStateException();
        }
        if (element instanceof JvmField) {
            throw new IllegalStateException();
        }
        if (element instanceof JvmOperation) {
            throw new IllegalStateException();
        }
        if (element instanceof JvmDeclaredType) {
            throw new IllegalStateException();
        }
        super.computeTypes(resolvedTypes, featureScopeSession, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, final JvmField field) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(field);
        if (childResolvedTypes == null) {
            if (preparedResolvedTypes.containsKey(field)) {
                return;
            }
            throw new IllegalStateException("No resolved type found. Field was: " + field.getIdentifier());
        }
        preparedResolvedTypes.put(field, null);
        FieldTypeComputationState state = new FieldTypeComputationState(childResolvedTypes, field.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext(), field);
        this.markComputing(field.getType());
        try {
            state.computeTypes();
        }
        finally {
            this.unmarkComputing(field.getType());
        }
        this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, field);
        this.computeLocalTypes(preparedResolvedTypes, childResolvedTypes, featureScopeSession, field);
        if (field.isStatic() && field.isFinal() && !field.isSetConstant()) {
            final XExpression expression = state.getRootExpression();
            childResolvedTypes.addDeferredLogic((IAcceptor<? super IResolvedTypes>)new IAcceptor<IResolvedTypes>(){

                @Override
                public void accept(IResolvedTypes resolvedTypes) {
                    IConstantEvaluationResult<Object> result;
                    EvaluationContext context = LogicalContainerAwareReentrantTypeResolver.this.constantConditionsInterpreter.newEvaluationContext();
                    context.addResolvedTypes(field.eResource(), resolvedTypes);
                    IConstantEvaluationResult<Object> iConstantEvaluationResult = result = expression != null ? LogicalContainerAwareReentrantTypeResolver.this.constantConditionsInterpreter.evaluate(expression, context) : null;
                    if (result != null && result.isCompileTimeConstant()) {
                        field.setConstantValue(result.getValue().orNull());
                        field.setConstant(true);
                    } else {
                        field.setConstant(false);
                    }
                }
            });
        }
        if (this.isSerialVersionUid(field, childResolvedTypes)) {
            this.readAndWriteTracking.markReadAccess(field);
        }
        this.mergeChildTypes(childResolvedTypes);
    }

    private boolean isSerialVersionUid(JvmField field, ResolvedTypes childResolvedTypes) {
        LightweightTypeReference actualFieldType = childResolvedTypes.getActualType(field);
        JvmDeclaredType declaringType = field.getDeclaringType();
        LightweightTypeReference actualDeclaringType = declaringType != null ? childResolvedTypes.getActualType(declaringType) : null;
        return "serialVersionUID".equals(field.getSimpleName()) && field.isStatic() && field.isFinal() && actualFieldType != null && actualFieldType.isType(Long.TYPE) && this.hasInitialValue(field) && actualDeclaringType != null && actualDeclaringType.isSubtypeOf(Serializable.class);
    }

    private boolean hasInitialValue(JvmField field) {
        return this.getLogicalContainerProvider().getAssociatedExpression(field) != null;
    }

    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmConstructor constructor) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(constructor);
        if (childResolvedTypes == null) {
            if (preparedResolvedTypes.containsKey(constructor)) {
                return;
            }
            throw new IllegalStateException("No resolved type found. Constructor was: " + constructor.getIdentifier());
        }
        preparedResolvedTypes.put(constructor, null);
        ConstructorBodyComputationState state = new ConstructorBodyComputationState(childResolvedTypes, featureScopeSession.toInstanceContext().toConstructorContext(), constructor);
        this.addExtensionProviders(state, constructor.getParameters());
        state.computeTypes();
        this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, constructor);
        this.computeLocalTypes(preparedResolvedTypes, childResolvedTypes, featureScopeSession, constructor);
        this.mergeChildTypes(childResolvedTypes);
    }

    protected void computeLocalTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmFeature feature) {
        for (JvmGenericType localClass : feature.getLocalClasses()) {
            this.computeTypes(preparedResolvedTypes, resolvedTypes, featureScopeSession, localClass);
        }
    }

    protected void addExtensionProviders(ITypeComputationState state, List<JvmFormalParameter> parameters) {
        LinkedList<JvmFormalParameter> extensionProviders = null;
        for (JvmFormalParameter parameter : parameters) {
            if (!this.isExtensionProvider(parameter)) continue;
            if (extensionProviders == null) {
                extensionProviders = Lists.newLinkedList();
            }
            extensionProviders.add(parameter);
        }
        if (extensionProviders != null) {
            state.addExtensionsToCurrentScope(extensionProviders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(operation);
        if (childResolvedTypes == null) {
            if (preparedResolvedTypes.containsKey(operation)) {
                return;
            }
            throw new IllegalStateException("No resolved type found. Operation was: " + operation.getIdentifier());
        }
        preparedResolvedTypes.put(operation, null);
        OperationBodyComputationState state = new OperationBodyComputationState(childResolvedTypes, operation.isStatic() ? featureScopeSession : featureScopeSession.toInstanceContext(), operation);
        this.addExtensionProviders(state, operation.getParameters());
        this.markComputing(operation.getReturnType());
        try {
            state.computeTypes();
        }
        finally {
            this.unmarkComputing(operation.getReturnType());
        }
        this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, operation);
        this.computeLocalTypes(preparedResolvedTypes, childResolvedTypes, featureScopeSession, operation);
        this.mergeChildTypes(childResolvedTypes);
    }

    protected void computeAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession sessions, JvmExecutable operation) {
        this.computeAnnotationTypes(resolvedTypes, sessions, (JvmAnnotationTarget)operation);
        for (JvmFormalParameter parameter : operation.getParameters()) {
            this.computeAnnotationTypes(resolvedTypes, sessions, parameter);
        }
    }

    protected void mergeChildTypes(ResolvedTypes childResolvedTypes) {
        if (childResolvedTypes instanceof StackedResolvedTypes) {
            ((StackedResolvedTypes)childResolvedTypes).mergeIntoParent();
        }
    }

    protected void computeAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmAnnotationTarget annotable) {
        EList<JvmAnnotationReference> annotations = annotable.getAnnotations();
        this.computeAnnotationTypes(resolvedTypes, featureScopeSession, annotations);
    }

    protected void computeAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, List<JvmAnnotationReference> annotations) {
        for (JvmAnnotationReference annotation2 : annotations) {
            EObject sourceElement = this.getSourceElement(annotation2);
            if (sourceElement != annotation2) {
                this.computeTypes(resolvedTypes, featureScopeSession, sourceElement);
                continue;
            }
            for (JvmAnnotationValue value : annotation2.getExplicitValues()) {
                if (value instanceof JvmCustomAnnotationValue) {
                    JvmCustomAnnotationValue custom = (JvmCustomAnnotationValue)value;
                    for (Object e : custom.getValues()) {
                        if (!(e instanceof XExpression)) continue;
                        AnnotationValueTypeComputationState state = new AnnotationValueTypeComputationState(resolvedTypes, featureScopeSession, value, (XExpression)e);
                        state.computeTypes();
                    }
                    continue;
                }
                if (!(value instanceof JvmAnnotationAnnotationValue)) continue;
                this.computeAnnotationTypes(resolvedTypes, featureScopeSession, ((JvmAnnotationAnnotationValue)value).getValues());
            }
        }
    }

    protected void _computeTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type) {
        ResolvedTypes childResolvedTypes = preparedResolvedTypes.get(type);
        if (childResolvedTypes == null) {
            throw new IllegalStateException("No resolved type found. Type was: " + type.getIdentifier());
        }
        IFeatureScopeSession capturedState = LocalVariableCapturerImpl.findCapturedState(type);
        if (capturedState != null) {
            featureScopeSession = capturedState;
        }
        IFeatureScopeSession childSession = this.addThisAndSuper(featureScopeSession, childResolvedTypes.getReferenceOwner(), type);
        this.computeMemberTypes(preparedResolvedTypes, childResolvedTypes, childSession, type);
        this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, type);
        this.mergeChildTypes(childResolvedTypes);
    }

    protected void computeMemberTypes(Map<JvmIdentifiableElement, ResolvedTypes> preparedResolvedTypes, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type) {
        IFeatureScopeSession childSession = this.addExtensionsToMemberSession(resolvedTypes, featureScopeSession, type);
        EList<JvmMember> members = type.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            this.computeTypes(preparedResolvedTypes, resolvedTypes, childSession, (EObject)members.get(i));
        }
    }

    protected IFeatureScopeSession addThisAndSuper(IFeatureScopeSession session, ITypeReferenceOwner owner, JvmDeclaredType type) {
        JvmTypeReference superType = this.getExtendedClass(type);
        return this.addThisAndSuper(session, owner, type, superType, true);
    }

    protected IFeatureScopeSession addThisAndSuper(IFeatureScopeSession session, ITypeReferenceOwner owner, JvmDeclaredType thisType, JvmTypeReference superType, boolean addNestedTypes) {
        IFeatureScopeSession childSession = session;
        if (thisType.eContainer() != null) {
            if (thisType.isStatic()) {
                childSession = childSession.dropLocalElements();
            } else {
                if (!thisType.isLocal()) {
                    childSession = childSession.toInstanceContext();
                }
                childSession = childSession.captureLocalElements();
            }
        }
        if (superType != null && superType.getType() != null) {
            ImmutableMap.Builder<QualifiedName, JvmType> builder = ImmutableMap.builder();
            builder.put(IFeatureNames.THIS, thisType);
            builder.put(IFeatureNames.SUPER, superType.getType());
            childSession = childSession.addLocalElements(builder.build(), owner);
        } else {
            childSession = childSession.addLocalElement(IFeatureNames.THIS, thisType, owner);
        }
        childSession = this.addThisTypeToStaticScope(childSession, thisType);
        if (addNestedTypes) {
            childSession = childSession.addNestedTypesToScope(thisType);
        }
        return childSession;
    }

    protected IFeatureScopeSession addThisTypeToStaticScope(IFeatureScopeSession session, JvmDeclaredType type) {
        return session.addTypesToStaticScope(Collections.singletonList(type), Collections.emptyList());
    }

    public JvmTypeReference getExtendedClass(JvmDeclaredType type) {
        for (JvmTypeReference candidate : type.getSuperTypes()) {
            JvmType candidateType = candidate.getType();
            if (!(candidateType instanceof JvmGenericType) || ((JvmGenericType)candidateType).isInterface()) continue;
            return candidate;
        }
        return null;
    }

    protected IFeatureScopeSession addExtensionsToMemberSession(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type) {
        IEObjectDescription thisDescription = featureScopeSession.getLocalElement(IFeatureNames.THIS);
        if (thisDescription == null) {
            throw new IllegalStateException("Cannot find feature 'THIS'");
        }
        JvmIdentifiableElement thisFeature = (JvmIdentifiableElement)thisDescription.getEObjectOrProxy();
        IFeatureScopeSession childSession = this.addExtensionFieldsToMemberSession(resolvedTypes, featureScopeSession, type, thisFeature, Sets.newHashSetWithExpectedSize(8), Sets.newHashSetWithExpectedSize(4));
        XFeatureCall thisAccess = this.getXbaseFactory().createXFeatureCall();
        thisAccess.setFeature(thisFeature);
        LightweightTypeReference thisType = resolvedTypes.getActualType(thisFeature);
        childSession = childSession.addToExtensionScope(Collections.singletonMap(thisAccess, thisType));
        return childSession;
    }

    protected IFeatureScopeSession addExtensionFieldsToMemberSession(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type, JvmIdentifiableElement thisFeature, Set<String> seenNames, Set<JvmType> seenTypes) {
        if (seenTypes.add(type)) {
            Iterable<JvmField> fields = type.getDeclaredFields();
            LinkedHashMap<XAbstractFeatureCall, LightweightTypeReference> extensionProviders = null;
            for (JvmField field : fields) {
                if (!featureScopeSession.isVisible(field) || !seenNames.add(field.getSimpleName()) || !this.isExtensionProvider(field)) continue;
                if (extensionProviders == null) {
                    extensionProviders = Maps2.newLinkedHashMapWithExpectedSize(3);
                }
                XAbstractFeatureCall extensionProvider = this.createExtensionProvider(thisFeature, field);
                LightweightTypeReference fieldType = resolvedTypes.getActualType(field);
                extensionProviders.put(extensionProvider, fieldType);
            }
            JvmTypeReference superType = this.getExtendedClass(type);
            IFeatureScopeSession result = featureScopeSession;
            if (superType != null) {
                result = this.addExtensionFieldsToMemberSession(resolvedTypes, featureScopeSession, (JvmDeclaredType)superType.getType(), thisFeature, seenNames, seenTypes);
            }
            if (extensionProviders != null) {
                result = result.addToExtensionScope(extensionProviders);
            }
            return result;
        }
        return featureScopeSession;
    }

    protected XAbstractFeatureCall createExtensionProvider(JvmIdentifiableElement thisFeature, JvmField field) {
        if (field.isStatic()) {
            XFeatureCall extensionProvider = this.getXbaseFactory().createXFeatureCall();
            extensionProvider.setFeature(field);
            return extensionProvider;
        }
        XMemberFeatureCall extensionProvider = this.getXbaseFactory().createXMemberFeatureCall();
        extensionProvider.setFeature(field);
        XFeatureCall thisAccess = this.getXbaseFactory().createXFeatureCall();
        thisAccess.setFeature(thisFeature);
        extensionProvider.setMemberCallTarget(thisAccess);
        return extensionProvider;
    }

    protected boolean isExtensionProvider(JvmAnnotationTarget annotatedElement) {
        return this.annotationLookup.findAnnotation(annotatedElement, Extension.class) != null;
    }

    protected AnnotationLookup getAnnotationLookup() {
        return this.annotationLookup;
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.logicalContainerProvider;
    }

    protected IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE) {
            return null;
        }
        if (InferredTypeIndicator.isInferred(operation.getReturnType())) {
            LightweightTypeReference declaringType = resolvedTypes.getActualType(operation.getDeclaringType());
            if (declaringType == null) {
                throw new IllegalStateException("Cannot determine declaring type of operation: " + operation);
            }
            LightweightTypeReference result = this.overrideHelper.getReturnTypeOfOverriddenOperation(operation, declaringType);
            return result;
        }
        return null;
    }

    protected OverrideHelper getOverrideHelper() {
        return this.overrideHelper;
    }

    @Override
    protected EObject getSourceElement(EObject element) {
        EObject result = this.associations.getPrimarySourceElement(element);
        if (result != null) {
            return result;
        }
        return element;
    }

    protected Set<EObject> getInferredElements(EObject element) {
        return this.associations.getJvmElements(element);
    }

    protected JvmTypeReference toJavaCompliantTypeReference(LightweightTypeReference result, IFeatureScopeSession session) {
        return result.toJavaCompliantTypeReference(session);
    }

    protected void requestCapturedLocalVariables(JvmTypeReference toBeWrapped, JvmDeclaredType type, ResolvedTypes resolvedTypes, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, IAcceptor<JvmTypeReference> result) {
        LocalVariableCapturerImpl capturer = new LocalVariableCapturerImpl(toBeWrapped, type, this, resolvedTypes, resolvedTypesByContext);
        XComputedTypeReference ref = this.getServices().getXtypeFactory().createXComputedTypeReference();
        ref.setTypeProvider(capturer);
        result.accept(ref);
        capturer.awaitCapturing();
    }

    public static class AnyTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmMember member;
        private final ResolvedTypes resolvedTypes;
        private final LogicalContainerAwareReentrantTypeResolver typeResolver;

        public AnyTypeReferenceProvider(JvmMember member, ResolvedTypes resolvedTypes, LogicalContainerAwareReentrantTypeResolver typeResolver) {
            this.member = member;
            this.resolvedTypes = resolvedTypes;
            this.typeResolver = typeResolver;
        }

        @Override
        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                this.resolvedTypes.addDiagnostic(new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", "Cannot infer type", this.typeResolver.getSourceElement(this.member), null, -1, null));
                JvmAnyTypeReference jvmAnyTypeReference = TypesFactory.eINSTANCE.createJvmAnyTypeReference();
                return jvmAnyTypeReference;
            }
            finally {
                context.unsetTypeProviderWithoutNotification();
            }
        }
    }

    public class DemandTypeReferenceProvider
    extends AbstractDemandTypeReferenceProvider {
        private final JvmMember member;
        private final ResolvedTypes resolvedTypes;
        private final boolean returnType;
        private final IFeatureScopeSession session;
        private final XExpression expression;
        private final Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext;

        public DemandTypeReferenceProvider(JvmMember member, XExpression expression, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext, ResolvedTypes resolvedTypes, IFeatureScopeSession session, boolean returnType) {
            this.member = member;
            this.expression = expression;
            this.resolvedTypesByContext = resolvedTypesByContext;
            this.resolvedTypes = resolvedTypes;
            this.session = session;
            this.returnType = returnType;
        }

        @Override
        protected JvmTypeReference doGetTypeReference(XComputedTypeReferenceImplCustom context) {
            try {
                if (LogicalContainerAwareReentrantTypeResolver.this.isHandled(this.expression)) {
                    JvmTypeReference jvmTypeReference = this.doGetTypeReferenceWithCurrentTypeResolver();
                    return jvmTypeReference;
                }
                JvmTypeReference jvmTypeReference = this.doGetTypReferenceWithAnotherTypeReference();
                return jvmTypeReference;
            }
            finally {
                context.unsetTypeProviderWithoutNotification();
            }
        }

        protected JvmTypeReference doGetTypReferenceWithAnotherTypeReference() {
            LightweightTypeReference actualType;
            IResolvedTypes resolveTypes = LogicalContainerAwareReentrantTypeResolver.this.typeResolver.resolveTypes(this.expression);
            LightweightTypeReference lightweightTypeReference = actualType = this.returnType ? resolveTypes.getReturnType(this.expression) : resolveTypes.getActualType(this.expression);
            if (actualType == null) {
                LightweightTypeReference lightweightTypeReference2 = actualType = this.returnType ? this.resolvedTypes.getExpectedReturnType(this.expression) : this.resolvedTypes.getExpectedType(this.expression);
            }
            if (actualType == null) {
                return null;
            }
            return LogicalContainerAwareReentrantTypeResolver.this.toJavaCompliantTypeReference(this.convertLocalType(actualType), this.session);
        }

        protected JvmTypeReference doGetTypeReferenceWithCurrentTypeResolver() {
            LightweightTypeReference actualType;
            LightweightTypeReference lightweightTypeReference = actualType = this.returnType ? this.resolvedTypes.getReturnType(this.expression) : this.resolvedTypes.getActualType(this.expression);
            if (actualType == null) {
                LogicalContainerAwareReentrantTypeResolver.this.computeTypes(this.resolvedTypesByContext, this.resolvedTypes, this.session, this.member);
                LightweightTypeReference lightweightTypeReference2 = actualType = this.returnType ? this.resolvedTypes.getExpectedReturnType(this.expression) : this.resolvedTypes.getExpectedType(this.expression);
                if (actualType == null) {
                    LightweightTypeReference lightweightTypeReference3 = actualType = this.returnType ? this.resolvedTypes.getReturnType(this.expression) : this.resolvedTypes.getActualType(this.expression);
                }
            }
            if (actualType == null) {
                return null;
            }
            return LogicalContainerAwareReentrantTypeResolver.this.toJavaCompliantTypeReference(this.convertLocalType(actualType), this.session);
        }

        protected LightweightTypeReference convertLocalType(LightweightTypeReference reference) {
            if (this.member instanceof JvmFeature) {
                EList<JvmGenericType> localClasses = ((JvmFeature)this.member).getLocalClasses();
                if (localClasses.isEmpty()) {
                    return reference;
                }
                LocalTypeSubstitutor substitutor = new LocalTypeSubstitutor(reference.getOwner(), this.member);
                LightweightTypeReference result = substitutor.withoutLocalTypes(reference);
                return result;
            }
            return reference;
        }

        @Override
        protected JvmTypeReference handleReentrantInvocation(XComputedTypeReferenceImplCustom context) {
            EObject sourceElement = LogicalContainerAwareReentrantTypeResolver.this.getSourceElement(this.member);
            EStructuralFeature feature = sourceElement.eClass().getEStructuralFeature("name");
            this.resolvedTypes.addDiagnostic(new EObjectDiagnosticImpl(Severity.WARNING, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", "Cannot infer type from recursive usage. Type 'Object' is used.", sourceElement, feature, -1, null));
            AnyTypeReference result = this.resolvedTypes.getReferenceOwner().newAnyTypeReference();
            return LogicalContainerAwareReentrantTypeResolver.this.toJavaCompliantTypeReference(result, this.session);
        }
    }

    protected static abstract class AbstractDemandTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        protected AbstractDemandTypeReferenceProvider() {
        }

        @Override
        protected void markComputing() {
            super.markComputing();
        }

        @Override
        protected void unmarkComputing() {
            super.unmarkComputing();
        }
    }

    protected static class LocalVariableCapturerImpl
    extends LocalVariableCapturer {
        private JvmDeclaredType localClass;
        private LogicalContainerAwareReentrantTypeResolver typeResolver;
        private Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext;
        private ResolvedTypes resolvedTypes;
        private IFeatureScopeSession capturedState;

        protected LocalVariableCapturerImpl(JvmTypeReference equivalent, JvmDeclaredType localClass, LogicalContainerAwareReentrantTypeResolver typeResolver, ResolvedTypes resolvedTypes, Map<JvmIdentifiableElement, ResolvedTypes> resolvedTypesByContext) {
            super(equivalent);
            this.localClass = localClass;
            this.typeResolver = typeResolver;
            this.resolvedTypes = resolvedTypes;
            this.resolvedTypesByContext = resolvedTypesByContext;
        }

        @Override
        protected void awaitCapturing() {
            super.awaitCapturing();
        }

        @Override
        protected void capture(ITypeComputationState state) {
            this.capturedState = ((AbstractTypeComputationState)state).getFeatureScopeSession();
            IFeatureScopeSession nestedSession = this.typeResolver.addThisAndSuper(this.capturedState, state.getReferenceOwner(), this.localClass, this.getEquivalent(), true);
            ResolvedTypes capturedResolvedTypes = this.captureResolvedTypes(state);
            this.typeResolver.doPrepare(capturedResolvedTypes, nestedSession, this.localClass, this.resolvedTypesByContext);
        }

        protected ResolvedTypes captureResolvedTypes(ITypeComputationState state) {
            ResolvedTypes capturedResolvedTypes = ((AbstractTypeComputationState)state).getResolvedTypes();
            return new CapturedLocalElementsAwareStackedResolvedTypes(capturedResolvedTypes, this.resolvedTypes);
        }

        protected static IFeatureScopeSession findCapturedState(JvmDeclaredType type) {
            LocalVariableCapturerImpl capturer = (LocalVariableCapturerImpl)LocalVariableCapturerImpl.findLocalClassSupertype(type);
            if (capturer != null) {
                if (capturer.capturedState == null) {
                    throw new IllegalStateException("Not yet captured");
                }
                return capturer.capturedState;
            }
            return null;
        }
    }
}

