/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractImplicitFeature
implements IFeatureLinkingCandidate {
    private final XAbstractFeatureCall featureCall;
    private final XAbstractFeatureCall implicit;
    private final ExpressionTypeComputationState state;

    protected AbstractImplicitFeature(XAbstractFeatureCall featureCall, XAbstractFeatureCall implicit, ExpressionTypeComputationState state) {
        this.featureCall = featureCall;
        this.implicit = implicit;
        this.state = state;
    }

    protected ExpressionTypeComputationState getState() {
        return this.state;
    }

    @Override
    public void applyToComputationState() {
        this.state.acceptCandidate(this.implicit, this);
        this.getState().markAsRefinedTypeIfNecessary(this);
    }

    protected XAbstractFeatureCall getOwner() {
        return this.featureCall;
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        return this;
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return this.implicit.getFeature();
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        JvmIdentifiableElement implicitFeature = this.getFeature();
        if (implicitFeature instanceof XVariableDeclaration) {
            String message;
            XVariableDeclaration casted = (XVariableDeclaration)implicitFeature;
            if (casted.isWriteable() && (message = this.getState().getResolver().getInvalidWritableVariableAccessMessage(casted, this.getFeatureCall(), this.getState().getResolvedTypes())) != null) {
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access", message, this.getOwner(), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept(diagnostic);
                return false;
            }
            if (EcoreUtil.isAncestor(casted, (EObject)this.getFeatureCall())) {
                message = String.format("The implicitly referenced variable %s may not have been initialized", implicitFeature.getSimpleName());
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", message, this.getOwner(), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept(diagnostic);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return this.implicit;
    }

    @Override
    public XExpression getExpression() {
        return this.implicit;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    @Override
    public boolean isExtension() {
        return false;
    }
}

