/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameInStaticImportValueConverter;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XtypePackage;

@Singleton
public class XbaseLocationInFileProvider
extends DefaultLocationInFileProvider {
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;
    @Inject
    private XbaseQualifiedNameInStaticImportValueConverter qualifiedNameInStaticImportValueConverter;

    @Override
    public ITextRegion getSignificantTextRegion(EObject element) {
        XAbstractFeatureCall typeLiteral;
        if (element instanceof XAbstractFeatureCall && (typeLiteral = this.typeLiteralHelper.getRootTypeLiteral((XAbstractFeatureCall)element)) != null) {
            XAbstractFeatureCall target;
            if (typeLiteral instanceof XMemberFeatureCall && (target = (XAbstractFeatureCall)((XMemberFeatureCall)typeLiteral).getMemberCallTarget()).isTypeLiteral()) {
                return super.getSignificantTextRegion(typeLiteral);
            }
            ICompositeNode node = NodeModelUtils.findActualNodeFor(typeLiteral);
            if (node != null) {
                return this.toZeroBasedRegion(node.getTextRegionWithLineInformation());
            }
        }
        return super.getSignificantTextRegion(element);
    }

    @Override
    protected ITextRegion getLocationOfCrossReference(EObject owner, EReference reference, int indexInList, boolean isSignificant) {
        List<INode> nodes;
        if (owner instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE && ((XMemberFeatureCall)owner).isTypeLiteral()) {
            List<INode> featureNodes = NodeModelUtils.findNodesForFeature(owner, reference);
            ITextRegion result = ITextRegion.EMPTY_REGION;
            if (!featureNodes.isEmpty()) {
                INode featureNode = featureNodes.get(0);
                result = result.merge(this.toZeroBasedRegion(featureNode.getTextRegionWithLineInformation()));
                List<INode> targetNodes = NodeModelUtils.findNodesForFeature(owner, XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET);
                if (!targetNodes.isEmpty()) {
                    INode targetNode = targetNodes.get(0);
                    result = result.merge(this.toZeroBasedRegion(targetNode.getTextRegionWithLineInformation()));
                }
                return result;
            }
        }
        if (isSignificant && owner instanceof XImportDeclaration && reference == XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE && !(nodes = NodeModelUtils.findNodesForFeature(owner, reference)).isEmpty()) {
            INode qualifierNode = nodes.get(0);
            ITextRegion result = ITextRegion.EMPTY_REGION;
            INode pending = null;
            String delimiter = this.qualifiedNameInStaticImportValueConverter.getStringNamespaceDelimiter();
            for (INode iNode : qualifierNode.getLeafNodes()) {
                int length;
                if (this.isHidden(iNode) || (length = iNode.getLength()) == 0) continue;
                if (pending != null) {
                    result.merge(this.toZeroBasedRegion(pending.getTextRegionWithLineInformation()));
                    pending = null;
                }
                if (delimiter.equals(iNode.getText())) {
                    pending = iNode;
                    continue;
                }
                result = result.merge(this.toZeroBasedRegion(iNode.getTextRegionWithLineInformation()));
            }
            return result;
        }
        return super.getLocationOfCrossReference(owner, reference, indexInList, isSignificant);
    }

    @Override
    protected ITextRegion getLocationOfContainmentReference(EObject owner, EReference reference, int indexInList, ILocationInFileProviderExtension.RegionDescription query) {
        XMemberFeatureCall casted;
        if (owner instanceof XMemberFeatureCall && reference == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && ((casted = (XMemberFeatureCall)owner).isExplicitStatic() || casted.isStaticWithDeclaringType())) {
            XExpression target = ((XMemberFeatureCall)owner).getMemberCallTarget();
            return this.getTextRegion((EObject)target, query);
        }
        return super.getLocationOfContainmentReference(owner, reference, indexInList, query);
    }

    @Override
    protected List<INode> getLocationNodes(EObject obj) {
        if (obj instanceof XMemberFeatureCall || obj instanceof XAssignment || obj instanceof XFeatureCall) {
            ArrayList<INode> resultNodes = Lists.newArrayList();
            ICompositeNode startNode = this.findNodeFor(obj);
            boolean crossRefConsumed = false;
            for (INode child : startNode.getChildren()) {
                if (crossRefConsumed) {
                    resultNodes.add(child);
                    continue;
                }
                EObject grammarElement = child.getGrammarElement();
                if (!(grammarElement instanceof CrossReference)) continue;
                Assignment assignment = GrammarUtil.containingAssignment(grammarElement);
                if (!XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE.getName().equals(assignment.getFeature())) continue;
                crossRefConsumed = true;
                resultNodes.add(child);
            }
            if (!resultNodes.isEmpty()) {
                return resultNodes;
            }
        }
        return super.getLocationNodes(obj);
    }

    @Override
    protected boolean useKeyword(Keyword keyword, EObject context) {
        return false;
    }
}

