/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.inject.Inject;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.persistence.ResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageLoadable;
import org.eclipse.xtext.xbase.resource.BatchLinkableResourceStorageWritable;

public class BatchLinkableResourceStorageFacade
extends ResourceStorageFacade {
    @Inject
    private IProjectConfigProvider projectConfigProvider;

    @Override
    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        return new BatchLinkableResourceStorageLoadable(in, this.isStoreNodeModel());
    }

    @Override
    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        return new BatchLinkableResourceStorageWritable(out, this.isStoreNodeModel());
    }

    @Override
    protected URI getSourceContainerURI(StorageAwareResource resource) {
        ISourceFolder sourceFolder;
        IProjectConfig project;
        URI uri = resource.getURI();
        IProjectConfig mainProject = this.projectConfigProvider.getProjectConfig(resource.getResourceSet());
        if (mainProject != null && (project = mainProject.getWorkspaceConfig().findProjectContaining(uri)) != null && (sourceFolder = project.findSourceFolderContaining(uri)) != null) {
            return sourceFolder.getPath();
        }
        return super.getSourceContainerURI(resource);
    }
}

