/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.parser;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.NodeModelBuilder;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parser.ParseException;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.parser.antlr.IPartialParsingHelper;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.parser.antlr.TokenTool;
import org.eclipse.xtext.parser.impl.PartialParsingPointers;
import org.eclipse.xtext.parser.impl.Range;
import org.eclipse.xtext.util.ReplaceRegion;

public class TokenSequencePreservingPartialParsingHelper
implements IPartialParsingHelper {
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private NodeModelBuilder nodeModelBuilder;
    @Inject
    @Named(value="org.eclipse.xtext.parser.antlr.Lexer.RUNTIME")
    private Provider<Lexer> lexerProvider;

    @Override
    public IParseResult reparse(IParser parser2, IParseResult previousParseResult, ReplaceRegion changedRegion) {
        if (this.isBrokenPreviousState(previousParseResult, changedRegion.getOffset())) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        ICompositeNode oldRootNode = previousParseResult.getRootNode();
        Iterator<ILeafNode> leafNodes = oldRootNode.getLeafNodes().iterator();
        ILeafNode leftNode = this.getLeftNode(leafNodes, changedRegion.getOffset());
        if (leftNode == null) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        ILeafNode rightNode = this.getRightNode(leafNodes, changedRegion.getEndOffset());
        if (rightNode == null) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        while (leafNodes.hasNext()) {
            if (leafNodes.next().getSyntaxErrorMessage() == null) continue;
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        String originalText = oldRootNode.getText().substring(leftNode.getTotalOffset());
        StringBuilder newTextBuilder = new StringBuilder(originalText);
        changedRegion.shiftBy(-leftNode.getTotalOffset()).applyTo(newTextBuilder);
        String newText = newTextBuilder.toString();
        if (originalText.equals(newText)) {
            return previousParseResult;
        }
        int originalLength = rightNode.getTotalEndOffset() - leftNode.getTotalOffset();
        int expectedLength = originalLength - changedRegion.getLength() + changedRegion.getText().length();
        if (!this.isSameTokenSequence(originalText.substring(0, originalLength), newText, expectedLength)) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        PartialParsingPointers parsingPointers = this.calculatePartialParsingPointers(oldRootNode, leftNode, rightNode);
        ICompositeNode replaceMe = this.getReplacedNode(parsingPointers);
        if (replaceMe == null || replaceMe == oldRootNode || replaceMe.getOffset() == 0 && replaceMe.getEndOffset() == oldRootNode.getLength()) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        String reparseRegion = this.insertChangeIntoReplaceRegion(replaceMe, changedRegion);
        EObject oldSemanticElement = this.getOldSemanticElement(replaceMe, parsingPointers);
        if (oldSemanticElement == null) {
            return this.fullyReparse(parser2, previousParseResult, changedRegion);
        }
        if (oldSemanticElement == replaceMe.getParent().getSemanticElement()) {
            throw new IllegalStateException("oldParent == oldElement");
        }
        IParseResult newParseResult = this.doParseRegion(parser2, parsingPointers, replaceMe, reparseRegion);
        if (newParseResult == null) {
            throw new IllegalStateException("Could not perform a partial parse operation");
        }
        this.replaceOldSemanticElement(oldSemanticElement, previousParseResult, newParseResult);
        this.nodeModelBuilder.replaceAndTransferLookAhead(replaceMe, newParseResult.getRootNode());
        ((ParseResult)newParseResult).setRootNode(oldRootNode);
        StringBuilder builder = new StringBuilder(oldRootNode.getText());
        changedRegion.applyTo(builder);
        this.nodeModelBuilder.setCompleteContent(oldRootNode, builder.toString());
        return newParseResult;
    }

    protected boolean isBrokenPreviousState(IParseResult previousParseResult, int offset) {
        if (previousParseResult.hasSyntaxErrors()) {
            BidiTreeIterator<AbstractNode> iterator = ((AbstractNode)((Object)previousParseResult.getRootNode())).basicIterator();
            while (iterator.hasPrevious()) {
                AbstractNode previous = iterator.previous();
                if (previous.getGrammarElement() == null) {
                    return true;
                }
                if (!(previous instanceof ILeafNode) || previous.getOffset() > offset) continue;
                break;
            }
        }
        return false;
    }

    protected void replaceOldSemanticElement(EObject oldElement, IParseResult previousParseResult, IParseResult newParseResult) {
        EObject oldSemanticParentElement = oldElement.eContainer();
        if (oldSemanticParentElement != null) {
            EStructuralFeature feature = oldElement.eContainingFeature();
            if (feature.isMany()) {
                List featureValueList = (List)oldSemanticParentElement.eGet(feature);
                int index = featureValueList.indexOf(oldElement);
                this.unloadSemanticObject(oldElement);
                featureValueList.set(index, newParseResult.getRootASTElement());
            } else {
                this.unloadSemanticObject(oldElement);
                oldSemanticParentElement.eSet(feature, newParseResult.getRootASTElement());
            }
            ((ParseResult)newParseResult).setRootASTElement(previousParseResult.getRootASTElement());
        } else {
            this.unloadSemanticObject(oldElement);
        }
    }

    protected EObject getOldSemanticElement(ICompositeNode replaceMe, PartialParsingPointers parsingPointers) {
        EObject oldSemanticElement = null;
        if (replaceMe.hasDirectSemanticElement()) {
            oldSemanticElement = replaceMe.getSemanticElement();
        } else {
            ICompositeNode enclosingNode;
            List<ICompositeNode> nodesEnclosingRegion = parsingPointers.getNodesEnclosingRegion();
            for (int i = nodesEnclosingRegion.size() - 1; i >= 0 && (enclosingNode = nodesEnclosingRegion.get(i)) != replaceMe; --i) {
                if (!enclosingNode.hasDirectSemanticElement()) continue;
                oldSemanticElement = enclosingNode.getSemanticElement();
            }
        }
        return oldSemanticElement;
    }

    protected ICompositeNode getReplacedNode(PartialParsingPointers parsingPointers) {
        List<ICompositeNode> validReplaceRootNodes = parsingPointers.getValidReplaceRootNodes();
        ICompositeNode replaceMe = null;
        for (int i = validReplaceRootNodes.size() - 1; i >= 0 && (replaceMe = validReplaceRootNodes.get(i)) instanceof SyntheticCompositeNode; --i) {
        }
        return replaceMe;
    }

    protected IParseResult doParseRegion(IParser parser2, PartialParsingPointers parsingPointers, ICompositeNode replaceMe, String reparseRegion) {
        EObject entryRuleOrRuleCall = parsingPointers.findEntryRuleOrRuleCall(replaceMe);
        IParseResult newParseResult = null;
        try {
            newParseResult = entryRuleOrRuleCall instanceof RuleCall ? parser2.parse((RuleCall)entryRuleOrRuleCall, new StringReader(reparseRegion), replaceMe.getLookAhead()) : parser2.parse((ParserRule)entryRuleOrRuleCall, new StringReader(reparseRegion));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newParseResult;
    }

    protected boolean isSameTokenSequence(String originalText, String newText, int expectedLength) {
        Lexer originalLexer = this.lexerProvider.get();
        Lexer newLexer = this.lexerProvider.get();
        originalLexer.setCharStream(new ANTLRStringStream(originalText));
        newLexer.setCharStream(new ANTLRStringStream(newText));
        return this.isSameTokenSequence(originalLexer, newLexer, expectedLength);
    }

    protected boolean isSameTokenSequence(TokenSource originalSource, TokenSource newSource, int expectedLength) {
        Token token = originalSource.nextToken();
        int newLength = 0;
        while (-1 != token.getType()) {
            Token newToken = newSource.nextToken();
            if (token.getType() != newToken.getType()) {
                return false;
            }
            newLength += TokenTool.getLength(newToken);
            token = originalSource.nextToken();
        }
        return newLength == expectedLength;
    }

    protected ILeafNode getLeftNode(Iterator<ILeafNode> leafNodes, int offset) {
        while (leafNodes.hasNext()) {
            ILeafNode leaf = leafNodes.next();
            if (leaf.getTotalEndOffset() < offset) continue;
            if (leaf.getSyntaxErrorMessage() != null) {
                return null;
            }
            return leaf;
        }
        return null;
    }

    protected ILeafNode getRightNode(Iterator<ILeafNode> leafNodes, int offset) {
        while (leafNodes.hasNext()) {
            ILeafNode leaf = leafNodes.next();
            if (leaf.getSyntaxErrorMessage() != null) {
                return null;
            }
            if (leaf.getTotalEndOffset() <= offset) continue;
            return leaf;
        }
        return null;
    }

    protected IParseResult fullyReparse(IParser parser2, IParseResult previousParseResult, ReplaceRegion replaceRegion) {
        this.unloadSemanticObject(previousParseResult.getRootASTElement());
        String reparseRegion = this.insertChangeIntoReplaceRegion(previousParseResult.getRootNode(), replaceRegion);
        return parser2.parse(new StringReader(reparseRegion));
    }

    protected void unloadSemanticObject(EObject object) {
        if (this.unloader != null && object != null) {
            this.unloader.unloadRoot(object);
        }
    }

    protected String insertChangeIntoReplaceRegion(ICompositeNode rootNode, ReplaceRegion region) {
        StringBuilder builder = new StringBuilder(rootNode.getText());
        region.shiftBy(0 - rootNode.getTotalOffset()).applyTo(builder);
        return builder.toString();
    }

    protected PartialParsingPointers calculatePartialParsingPointers(ICompositeNode oldRoot, ILeafNode left, ILeafNode right) {
        ICompositeNode result = right.getParent();
        while (result.getTotalOffset() > left.getTotalOffset()) {
            result = result.getParent();
        }
        List<ICompositeNode> nodesEnclosingRegion = this.getAllParents(result);
        Range range = new Range(left.getTotalOffset(), right.getTotalEndOffset());
        List<ICompositeNode> validReplaceRootNodes = this.internalFindValidReplaceRootNodeForChangeRegion(nodesEnclosingRegion);
        this.filterInvalidRootNodes(validReplaceRootNodes);
        if (validReplaceRootNodes.isEmpty()) {
            validReplaceRootNodes = Collections.singletonList(oldRoot);
        }
        return new PartialParsingPointers(oldRoot, range.getOffset(), range.getLength(), validReplaceRootNodes, nodesEnclosingRegion);
    }

    protected List<ICompositeNode> getAllParents(ICompositeNode node) {
        ArrayList<ICompositeNode> list = Lists.newArrayList(node);
        for (node = node.getParent(); node != null; node = node.getParent()) {
            list.add(node);
        }
        return Lists.reverse(list);
    }

    protected void filterInvalidRootNodes(List<ICompositeNode> validReplaceRootNodes) {
        ListIterator<ICompositeNode> iter = validReplaceRootNodes.listIterator(validReplaceRootNodes.size());
        while (iter.hasPrevious()) {
            ICompositeNode candidate = iter.previous();
            if (this.isInvalidRootNode(candidate)) {
                iter.remove();
                continue;
            }
            return;
        }
    }

    protected boolean isInvalidRootNode(ICompositeNode candidate) {
        AbstractRule rule;
        if (candidate instanceof SyntheticCompositeNode) {
            return true;
        }
        if (candidate.getGrammarElement() instanceof RuleCall && (!((rule = ((RuleCall)candidate.getGrammarElement()).getRule()) instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)rule))) {
            return true;
        }
        return candidate.getGrammarElement() instanceof Action;
    }

    protected List<ICompositeNode> internalFindValidReplaceRootNodeForChangeRegion(List<ICompositeNode> nodesEnclosingRegion) {
        ArrayList<ICompositeNode> result = new ArrayList<ICompositeNode>();
        boolean mustSkipNext = false;
        for (int i = 0; i < nodesEnclosingRegion.size(); ++i) {
            ICompositeNode node = nodesEnclosingRegion.get(i);
            if (node.getGrammarElement() == null) continue;
            if (!mustSkipNext) {
                result.add(node);
                if (!this.isActionNode(node)) continue;
                mustSkipNext = true;
                continue;
            }
            mustSkipNext = this.isActionNode(node);
        }
        return result;
    }

    protected boolean isActionNode(ICompositeNode node) {
        return node.getGrammarElement() != null && node.getGrammarElement().eClass() == XtextPackage.Literals.ACTION;
    }
}

