/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.util.RawSuperTypes;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

public class NonOverridableTypesProvider {
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private RawSuperTypes rawSuperTypes;
    private Map<JvmMember, Map<String, JvmIdentifiableElement>> visibleElements = Maps.newHashMap();

    public JvmIdentifiableElement getVisibleType(JvmMember context, String name) {
        if (context == null) {
            return null;
        }
        Map<String, JvmIdentifiableElement> map = this.visibleElements.get(context);
        if (map == null) {
            map = this.create(context);
        }
        return map.get(name);
    }

    protected Map<String, JvmIdentifiableElement> create(JvmMember context) {
        HashMap<String, JvmIdentifiableElement> result = Maps.newHashMap();
        this.process(context, result);
        return result;
    }

    protected void process(JvmMember context, Map<String, JvmIdentifiableElement> result) {
        JvmDeclaredType declaringType;
        if (context instanceof JvmDeclaredType) {
            if (!result.containsKey(context.getSimpleName())) {
                result.put(context.getSimpleName(), context);
            }
            JvmDeclaredType contextType = (JvmDeclaredType)context;
            ContextualVisibilityHelper visibilityHelper = new ContextualVisibilityHelper(this.visibilityHelper, contextType);
            this.addInnerTypes(contextType, "", visibilityHelper, result);
            Set<JvmType> superTypes = this.rawSuperTypes.collect(contextType);
            for (JvmType superType : superTypes) {
                if (!(superType instanceof JvmDeclaredType)) continue;
                this.addInnerTypes((JvmDeclaredType)superType, "", visibilityHelper, result);
            }
        }
        if (context instanceof JvmTypeParameterDeclarator) {
            this.addTypeParameters((JvmTypeParameterDeclarator)((Object)context), result);
        }
        if ((declaringType = context.getDeclaringType()) != null) {
            this.process(declaringType, result);
        }
    }

    protected void addInnerTypes(JvmDeclaredType type, String prefix, IVisibilityHelper visibilityHelper, Map<String, JvmIdentifiableElement> result) {
        for (JvmMember member : type.getMembers()) {
            if (!(member instanceof JvmDeclaredType) || !visibilityHelper.isVisible(member)) continue;
            String localName = prefix + member.getSimpleName();
            if (!result.containsKey(localName)) {
                result.put(localName, member);
            }
            this.addInnerTypes((JvmDeclaredType)member, prefix + member.getSimpleName() + ".", visibilityHelper, result);
        }
    }

    protected void addTypeParameters(JvmTypeParameterDeclarator context, Map<String, JvmIdentifiableElement> result) {
        for (JvmTypeParameter typeParameter : context.getTypeParameters()) {
            if (result.containsKey(typeParameter.getName())) continue;
            result.put(typeParameter.getName(), typeParameter);
        }
    }
}

