/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler.output;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.SharedAppendableState;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceSerializer;

public class ImportingStringConcatenation
extends StringConcatenation {
    private final ImportManager importManager;
    private final ITypeReferenceOwner typeReferenceOwner;

    public ImportingStringConcatenation(SharedAppendableState state, ITypeReferenceOwner typeReferenceOwner) {
        super(state.getLineSeparator());
        this.importManager = state.getImportManager();
        this.typeReferenceOwner = typeReferenceOwner;
    }

    protected String _getStringRepresentation(Object object) {
        return super.getStringRepresentation(object);
    }

    protected String _getStringRepresentation(JvmType object) {
        return this.importManager.serialize(object).toString();
    }

    protected String _getStringRepresentation(JvmTypeReference object) {
        return this._getStringRepresentation(new LightweightTypeReferenceFactory(this.typeReferenceOwner, true).toLightweightReference(object));
    }

    protected String _getStringRepresentation(LightweightTypeReference object) {
        StringBuilderBasedAppendable appender = new StringBuilderBasedAppendable(this.importManager);
        LightweightTypeReferenceSerializer serializer = new LightweightTypeReferenceSerializer(appender);
        object.accept(serializer);
        return appender.toString();
    }

    protected String _getStringRepresentation(Class<?> object) {
        return this.importManager.serialize(object).toString();
    }

    @Override
    protected List<String> getSignificantContent() {
        List<String> result = super.getSignificantContent();
        if (result.size() >= 1 && Objects.equal(this.getLineDelimiter(), IterableExtensions.last(result))) {
            return result.subList(0, result.size() - 1);
        }
        return result;
    }

    @Override
    protected String getStringRepresentation(Object object) {
        if (object instanceof JvmType) {
            return this._getStringRepresentation((JvmType)object);
        }
        if (object instanceof Class) {
            return this._getStringRepresentation((Class)object);
        }
        if (object instanceof JvmTypeReference) {
            return this._getStringRepresentation((JvmTypeReference)object);
        }
        if (object instanceof LightweightTypeReference) {
            return this._getStringRepresentation((LightweightTypeReference)object);
        }
        if (object != null) {
            return this._getStringRepresentation(object);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object).toString());
    }
}

