/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class TypeReferenceSerializer {
    @Inject
    private Primitives primitives;
    @Inject
    private ILogicalContainerProvider contextProvider;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private CommonTypeComputationServices services;

    public boolean isLocalTypeParameter(EObject context, JvmTypeParameter parameter) {
        if (context == parameter.getDeclarator()) {
            return true;
        }
        if (context instanceof JvmOperation && ((JvmOperation)context).isStatic()) {
            return false;
        }
        if (context instanceof JvmDeclaredType && ((JvmDeclaredType)context).isStatic()) {
            return false;
        }
        JvmIdentifiableElement jvmElement = this.contextProvider.getNearestLogicalContainer(context);
        if (jvmElement != null) {
            return this.isLocalTypeParameter(jvmElement, parameter);
        }
        EObject container2 = context.eContainer();
        if (container2 == null) {
            return false;
        }
        return this.isLocalTypeParameter(container2, parameter);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        IAppendable tracedAppendable = appendable;
        boolean tracing = false;
        if (appendable instanceof ITreeAppendable && type.eResource() == context.eResource()) {
            tracedAppendable = ((ITreeAppendable)appendable).trace(type);
            tracing = true;
        }
        if (type instanceof JvmWildcardTypeReference) {
            EList<JvmTypeConstraint> constraints;
            JvmWildcardTypeReference wildcard = (JvmWildcardTypeReference)type;
            if (!withoutConstraints) {
                tracedAppendable.append("?");
            }
            if (!(constraints = wildcard.getConstraints()).isEmpty()) {
                for (JvmTypeConstraint constraint : constraints) {
                    if (!(constraint instanceof JvmLowerBound)) continue;
                    if (!withoutConstraints) {
                        tracedAppendable.append(" super ");
                    }
                    this.serialize(constraint.getTypeReference(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                    return;
                }
                if (constraints.size() == 1 && Object.class.getName().equals(((JvmTypeConstraint)constraints.get(0)).getTypeReference().getIdentifier())) {
                    return;
                }
                boolean first = true;
                for (JvmTypeConstraint constraint : constraints) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    if (first) {
                        if (!withoutConstraints) {
                            tracedAppendable.append(" extends ");
                        }
                        first = false;
                    } else {
                        if (withoutConstraints) {
                            throw new IllegalStateException("cannot have two upperbounds if type should be printed without constraints");
                        }
                        tracedAppendable.append(" & ");
                    }
                    this.serialize(constraint.getTypeReference(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                }
            } else if (withoutConstraints) {
                tracedAppendable.append("Object");
            }
        } else if (type instanceof JvmGenericArrayTypeReference) {
            this.serialize(((JvmGenericArrayTypeReference)type).getComponentType(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, true);
            tracedAppendable.append("[]");
        } else if (type instanceof JvmInnerTypeReference) {
            JvmInnerTypeReference casted = (JvmInnerTypeReference)type;
            JvmParameterizedTypeReference outer = casted.getOuter();
            this.serialize(outer, context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, true);
            tracedAppendable.append(".");
            tracedAppendable.append(type.getType().getSimpleName());
            this.serializeTypeArguments(casted, context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject);
        } else if (type instanceof JvmParameterizedTypeReference) {
            JvmType jvmType;
            JvmTypeParameter parameter;
            JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)type;
            if ((paramsToWildcard || paramsToObject) && parameterized.getType() instanceof JvmTypeParameter && !this.isLocalTypeParameter(context, parameter = (JvmTypeParameter)parameterized.getType())) {
                if (paramsToWildcard) {
                    tracedAppendable.append("?");
                } else {
                    tracedAppendable.append("Object");
                }
                return;
            }
            JvmType jvmType2 = jvmType = allowPrimitives ? type.getType() : this.primitives.asWrapperTypeIfPrimitive(type).getType();
            if (tracing) {
                ITextRegion region = this.locationProvider.getFullTextRegion(type, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, 0);
                if (region instanceof ITextRegionWithLineInformation) {
                    ((ITreeAppendable)tracedAppendable).trace(new LocationData((ITextRegionWithLineInformation)region, null)).append(jvmType);
                } else {
                    tracedAppendable.append(jvmType);
                }
            } else {
                tracedAppendable.append(jvmType);
            }
            this.serializeTypeArguments(parameterized, context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject);
        } else if (type instanceof JvmAnyTypeReference) {
            tracedAppendable.append("Object");
        } else if (type instanceof JvmMultiTypeReference) {
            this.serialize(this.resolveMultiType(type, context), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
        } else if (type instanceof JvmDelegateTypeReference) {
            JvmTypeReference delegate = ((JvmDelegateTypeReference)type).getDelegate();
            if (delegate != null) {
                this.serialize(delegate, context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
            } else {
                tracedAppendable.append("Object");
            }
        } else if (type instanceof JvmSpecializedTypeReference) {
            this.serialize(((JvmSpecializedTypeReference)type).getEquivalent(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
        } else if (type instanceof JvmUnknownTypeReference) {
            if (type.eIsSet(TypesPackage.Literals.JVM_UNKNOWN_TYPE_REFERENCE__QUALIFIED_NAME)) {
                tracedAppendable.append(type.getQualifiedName());
            } else {
                tracedAppendable.append("Object");
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(type));
        }
    }

    private void serializeTypeArguments(JvmParameterizedTypeReference reference, EObject context, IAppendable tracedAppendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject) {
        if (!reference.getArguments().isEmpty()) {
            tracedAppendable.append("<");
            for (int i = 0; i < reference.getArguments().size(); ++i) {
                if (i != 0) {
                    tracedAppendable.append(", ");
                }
                this.serialize((JvmTypeReference)reference.getArguments().get(i), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
            }
            tracedAppendable.append(">");
        }
    }

    public JvmTypeReference resolveMultiType(JvmTypeReference reference, EObject context) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, context.eResource().getResourceSet());
        return owner.toLightweightTypeReference(reference).toJavaCompliantTypeReference();
    }
}

