/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.internal.CodeGenUtil2;

public class ImportManager {
    private Map<String, String> imports = Maps.newHashMap();
    private boolean organizeImports;
    private String thisTypePackageName;
    private Set<String> thisTypeSimpleNames = Sets.newHashSet();
    private Set<String> thisTypeQualifiedNames = Sets.newHashSet();
    private Map<String, String> qualifiedNamesToPackageNames = Maps.newHashMap();
    private final char innerTypeSeparator;
    private Pattern JAVA_LANG_PACK = Pattern.compile("java\\.lang\\.[\\w]+");
    private boolean thisCollidesWithJavaLang;

    public ImportManager(boolean organizeImports, char innerTypeSeparator) {
        this(organizeImports, null, innerTypeSeparator);
    }

    public ImportManager() {
        this(true, null);
    }

    public ImportManager(boolean organizeImports) {
        this(organizeImports, null);
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType) {
        this(organizeImports, thisType, '.');
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType, char innerTypeSeparator) {
        this.organizeImports = organizeImports;
        this.innerTypeSeparator = innerTypeSeparator;
        if (thisType != null) {
            this.getThisTypeSimpleNames().add(thisType.getSimpleName());
            this.getThisTypeQualifiedNames().add(thisType.getQualifiedName(innerTypeSeparator));
            this.thisCollidesWithJavaLang |= CodeGenUtil2.isJavaLangType(thisType.getSimpleName());
            this.registerSimpleNamesOfInnerClasses(thisType, new LinkedHashSet<JvmType>());
            this.thisTypePackageName = thisType.getPackageName();
        }
    }

    protected void registerSimpleNamesOfInnerClasses(JvmDeclaredType thisType, LinkedHashSet<JvmType> handled) {
        if (!handled.add(thisType)) {
            return;
        }
        List<JvmDeclaredType> nested = EcoreUtil2.typeSelect(thisType.getMembers(), JvmDeclaredType.class);
        for (JvmDeclaredType jvmDeclaredType : nested) {
            this.getThisTypeSimpleNames().add(jvmDeclaredType.getSimpleName());
            this.getThisTypeQualifiedNames().add(jvmDeclaredType.getQualifiedName(this.getInnerTypeSeparator()));
            this.thisCollidesWithJavaLang |= CodeGenUtil2.isJavaLangType(jvmDeclaredType.getSimpleName());
        }
        for (JvmTypeReference superType : thisType.getSuperTypes()) {
            if (!(superType.getType() instanceof JvmDeclaredType)) continue;
            this.registerSimpleNamesOfInnerClasses((JvmDeclaredType)superType.getType(), handled);
        }
    }

    public CharSequence serialize(JvmType type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public CharSequence serialize(Class<?> type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.getInnerTypeSeparator()));
        } else if (type instanceof JvmArrayType) {
            this.appendType(((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String shortName;
            String qualifiedName = type.getQualifiedName(this.getInnerTypeSeparator());
            if (type instanceof JvmDeclaredType) {
                String packageName = ((JvmDeclaredType)type).getPackageName();
                this.qualifiedNamesToPackageNames.put(qualifiedName, packageName);
            }
            String nameToImport = qualifiedName;
            String outerShortName = shortName = type.getSimpleName();
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                JvmType outerContainer = type;
                while (outerContainer.eContainer() instanceof JvmType) {
                    outerContainer = (JvmType)outerContainer.eContainer();
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.getThisTypeQualifiedNames().contains(outerContainer.getQualifiedName(this.getInnerTypeSeparator())) && this.getThisTypeSimpleNames().contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getQualifiedName(this.getInnerTypeSeparator());
                        shortName = outerShortName + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, shortName, outerShortName, nameToImport, builder);
        }
    }

    protected boolean shouldUseQualifiedNestedName(String identifier) {
        return !identifier.startsWith("org.eclipse.xtext.xbase.lib.");
    }

    public void appendType(Class<?> type, StringBuilder builder) {
        if (type.isPrimitive()) {
            builder.append(type.getSimpleName());
        } else if (type.isArray()) {
            this.appendType(type.getComponentType(), builder);
            builder.append("[]");
        } else {
            String shortName;
            String qualifiedName = type.getCanonicalName();
            String packageName = type.getPackage().getName();
            this.qualifiedNamesToPackageNames.put(qualifiedName, packageName);
            String nameToImport = qualifiedName;
            String outerShortName = shortName = type.getSimpleName();
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                Class<?> outerContainer = type;
                while (outerContainer.getDeclaringClass() != null) {
                    outerContainer = outerContainer.getDeclaringClass();
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.getThisTypeQualifiedNames().contains(outerContainer.getCanonicalName()) && this.getThisTypeSimpleNames().contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getCanonicalName();
                        shortName = outerShortName + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, shortName, outerShortName, nameToImport, builder);
        }
    }

    protected void appendType(String qualifiedName, String shortName, String namespaceImport, StringBuilder builder) {
        this.appendType(qualifiedName, shortName, shortName, namespaceImport, builder);
    }

    protected void appendType(String qualifiedName, String shortName, String outerShortName, String namespaceImport, StringBuilder builder) {
        if (this.allowsSimpleName(namespaceImport, shortName)) {
            builder.append(shortName);
        } else if (this.needsQualifiedName(namespaceImport, shortName)) {
            builder.append(qualifiedName);
        } else {
            Map<String, String> imps = this.internalGetImports();
            if (imps.containsKey(outerShortName)) {
                if (namespaceImport.equals(imps.get(outerShortName))) {
                    builder.append(shortName);
                } else {
                    builder.append(qualifiedName);
                }
            } else {
                imps.put(outerShortName, namespaceImport);
                builder.append(shortName);
            }
        }
    }

    protected boolean allowsSimpleName(String qualifiedName, String simpleName) {
        return this.getThisTypeQualifiedNames().contains(qualifiedName) || (!this.thisCollidesWithJavaLang || !this.getThisTypeSimpleNames().contains(simpleName)) && this.JAVA_LANG_PACK.matcher(qualifiedName).matches() || Strings.equal(qualifiedName, simpleName);
    }

    protected boolean needsQualifiedName(String qualifiedName, String simpleName) {
        return !this.organizeImports || this.getThisTypeSimpleNames().contains(simpleName) && !this.getThisTypeQualifiedNames().contains(qualifiedName) || CodeGenUtil2.isJavaLangType(simpleName);
    }

    public boolean addImportFor(JvmType type) {
        String qualifiedName = type.getQualifiedName(this.getInnerTypeSeparator());
        String simpleName = type.getSimpleName();
        Map<String, String> imps = this.internalGetImports();
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || imps.containsKey(simpleName))) {
            imps.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public List<String> getImports() {
        ArrayList<String> result = Lists.newArrayList();
        for (String qualifiedName : this.internalGetImports().values()) {
            if (result.contains(qualifiedName) || this.isInThisTypesPackage(qualifiedName)) continue;
            result.add(qualifiedName);
        }
        Collections.sort(result);
        return result;
    }

    private boolean isInThisTypesPackage(String qualifiedName) {
        String packageName = this.qualifiedNamesToPackageNames.get(qualifiedName);
        return packageName != null && packageName.equals(this.thisTypePackageName);
    }

    protected final Set<String> getThisTypeQualifiedNames() {
        return this.thisTypeQualifiedNames;
    }

    protected final Set<String> getThisTypeSimpleNames() {
        return this.thisTypeSimpleNames;
    }

    protected final Map<String, String> internalGetImports() {
        return this.imports;
    }

    protected final char getInnerTypeSeparator() {
        return this.innerTypeSeparator;
    }
}

