/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.formallang.Production;
import org.eclipse.xtext.util.formallang.ProductionFactory;

public class ProductionUtil {
    protected <S, D, T> List<D> clone(Production<S, T> grammarAdapter, Iterable<S> eles, ProductionFactory<D, T> factory) {
        ArrayList<D> result = Lists.newArrayList();
        for (S ele : eles) {
            result.add(this.clone(grammarAdapter, ele, factory));
        }
        return result;
    }

    public <S, D, T> D clone(Production<S, T> production2, ProductionFactory<D, T> factory) {
        return this.clone(production2, production2.getRoot(), factory);
    }

    public <S, D, T> D clone(Production<S, T> production2, S ele, ProductionFactory<D, T> factory) {
        boolean many = production2.isMany(ele);
        boolean optional = production2.isOptional(ele);
        T token = production2.getToken(ele);
        if (token != null) {
            return factory.createForToken(many, optional, token);
        }
        Iterable<S> alternative = production2.getAlternativeChildren(ele);
        if (alternative != null) {
            return factory.createForAlternativeChildren(many, optional, (Iterable<D>)this.clone(production2, (S)alternative, factory));
        }
        Iterable<S> group = production2.getSequentialChildren(ele);
        if (group != null) {
            return factory.createForSequentialChildren(many, optional, (Iterable<D>)this.clone(production2, (S)group, factory));
        }
        Iterable<S> unorderedgroup = production2.getUnorderedChildren(ele);
        if (unorderedgroup != null) {
            return factory.createForUnordertedChildren(many, optional, (Iterable<D>)this.clone(production2, (S)unorderedgroup, factory));
        }
        return factory.createForToken(many, optional, null);
    }

    public <E, T> E find(Production<E, T> production2, E element, Predicate<E> matches) {
        if (matches.apply(element)) {
            return element;
        }
        Iterable<E> children = this.getChildren(production2, element);
        if (children != null) {
            for (E child : children) {
                E found = this.find(production2, child, matches);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public <E, T> List<E> findAll(Production<E, T> production2, E element, Predicate<E> matches) {
        ArrayList result = Lists.newArrayList();
        this.findAll(production2, element, matches, result);
        return result;
    }

    protected <E, T> void findAll(Production<E, T> production2, E element, Predicate<E> matches, List<E> result) {
        Iterable<E> children;
        if (matches.apply(element)) {
            result.add(element);
        }
        if ((children = this.getChildren(production2, element)) != null) {
            for (E child : children) {
                this.findAll(production2, child, matches, result);
            }
        }
    }

    public <E, T> E find(Production<E, T> production2, Predicate<E> matches) {
        return this.find(production2, production2.getRoot(), matches);
    }

    public <E, T> E findByToken(final Production<E, T> production2, E element, final Predicate<T> matches) {
        return this.find(production2, element, new Predicate<E>(){

            @Override
            public boolean apply(E input) {
                Object token = production2.getToken(input);
                return token != null && matches.apply(token);
            }
        });
    }

    public <E, T> E findByToken(Production<E, T> production2, Predicate<T> matches) {
        return this.findByToken(production2, production2.getRoot(), matches);
    }

    public <E, T> E findByToken(Production<E, T> production2, T matches) {
        return this.findByToken(production2, (T)Predicates.equalTo(matches));
    }

    protected <E, T> void getAllChildren(Production<E, T> production2, E element, List<E> result) {
        result.add(element);
        Iterable<E> children = this.getChildren(production2, element);
        if (children != null) {
            for (E child : children) {
                this.getAllChildren(production2, child, result);
            }
        }
    }

    public <E, T> List<E> getAllChildren(Production<E, T> production2, E element) {
        ArrayList result = Lists.newArrayList();
        this.getAllChildren(production2, element, result);
        return result;
    }

    public <E, T> E getRoot(Production<E, T> prod, E element) {
        E current = element;
        E parent = prod.getParent(current);
        while (parent != null) {
            current = parent;
            parent = prod.getParent(current);
        }
        return current;
    }

    public <E, T> Iterable<E> getChildren(Production<E, T> production2, E element) {
        Iterable<E> result = production2.getSequentialChildren(element);
        if (result != null) {
            return result;
        }
        result = production2.getAlternativeChildren(element);
        if (result != null) {
            return result;
        }
        result = production2.getUnorderedChildren(element);
        if (result != null) {
            return result;
        }
        return null;
    }
}

