/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MergeableManifest2
implements Cloneable {
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String SIGNATURE_VERSION = "Signature-Version";
    public static final String REQUIRE_BUNDLE = "Require-Bundle";
    public static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String EXPORT_PACKAGE = "Export-Package";
    public static final String IMPORT_PACKAGE = "Import-Package";
    public static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public static final String BUNDLE_ACTIVATOR = "Bundle-Activator";
    private String name;
    private String version;
    private String bree;
    private String bundleActivator;
    private String newline = System.lineSeparator();
    private Attributes mainAttributes = new Attributes();
    private Map<String, Attributes> entries = new LinkedHashMap<String, Attributes>();
    private boolean modified;
    private Pattern emptyEntryPattern = this.newEmptyLinePattern();

    public MergeableManifest2(InputStream stream, String name) throws IOException {
        this.name = name;
        this.read(stream);
        this.modified = false;
    }

    private Pattern newEmptyLinePattern() {
        return Pattern.compile("," + this.newline + " [ \t]*," + this.newline + " ");
    }

    public MergeableManifest2(InputStream stream) throws IOException {
        this.read(stream);
        this.modified = false;
    }

    public MergeableManifest2(MergeableManifest2 toCopy) {
        this.name = toCopy.name;
        this.version = toCopy.version;
        this.newline = toCopy.newline;
        this.emptyEntryPattern = this.newEmptyLinePattern();
        this.mainAttributes.putAll(toCopy.mainAttributes);
        this.entries.putAll(toCopy.entries);
        this.modified = false;
    }

    private void read(InputStream stream) throws IOException {
        this.read(new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.toList()));
    }

    private void read(List<String> lines) throws IOException {
        int lineIndex = this.readHeader(lines, 0);
        this.readEntries(lines, lineIndex);
    }

    private int readHeader(List<String> lines, int startIndex) throws IOException {
        int lineIndex = startIndex;
        while (lineIndex < lines.size()) {
            String line = lines.get(lineIndex);
            if (line.length() > 512) {
                throw new IOException("Line is to long '" + line + "'");
            }
            ++lineIndex;
            while (lineIndex < lines.size() && lines.get(lineIndex).startsWith(" ")) {
                line = line + this.newline + lines.get(lineIndex);
                ++lineIndex;
            }
            if (line.isEmpty()) {
                return lineIndex;
            }
            if (line.contains(": ")) {
                String[] split = line.split(": ", 2);
                String name = split[0];
                if (!this.isValidName(name)) {
                    throw new IOException("Missing name of value");
                }
                String value = split[1];
                if (name.equals(MANIFEST_VERSION)) {
                    this.version = value;
                } else if (this.version == null && name.equals(SIGNATURE_VERSION)) {
                    this.version = value;
                } else if (name.equals(BUNDLE_SYMBOLIC_NAME)) {
                    this.name = Bundle.fromInput(value).getName();
                } else if (name.equals(BUNDLE_REQUIREDEXECUTIONENVIRONMENT)) {
                    this.bree = value;
                } else if (name.equals(BUNDLE_ACTIVATOR)) {
                    this.bundleActivator = value;
                } else if (name.equals(REQUIRE_BUNDLE) || name.equals(EXPORT_PACKAGE) || name.equals(IMPORT_PACKAGE)) {
                    value = this.filterEmptyBundles(value);
                }
                this.mainAttributes.put(name, value);
                continue;
            }
            throw new IOException("Missing ': '");
        }
        return lineIndex;
    }

    private String filterEmptyBundles(String bundleString) {
        Matcher matcher;
        String result = bundleString.trim();
        if (result.startsWith("," + this.newline + " ")) {
            result = result.substring(("," + this.newline + " ").length(), result.length());
        }
        if ((result = (matcher = this.emptyEntryPattern.matcher(result)).replaceAll("," + this.newline + " ")).endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void readEntries(List<String> lines, int startIndex) throws IOException {
        int lineIndex = startIndex;
        Attributes attributes = null;
        while (lineIndex < lines.size()) {
            String line = lines.get(lineIndex);
            ++lineIndex;
            while (lineIndex < lines.size() && lines.get(lineIndex).startsWith(" ")) {
                line = line + lines.get(lineIndex).substring(1);
                ++lineIndex;
            }
            if (line.toLowerCase().startsWith("name: ")) {
                String name = line.substring("name: ".length());
                attributes = this.entries.get(name);
                if (attributes != null) continue;
                attributes = new Attributes();
                this.entries.put(name, attributes);
                continue;
            }
            if (line.contains(": ")) {
                String[] split = line.split(": ", 2);
                String name = split[0];
                if (!this.isValidName(name)) {
                    throw new IOException("Missing name of value");
                }
                String value = split[1];
                if (attributes == null) {
                    throw new IOException("Missing name of entry");
                }
                attributes.put(name, value);
                continue;
            }
            if (line.isEmpty()) continue;
            throw new IOException("Missing ': '");
        }
    }

    private boolean isValidName(String name) {
        if (name.isEmpty() || name.length() > 70) {
            return false;
        }
        for (int n = 0; n < name.length(); ++n) {
            char c = name.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Attributes getAttributes(String name) {
        return this.entries.get(name);
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void clear() {
        this.mainAttributes.clear();
        this.entries.clear();
    }

    public void addRequiredBundles(Set<String> requiredBundles) {
        this.addRequiredBundles(requiredBundles.toArray(new String[requiredBundles.size()]));
    }

    public void addRequiredBundles(String ... requiredBundles) {
        String oldBundles = this.mainAttributes.get(REQUIRE_BUNDLE);
        if (oldBundles == null) {
            oldBundles = "";
        }
        BundleList oldResultList = BundleList.fromInput(oldBundles, this.newline);
        BundleList resultList = BundleList.fromInput(oldBundles, this.newline);
        for (String bundle : requiredBundles) {
            Bundle newBundle = Bundle.fromInput(bundle);
            if (this.name != null && this.name.equals(newBundle.getName())) continue;
            resultList.mergeInto(newBundle);
        }
        String result = resultList.toString();
        boolean changed = !oldResultList.toString().equals(result);
        this.modified |= changed;
        if (changed) {
            this.mainAttributes.put(REQUIRE_BUNDLE, result);
        }
    }

    public void addImportedPackages(Set<String> importedPackages) {
        this.addImportedPackages(importedPackages.toArray(new String[importedPackages.size()]));
    }

    public void addImportedPackages(String ... importedPackages) {
        String oldBundles = this.mainAttributes.get(IMPORT_PACKAGE);
        if (oldBundles == null) {
            oldBundles = "";
        }
        BundleList oldResultList = BundleList.fromInput(oldBundles, this.newline);
        BundleList resultList = BundleList.fromInput(oldBundles, this.newline);
        for (String bundle : importedPackages) {
            resultList.mergeInto(Bundle.fromInput(bundle));
        }
        String result = resultList.toString();
        boolean changed = !oldResultList.toString().equals(result);
        this.modified |= changed;
        if (changed) {
            this.mainAttributes.put(IMPORT_PACKAGE, result);
        }
    }

    public void addExportedPackages(Set<String> exportedPackages) {
        this.addExportedPackages(exportedPackages.toArray(new String[exportedPackages.size()]));
    }

    public void addExportedPackages(String ... exportedPackages) {
        String oldBundles = this.mainAttributes.get(EXPORT_PACKAGE);
        if (oldBundles == null) {
            oldBundles = "";
        }
        BundleList oldResultList = BundleList.fromInput(oldBundles, this.newline);
        BundleList resultList = BundleList.fromInput(oldBundles, this.newline);
        for (String bundle : exportedPackages) {
            resultList.mergeInto(Bundle.fromInput(bundle));
        }
        String result = resultList.toString();
        boolean changed = !oldResultList.toString().equals(result);
        this.modified |= changed;
        if (changed) {
            this.mainAttributes.put(EXPORT_PACKAGE, result);
        }
    }

    public void setBREE(String bree) {
        String old = this.mainAttributes.get(BUNDLE_REQUIREDEXECUTIONENVIRONMENT);
        if (!bree.equals(old)) {
            this.mainAttributes.put(BUNDLE_REQUIREDEXECUTIONENVIRONMENT, bree);
            this.modified = true;
            this.bree = bree;
        }
    }

    public String getBREE() {
        return this.bree;
    }

    public void setBundleActivator(String bundleActivator) {
        String old = this.mainAttributes.get(BUNDLE_ACTIVATOR);
        if (!bundleActivator.equals(old)) {
            this.mainAttributes.put(BUNDLE_ACTIVATOR, bundleActivator);
            this.modified = true;
            this.bundleActivator = bundleActivator;
        }
    }

    public String getBundleActivator() {
        return this.bundleActivator;
    }

    public void setLineDelimiter(String lineDelimeter) {
        this.newline = lineDelimeter;
        this.emptyEntryPattern = this.newEmptyLinePattern();
    }

    public void write(OutputStream stream) throws IOException {
        this.write(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    private void write(BufferedWriter writer) throws IOException {
        this.writeHeader(writer);
        this.writeEntries(writer);
        writer.flush();
    }

    private void writeHeader(BufferedWriter writer) throws IOException {
        String signatureVersion;
        String manifestVersion = this.mainAttributes.get(MANIFEST_VERSION);
        if (manifestVersion != null) {
            writer.append(MANIFEST_VERSION).append(": ").append(manifestVersion).append(this.newline);
        }
        if ((signatureVersion = this.mainAttributes.get(SIGNATURE_VERSION)) != null) {
            writer.append(SIGNATURE_VERSION).append(": ").append(signatureVersion).append(this.newline);
        }
        for (Map.Entry<String, String> entry : this.mainAttributes.entrySet()) {
            String key = entry.getKey();
            if (key.equals(MANIFEST_VERSION) || key.equals(SIGNATURE_VERSION)) continue;
            String value = this.mainAttributes.get(entry.getKey());
            writer.append(MergeableManifest2.make512Safe(new StringBuffer(key + ": " + value), this.newline));
        }
    }

    private void writeEntries(BufferedWriter writer) throws IOException {
        for (Map.Entry<String, Attributes> entry : this.entries.entrySet()) {
            writer.write(this.newline);
            writer.append("Name: ").append(entry.getKey()).append(this.newline);
            for (Map.Entry<String, String> child : entry.getValue().entrySet()) {
                String key = child.getKey();
                String value = child.getValue();
                if (value.isEmpty()) continue;
                writer.append(MergeableManifest2.make512Safe(new StringBuffer(key + ": " + value), this.newline));
            }
        }
    }

    private static List<String> splitAtCharHonorQuoting(String value, char c) {
        if (value.indexOf(c) == -1) {
            return Collections.singletonList(value);
        }
        ArrayList<String> result = new ArrayList<String>();
        String rest = value;
        while (!rest.isEmpty()) {
            int commaIndex = rest.indexOf(c);
            if (commaIndex == -1) {
                result.add(rest);
                break;
            }
            int quote0Index = rest.indexOf(34);
            if (quote0Index == -1 || commaIndex < quote0Index) {
                result.add(rest.substring(0, commaIndex));
                rest = rest.substring(commaIndex + 1);
                continue;
            }
            int quote1Index = rest.indexOf(34, quote0Index + 1);
            if (quote1Index == -1) {
                result.add(rest.substring(0, commaIndex));
                rest = rest.substring(commaIndex + 1);
                continue;
            }
            commaIndex = rest.indexOf(c, quote1Index);
            if (commaIndex == -1) {
                result.add(rest);
                rest = "";
                continue;
            }
            result.add(rest.substring(0, commaIndex));
            rest = rest.substring(commaIndex + 1);
        }
        return result;
    }

    public MergeableManifest2 clone() throws CloneNotSupportedException {
        return new MergeableManifest2(this);
    }

    public static String make512Safe(StringBuffer input, String newline) {
        String content;
        StringBuilder result = new StringBuilder();
        String rest = content = input.toString();
        while (!rest.isEmpty()) {
            if (rest.contains("\n")) {
                String line = rest.substring(0, rest.indexOf("\n"));
                rest = rest.substring(rest.indexOf("\n") + 1);
                if (line.length() > 1 && line.charAt(line.length() - 1) == '\r') {
                    line = line.substring(0, line.length() - 1);
                }
                MergeableManifest2.append512Safe(line, result, newline);
                continue;
            }
            MergeableManifest2.append512Safe(rest, result, newline);
            break;
        }
        return result.toString();
    }

    private static void append512Safe(String toAppend, StringBuilder result, String newline) {
        boolean hasAppended = false;
        while (toAppend.length() > 512) {
            if (hasAppended) {
                result.append(" ");
            }
            hasAppended = true;
            result.append(toAppend.substring(0, 510)).append(newline);
            toAppend = toAppend.substring(510);
        }
        if (hasAppended) {
            result.append(" ");
        }
        result.append(toAppend).append(newline);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.mainAttributes == null ? 0 : this.mainAttributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeableManifest2 other = (MergeableManifest2)obj;
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return !(this.mainAttributes == null ? other.mainAttributes != null : !this.mainAttributes.equals(other.mainAttributes));
    }

    private static class Bundle {
        private final String input;
        private final List<String> split;

        public static Bundle fromInput(String input) {
            return new Bundle(input);
        }

        public static Bundle fromBundleWithNewName(Bundle bundle, String newName) {
            if (bundle.getSuffix() == null) {
                return new Bundle(newName);
            }
            return new Bundle(newName + ";" + bundle.getSuffix());
        }

        public static Bundle fromNameVersion(String name, String version2) {
            return new Bundle(name + ";bundle-version=\"" + version2 + "\"");
        }

        public static Bundle fromNameVersionSuffix(String name, String version2, String suffix) {
            return new Bundle(name + ";bundle-version=\"" + version2 + "\";" + suffix);
        }

        private Bundle(String input) {
            this.input = input;
            this.split = this.input.contains(";") ? Collections.unmodifiableList(MergeableManifest2.splitAtCharHonorQuoting(this.input, ';')) : Collections.singletonList(this.input);
        }

        public boolean hasSameName(Bundle other) {
            return Objects.equals(this.getName(), other.getName());
        }

        public String getName() {
            return this.split.get(0).trim().replaceAll("\r?\n ", "");
        }

        public String getNameIncludingWhitespacePrefix() {
            return this.split.get(0);
        }

        public String getSuffix() {
            return this.split.size() > 1 ? (String)this.split.subList(1, this.split.size()).stream().reduce((a, b) -> a + ";" + b).get() : null;
        }

        public String getVersion() {
            for (int n = 1; n < this.split.size(); ++n) {
                String part = this.split.get(n).trim().replaceAll("\r?\n ", "");
                if (!part.contains("bundle-version=")) continue;
                int startIndex = part.indexOf("bundle-version=") + "bundle-version=".length();
                if (part.charAt(startIndex) == '\"') {
                    return part.substring(startIndex + 1, part.indexOf("\"", startIndex + 1)).trim().replaceAll("\r?\n ", "");
                }
                return part.substring(startIndex).trim().replaceAll("\r?\n ", "");
            }
            return null;
        }

        public String toString() {
            String bundleName = this.split.get(0);
            String bundleVersion = this.getVersion();
            String bundleSuffix = this.getSuffix();
            if (bundleVersion == null && bundleSuffix == null) {
                return bundleName;
            }
            return bundleName + ";" + bundleSuffix;
        }
    }

    private static class BundleList {
        private final List<Bundle> list;
        private final String newline;

        public BundleList(List<Bundle> list, String newline) {
            this.list = list;
            this.newline = newline;
        }

        private static BundleList fromInput(String input, String newline) {
            if (input.isEmpty()) {
                return new BundleList(new ArrayList<Bundle>(), newline);
            }
            return new BundleList(MergeableManifest2.splitAtCharHonorQuoting(input, ',').stream().map(s2 -> Bundle.fromInput(s2)).filter(b -> !"".equals(b.getName())).collect(Collectors.toList()), newline);
        }

        public void mergeInto(Bundle newBundle) {
            if (this.list.isEmpty()) {
                this.list.add(newBundle);
                return;
            }
            boolean merged = false;
            for (int i = 0; i < this.list.size(); ++i) {
                Bundle oldBundle = this.list.get(i);
                if (!oldBundle.hasSameName(newBundle)) continue;
                String oldBundleNameIncludingWhitespacePrefix = oldBundle.getNameIncludingWhitespacePrefix();
                String oldBundleVersion = oldBundle.getVersion();
                String oldBundleSuffix = oldBundle.getSuffix();
                String bundleVersion = oldBundleVersion == null ? newBundle.getVersion() : oldBundleVersion;
                merged = true;
                if (bundleVersion == null) continue;
                if (oldBundleSuffix == null) {
                    this.list.set(i, Bundle.fromNameVersion(oldBundleNameIncludingWhitespacePrefix, bundleVersion));
                    continue;
                }
                if (oldBundleVersion != null) continue;
                this.list.set(i, Bundle.fromNameVersionSuffix(oldBundleNameIncludingWhitespacePrefix, bundleVersion, oldBundleSuffix));
            }
            if (!merged && !"".equals(newBundle.getName())) {
                this.list.add(Bundle.fromBundleWithNewName(newBundle, this.newline + " " + newBundle.getName()));
            }
        }

        public String toString() {
            String separator = "";
            StringBuilder result = new StringBuilder("");
            for (Bundle bundle : this.list) {
                result.append(separator).append(bundle);
                separator = ",";
            }
            return result.toString();
        }
    }

    public class Attributes
    implements Map<String, String> {
        private LinkedHashMap<String, String> content = new LinkedHashMap();

        @Override
        public int size() {
            return this.content.size();
        }

        @Override
        public boolean isEmpty() {
            return this.content.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.content.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.content.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return this.content.get(key);
        }

        @Override
        public String put(String key, String value) {
            if (value.equals(this.content.get(key))) {
                return value;
            }
            MergeableManifest2.this.modified = true;
            return this.content.put(key, value);
        }

        @Override
        public String remove(Object key) {
            MergeableManifest2.this.modified = true;
            return (String)this.content.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m3) {
            MergeableManifest2.this.modified = true;
            this.content.putAll(m3);
        }

        @Override
        public void clear() {
            MergeableManifest2.this.modified = true;
            this.content.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.content.keySet();
        }

        @Override
        public Collection<String> values() {
            return this.content.values();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.content.entrySet();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attributes other = (Attributes)obj;
            return !(this.content == null ? other.content != null : !this.content.equals(other.content));
        }
    }
}

