/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class EmfStructureComparator {
    protected static final Logger log = Logger.getLogger(EmfStructureComparator.class);
    private int counter;
    private StringBuilder errorMessage = new StringBuilder(512);

    public void assertSameStructure(EObject left, EObject right) {
        if (!this.isSameStructure(left, right)) {
            log.error(this.getErrorMessage());
            throw new AssertionError((Object)this.getErrorMessage());
        }
        if (log.isTraceEnabled()) {
            log.trace("" + this.counter + " elements compared");
        }
    }

    protected String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public boolean isSameStructure(EObject left, EObject right) {
        this.counter = 0;
        return this.internalIsSameStructure(left, right);
    }

    public boolean internalIsSameStructure(EObject left, EObject right) {
        ++this.counter;
        if (left == null) {
            this.errorMessage.append("left hand side was null").append('\n');
            return false;
        }
        if (right == null) {
            this.errorMessage.append("right hand side was null.").append('\n');
            return false;
        }
        if (!this.isSameClass(left.eClass(), right.eClass())) {
            this.errorMessage.append("Classes are not equal: " + left + " != " + right).append('\n');
            return false;
        }
        List<EObject> leftChildren = this.getRelevantChildren(left);
        List<EObject> rightChildren = this.getRelevantChildren(right);
        if (leftChildren.size() != rightChildren.size()) {
            this.errorMessage.append("Number of children differs " + left + " " + right + " " + leftChildren.size() + " <> " + rightChildren.size()).append('\n');
            return false;
        }
        for (int i = 0; i < leftChildren.size(); ++i) {
            if (this.internalIsSameStructure(leftChildren.get(i), rightChildren.get(i))) continue;
            this.errorMessage.append("Children differ " + left + " " + right + " with children " + leftChildren.get(i) + " " + rightChildren.get(i)).append('\n');
            return false;
        }
        return true;
    }

    protected boolean isSameClass(EClass left, EClass right) {
        return left.getName().equals(right.getName()) && left.getEPackage().getNsURI().equals(right.getEPackage().getNsURI());
    }

    protected List<EObject> getRelevantChildren(EObject _this) {
        ArrayList<EObject> relevantChildren = new ArrayList<EObject>(_this.eContents());
        Iterator i = relevantChildren.iterator();
        while (i.hasNext()) {
            EObject next = (EObject)i.next();
            if (this.isRelevantChild(_this, next)) continue;
            i.remove();
        }
        return relevantChildren;
    }

    protected boolean isRelevantChild(EObject container2, EObject child) {
        return true;
    }
}

