/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Beta
public class ChunkedResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions,
Externalizable {
    protected ConcurrentHashMap<String, ResourceDescriptionsData> chunk2resourceDescriptions = new ConcurrentHashMap();
    protected ResourceSet resourceSet;

    public ChunkedResourceDescriptions() {
    }

    public ChunkedResourceDescriptions(Map<String, ResourceDescriptionsData> initialData) {
        this.chunk2resourceDescriptions = new ConcurrentHashMap<String, ResourceDescriptionsData>(initialData);
    }

    public ChunkedResourceDescriptions(Map<String, ResourceDescriptionsData> initialData, ResourceSet resourceSet) {
        this(initialData);
        this.setResourceSet(resourceSet);
    }

    public ChunkedResourceDescriptions createShallowCopyWith(ResourceSet resourceSet) {
        return new ChunkedResourceDescriptions(this.chunk2resourceDescriptions, resourceSet);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void setResourceSet(ResourceSet resourceSet) {
        if (this.resourceSet != null) {
            throw new IllegalStateException("This " + this.getClass().getName() + " is already associated with a different resource set.");
        }
        if (ChunkedResourceDescriptions.findInEmfObject(resourceSet) != null) {
            throw new IllegalStateException("There is already a different " + this.getClass().getName() + " installed in the given resource set.");
        }
        this.resourceSet = resourceSet;
        this.attachToEmfObject(resourceSet);
    }

    public ResourceDescriptionsData setContainer(String name, ResourceDescriptionsData descriptions) {
        return this.chunk2resourceDescriptions.put(name, descriptions);
    }

    public ResourceDescriptionsData removeContainer(String name) {
        return this.chunk2resourceDescriptions.remove(name);
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.chunk2resourceDescriptions.values();
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.concat(Iterables.transform(this.chunk2resourceDescriptions.values(), it -> it.getAllResourceDescriptions()));
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        for (ResourceDescriptionsData selectable : this.chunk2resourceDescriptions.values()) {
            IResourceDescription result = selectable.getResourceDescription(uri);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ResourceDescriptionsData getContainer(URI uri) {
        for (ResourceDescriptionsData container2 : this.chunk2resourceDescriptions.values()) {
            IResourceDescription description = container2.getResourceDescription(uri);
            if (description == null) continue;
            return container2;
        }
        return null;
    }

    public ResourceDescriptionsData getContainer(String containerHandle) {
        return this.chunk2resourceDescriptions.get(containerHandle);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numChunks = in.readInt();
        for (int i = 0; i < numChunks; ++i) {
            String chunkName = in.readUTF();
            int numDescriptions = in.readInt();
            ArrayList<IResourceDescription> descriptions = new ArrayList<IResourceDescription>(numDescriptions);
            for (int j = 0; j < numDescriptions; ++j) {
                descriptions.add((IResourceDescription)in.readObject());
            }
            this.chunk2resourceDescriptions.put(chunkName, new ResourceDescriptionsData(descriptions));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap<String, ResourceDescriptionsData> copy = new HashMap<String, ResourceDescriptionsData>(this.chunk2resourceDescriptions);
        out.writeInt(copy.entrySet().size());
        for (Map.Entry entry : copy.entrySet()) {
            out.writeUTF((String)entry.getKey());
            Iterable descriptions = Iterables.transform(((ResourceDescriptionsData)entry.getValue()).getAllResourceDescriptions(), d -> d instanceof Serializable ? d : SerializableResourceDescription.createCopy(d));
            out.writeInt(IterableExtensions.size(descriptions));
            for (Object d2 : descriptions) {
                out.writeObject(d2);
            }
        }
    }

    public static ChunkedResourceDescriptions findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof ChunkedResourceDescriptionsAdapter)) continue;
            return ((ChunkedResourceDescriptionsAdapter)adapter).get();
        }
        return null;
    }

    public static ChunkedResourceDescriptions removeFromEmfObject(Notifier emfObject) {
        EList<Adapter> adapters = emfObject.eAdapters();
        for (int i = 0; i < adapters.size(); ++i) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (!(adapter instanceof ChunkedResourceDescriptionsAdapter)) continue;
            return ((ChunkedResourceDescriptionsAdapter)emfObject.eAdapters().remove(i)).get();
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        ChunkedResourceDescriptions result = ChunkedResourceDescriptions.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for ChunkedResourceDescriptions");
        }
        ChunkedResourceDescriptionsAdapter adapter = new ChunkedResourceDescriptionsAdapter(this);
        emfObject.eAdapters().add(adapter);
    }

    public static class ChunkedResourceDescriptionsAdapter
    extends AdapterImpl {
        private ChunkedResourceDescriptions element;

        public ChunkedResourceDescriptionsAdapter(ChunkedResourceDescriptions element) {
            this.element = element;
        }

        public ChunkedResourceDescriptions get() {
            return this.element;
        }

        @Override
        public boolean isAdapterForType(Object object) {
            return object == ChunkedResourceDescriptions.class;
        }
    }
}

