/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.containers.IAllContainersState;

public class ResourceSetBasedAllContainersState
implements IAllContainersState {
    private SetMultimap<String, URI> container2URIs;
    private SetMultimap<URI, String> uri2container;
    private List<String> containers;

    public void configure(List<String> containers, Multimap<String, URI> container2Uris) {
        this.containers = containers;
        this.container2URIs = HashMultimap.create(container2Uris);
        this.uri2container = Multimaps.invertFrom(HashMultimap.create(container2Uris), HashMultimap.create());
    }

    @Override
    public List<String> getVisibleContainerHandles(String handle) {
        return this.containers;
    }

    @Override
    public Collection<URI> getContainedURIs(String containerHandle) {
        return this.container2URIs.get((Object)containerHandle);
    }

    @Override
    public boolean isEmpty(String containerHandle) {
        return this.getContainedURIs(containerHandle).isEmpty();
    }

    @Override
    public String getContainerHandle(URI uri) {
        Collection set = this.uri2container.get((Object)uri);
        if (set != null && !set.isEmpty()) {
            return (String)set.iterator().next();
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        HashSet invisibleContainers = Sets.newHashSet(this.container2URIs.keySet());
        invisibleContainers.removeAll(this.containers);
        if (!invisibleContainers.isEmpty()) {
            result.append("\n  WARNING: invisible containers: ");
            result.append(Joiner.on(", ").join(invisibleContainers));
        }
        for (String container2 : this.containers) {
            Collection uris = this.container2URIs.get((Object)container2);
            result.append("\n  container ");
            result.append(container2);
            result.append(" = ");
            if (uris.isEmpty()) {
                result.append("(empty)");
                continue;
            }
            result.append("{\n    ");
            result.append(Joiner.on("\n    ").join(uris));
            result.append("\n  }");
        }
        result.append("\n]");
        return result.toString();
    }
}

