/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.LiveShadowedChunkedContainer;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.LiveShadowedChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsBasedContainer;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;

@Beta
public class ProjectDescriptionBasedContainerManager
implements IContainer.Manager {
    public boolean shouldUseProjectDescriptionBasedContainers(IResourceDescriptions resourceDescriptions) {
        ChunkedResourceDescriptions descriptions = this.getChunkedResourceDescriptions(resourceDescriptions);
        return descriptions != null && descriptions.getResourceSet() != null && ProjectDescription.findInEmfObject(descriptions.getResourceSet()) != null;
    }

    @Override
    public IContainer getContainer(IResourceDescription desc, IResourceDescriptions resourceDescriptions) {
        ChunkedResourceDescriptions descriptions = this.getChunkedResourceDescriptions(resourceDescriptions);
        if (descriptions == null) {
            throw new IllegalArgumentException("Expected " + ChunkedResourceDescriptions.class.getName());
        }
        return this.createContainer(resourceDescriptions, descriptions, ProjectDescription.findInEmfObject(descriptions.getResourceSet()).getName());
    }

    @Override
    public List<IContainer> getVisibleContainers(IResourceDescription desc, IResourceDescriptions resourceDescriptions) {
        ChunkedResourceDescriptions descriptions = this.getChunkedResourceDescriptions(resourceDescriptions);
        if (descriptions == null) {
            throw new IllegalArgumentException("Expected " + ChunkedResourceDescriptions.class.getName());
        }
        ProjectDescription projectDescription = ProjectDescription.findInEmfObject(descriptions.getResourceSet());
        ArrayList<IContainer> allContainers = new ArrayList<IContainer>();
        allContainers.add(this.createContainer(resourceDescriptions, descriptions, projectDescription.getName()));
        for (String name : projectDescription.getDependencies()) {
            allContainers.add(this.createContainer(resourceDescriptions, descriptions, name));
        }
        return allContainers;
    }

    protected ChunkedResourceDescriptions getChunkedResourceDescriptions(IResourceDescriptions resourceDescriptions) {
        if (resourceDescriptions instanceof ChunkedResourceDescriptions) {
            return (ChunkedResourceDescriptions)resourceDescriptions;
        }
        if (resourceDescriptions instanceof LiveShadowedChunkedResourceDescriptions) {
            return this.getChunkedResourceDescriptions(((LiveShadowedChunkedResourceDescriptions)resourceDescriptions).getGlobalDescriptions());
        }
        return null;
    }

    protected IContainer createContainer(IResourceDescriptions resourceDescriptions, ChunkedResourceDescriptions chunkedResourceDescriptions, String projectName) {
        if (resourceDescriptions instanceof LiveShadowedChunkedResourceDescriptions) {
            return new LiveShadowedChunkedContainer((LiveShadowedChunkedResourceDescriptions)resourceDescriptions, projectName);
        }
        ResourceDescriptionsData container2 = chunkedResourceDescriptions.getContainer(projectName);
        return new ResourceDescriptionsBasedContainer(container2 != null ? container2 : new ResourceDescriptionsData(Collections.emptySet()));
    }
}

