/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.xtext.resource.ClasspathUriUtil;

public class XtextPlatformResourceURIHandler
extends URIHandlerImpl {
    private ResourceSet resourceSet;

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public URI resolve(URI uri) {
        if (this.resolve && this.baseURI != null && uri.isRelative() && uri.hasRelativePath() && !this.resourceSet.getPackageRegistry().containsKey(uri.trimFragment().toString())) {
            URI result = uri.resolve(this.baseURI);
            if (this.baseURI.isPlatform()) {
                if (result.isPlatform() && !result.isPlatformPlugin() && !result.isPlatformResource()) {
                    String[] segments = this.getRelevantPlatformSegments(result);
                    URI newResult = this.baseURI.trimSegments(this.baseURI.segmentCount() - 1).appendSegments(segments);
                    newResult = newResult.appendFragment(result.fragment());
                    return newResult;
                }
            } else if (ClasspathUriUtil.isClasspathUri(this.baseURI) && ClasspathUriUtil.isClasspathUri(result) && "..".equals(result.segment(0))) {
                String[] segments = this.getRelevantClasspathSegments(result);
                URI newResult = URI.createHierarchicalURI(result.scheme(), result.authority(), result.device(), segments, result.query(), result.fragment());
                return newResult;
            }
            return result;
        }
        return uri;
    }

    protected String[] getRelevantClasspathSegments(URI uri) {
        List<String> resultSegments = uri.segmentsList();
        int size = resultSegments.size();
        for (int i = 0; i < size; ++i) {
            if ("..".equals(resultSegments.get(i))) continue;
            if (i != 0) {
                int skip = i * 2;
                String[] segments = new String[size - skip];
                int j = skip;
                int k = 0;
                while (j < size) {
                    segments[k] = resultSegments.get(j);
                    ++j;
                    ++k;
                }
                return segments;
            }
            String[] segments = uri.segments();
            return segments;
        }
        return uri.segments();
    }

    protected String[] getRelevantPlatformSegments(URI uri) {
        List<String> resultSegments = uri.segmentsList();
        int size = resultSegments.size();
        for (int i = 0; i < size; ++i) {
            String[] segments;
            String segment = resultSegments.get(i);
            if ("..".equals(segment)) continue;
            if (i == 0) {
                String nextSegment;
                if (this.isXtextSourceFolderName(segment)) {
                    ++i;
                } else if (i < size - 1 && this.isXtextSourceFolderName(nextSegment = resultSegments.get(i + 1))) {
                    String[] segments2 = new String[size - i - 1];
                    segments2[0] = segment;
                    int j = i + 2;
                    int k = 1;
                    while (j < size) {
                        segments2[k] = resultSegments.get(j);
                        ++j;
                        ++k;
                    }
                    return segments2;
                }
            }
            if (i != 0 && i != size) {
                segments = new String[size - i];
                int j = i;
                int k = 0;
                while (j < size) {
                    segments[k] = resultSegments.get(j);
                    ++j;
                    ++k;
                }
                return segments;
            }
            segments = uri.segments();
            return segments;
        }
        return uri.segments();
    }

    protected boolean isXtextSourceFolderName(String segment) {
        return "src".equals(segment) || "src-gen".equals(segment);
    }
}

