/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.preferences;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.preferences.PreferenceKey;

public class PreferenceKeysProvider {
    private static final Logger log = Logger.getLogger(PreferenceKeysProvider.class);

    public static Set<? extends PreferenceKey> allConstantKeys(Class<?> ... constantsContainer) {
        LinkedHashSet<PreferenceKey> result = Sets.newLinkedHashSet();
        for (Class<?> container2 : constantsContainer) {
            Field[] fields;
            for (Field field : fields = container2.getFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof PreferenceKey)) continue;
                    result.add((PreferenceKey)fieldValue);
                }
                catch (IllegalArgumentException e) {
                    log.error(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }
}

