/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.EmfFormatter;

public class CrossReferenceSerializer
implements ITokenSerializer.ICrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private ILinkingService linkingService;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IValueConverterService valueConverter;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    @Override
    public boolean equalsOrReplacesNode(EObject context, CrossReference crossref, EObject target, INode node) {
        if (crossref != node.getGrammarElement()) {
            return false;
        }
        EReference ref = GrammarUtil.getReference(crossref);
        if (!ref.isMany()) {
            return true;
        }
        List<EObject> objects = this.linkingService.getLinkedObjects(context, ref, node);
        return objects.contains(target);
    }

    protected String getConvertedValue(String unconverted, CrossReference grammarElement) {
        String ruleName = this.linkingHelper.getRuleNameFrom(grammarElement);
        if (ruleName == null) {
            throw new IllegalStateException("Could not determine targeted rule name for " + EmfFormatter.objPath(grammarElement));
        }
        return this.valueConverter.toString(unconverted, ruleName);
    }

    protected String getUnconvertedLinkText(EObject object, EReference reference, EObject context) {
        IScope scope = this.scopeProvider.getScope(context, reference);
        if (scope == null) {
            return null;
        }
        IEObjectDescription eObjectDescription = scope.getSingleElement(object);
        if (eObjectDescription != null) {
            return this.qualifiedNameConverter.toString(eObjectDescription.getName());
        }
        return null;
    }

    @Override
    public boolean isValid(EObject context, CrossReference crossref, EObject target, ITokenSerializer.IErrorAcceptor errorAcceptor) {
        try {
            EReference ref = GrammarUtil.getReference(crossref, context.eClass());
            String text = this.getUnconvertedLinkText(target, ref, context);
            if (text == null) {
                return true;
            }
            this.getConvertedValue(text, crossref);
            return true;
        }
        catch (ValueConverterException e) {
            if (errorAcceptor != null) {
                errorAcceptor.error(e.getMessage());
            }
            return false;
        }
    }

    @Override
    public String serializeCrossRef(EObject context, CrossReference grammarElement, final EObject target, INode node) {
        List<EObject> objects;
        EReference ref = GrammarUtil.getReference(grammarElement, context.eClass());
        String text = null;
        if (node != null && Iterables.any(objects = this.linkingService.getLinkedObjects(context, ref, node), new Predicate<EObject>(){
            private final URI targetURI;
            {
                this.targetURI = EcoreUtil.getURI(target);
            }

            @Override
            public boolean apply(EObject input) {
                return input == target || EcoreUtil.getURI(input).equals(this.targetURI);
            }
        })) {
            return "<KEEP_VALUE_FROM_NODE_MODEL>";
        }
        text = this.getUnconvertedLinkText(target, ref, context);
        if (text != null) {
            return this.getConvertedValue(text, grammarElement);
        }
        if (node != null) {
            return this.linkingHelper.getCrossRefNodeAsString(node, false);
        }
        return null;
    }
}

