/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;

public class DefaultDeclarativeQualifiedNameProvider
extends IQualifiedNameProvider.AbstractImpl {
    private PolymorphicDispatcher<QualifiedName> qualifiedName = new PolymorphicDispatcher<QualifiedName>("qualifiedName", 1, 1, Collections.singletonList(this), PolymorphicDispatcher.NullErrorHandler.get()){

        @Override
        protected QualifiedName handleNoSuchMethod(Object ... params) {
            return null;
        }
    };
    @Inject
    private IQualifiedNameConverter converter = new IQualifiedNameConverter.DefaultImpl();
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;
    private Function<EObject, String> resolver = SimpleAttributeResolver.newResolver(String.class, "name");

    protected Function<EObject, String> getResolver() {
        return this.resolver;
    }

    @Override
    public QualifiedName getFullyQualifiedName(EObject obj) {
        return this.getOrComputeFullyQualifiedName(obj);
    }

    protected QualifiedName getOrComputeFullyQualifiedName(EObject obj) {
        return this.cache.get(Tuples.pair(obj, "fqn"), obj.eResource(), () -> this.computeFullyQualifiedName(obj));
    }

    protected QualifiedName qualifiedName(Object ele) {
        return null;
    }

    protected IQualifiedNameConverter getConverter() {
        return this.converter;
    }

    protected QualifiedName computeFullyQualifiedName(EObject obj) {
        QualifiedName qualifiedNameFromDispatcher = this.qualifiedName.invoke(obj);
        if (qualifiedNameFromDispatcher != null) {
            return qualifiedNameFromDispatcher;
        }
        return this.computeFullyQualifiedNameFromNameAttribute(obj);
    }

    protected QualifiedName computeFullyQualifiedNameFromNameAttribute(EObject obj) {
        String name = this.getResolver().apply(obj);
        if (Strings.isEmpty(name)) {
            return null;
        }
        QualifiedName qualifiedNameFromConverter = this.converter.toQualifiedName(name);
        while (obj.eContainer() != null) {
            QualifiedName parentsQualifiedName = this.getFullyQualifiedName(obj = obj.eContainer());
            if (parentsQualifiedName == null) continue;
            return parentsQualifiedName.append(qualifiedNameFromConverter);
        }
        return qualifiedNameFromConverter;
    }
}

