/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

@Singleton
public class QualifiedNameValueConverter
extends AbstractValueConverter<String> {
    @Inject
    protected IValueConverterService valueConverterService;
    protected IValueConverter<Object> delegateConverter;
    protected String fullWildcardLiteral = null;

    @Deprecated
    protected String getNamespaceDelimiter() {
        return ".";
    }

    protected String getStringNamespaceDelimiter() {
        return this.getNamespaceDelimiter();
    }

    protected String getValueNamespaceDelimiter() {
        return this.getNamespaceDelimiter();
    }

    protected String getWildcardLiteral() {
        return "*";
    }

    protected String getDelegateRuleName() {
        return "ID";
    }

    @Override
    public String toString(String value) {
        if (value == null) {
            throw new ValueConverterException("'null' is not a valid qualified name value", null, null);
        }
        String valueDelimiter = this.getValueNamespaceDelimiter();
        List<String> segments = valueDelimiter.length() == 1 ? Strings.split(value, valueDelimiter.charAt(0)) : Strings.split(value, valueDelimiter);
        int size = segments.size();
        if (size == 1) {
            return this.delegateToString(segments.get(0));
        }
        StringBuilder result = new StringBuilder(value.length());
        String delimiterToUse = this.getStringNamespaceDelimiter();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                result.append(delimiterToUse);
            }
            if (i == size - 1 && this.getWildcardLiteral().equals(segments.get(i))) {
                result.append(this.getWildcardLiteral());
                continue;
            }
            result.append(this.delegateToString(segments.get(i)));
        }
        return result.toString();
    }

    @Override
    public String toValue(String string, INode node) throws ValueConverterException {
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                EObject grammarElement = leafNode.getGrammarElement();
                if (!this.isDelegateRuleCall(grammarElement) && !this.isWildcardLiteral(grammarElement)) continue;
                if (!isFirst) {
                    buffer.append(this.getValueNamespaceDelimiter());
                }
                isFirst = false;
                if (this.isDelegateRuleCall(grammarElement)) {
                    buffer.append(this.delegateToValue(leafNode));
                    continue;
                }
                buffer.append(this.getWildcardLiteral());
            }
        } else {
            for (String segment : Strings.split(string, this.getStringNamespaceDelimiter())) {
                if (!isFirst) {
                    buffer.append(this.getValueNamespaceDelimiter());
                }
                isFirst = false;
                if (this.getWildcardLiteral().equals(segment)) {
                    buffer.append(this.getWildcardLiteral());
                    continue;
                }
                buffer.append((String)this.valueConverterService.toValue(segment, this.getDelegateRuleName(), null));
            }
        }
        return buffer.toString();
    }

    protected boolean isDelegateRuleCall(EObject grammarElement) {
        return grammarElement instanceof RuleCall && this.getDelegateRuleName().equals(((RuleCall)grammarElement).getRule().getName());
    }

    protected boolean isWildcardLiteral(EObject grammarElement) {
        if (grammarElement instanceof Keyword) {
            String keyword = ((Keyword)grammarElement).getValue();
            return this.getWildcardLiteral().equals(keyword) || this.getFullWildcardLiteral().equals(keyword);
        }
        return false;
    }

    protected String getFullWildcardLiteral() {
        if (this.fullWildcardLiteral == null) {
            this.fullWildcardLiteral = this.getStringNamespaceDelimiter() + this.getWildcardLiteral();
        }
        return this.fullWildcardLiteral;
    }

    private IValueConverter<Object> initializeDelegateConverter() {
        if (this.valueConverterService instanceof IValueConverterService.Introspectable) {
            this.delegateConverter = ((IValueConverterService.Introspectable)((Object)this.valueConverterService)).getConverter(this.getDelegateRuleName());
            return this.delegateConverter;
        }
        final String ruleName = this.getDelegateRuleName();
        this.delegateConverter = new IValueConverter<Object>(){

            @Override
            public Object toValue(String string, INode node) throws ValueConverterException {
                return QualifiedNameValueConverter.this.valueConverterService.toValue(string, ruleName, node);
            }

            @Override
            public String toString(Object value) throws ValueConverterException {
                return QualifiedNameValueConverter.this.valueConverterService.toString(value, ruleName);
            }
        };
        return this.delegateConverter;
    }

    protected String delegateToString(String segment) {
        if (this.delegateConverter == null) {
            return this.initializeDelegateConverter().toString(segment);
        }
        return this.delegateConverter.toString(segment);
    }

    protected String delegateToValue(ILeafNode leafNode) {
        if (this.delegateConverter == null) {
            return (String)this.initializeDelegateConverter().toValue(leafNode.getText(), leafNode);
        }
        return (String)this.delegateConverter.toValue(leafNode.getText(), leafNode);
    }
}

