/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Beta
public class EqualsHashCodeProcessor
extends AbstractClassProcessor {
    @Override
    public void doTransform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        boolean _hasEquals = util.hasEquals(it);
        if (_hasEquals) {
            AnnotationReference annotation2 = it.findAnnotation(context.findTypeGlobally(EqualsHashCode.class));
            context.addWarning(annotation2, "equals is already defined, this annotation has no effect");
        } else {
            boolean _hasHashCode = util.hasHashCode(it);
            if (_hasHashCode) {
                context.addWarning(it, "hashCode is already defined, this annotation has no effect");
            } else {
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = it_1 -> !it_1.isStatic() && !it_1.isTransient() && context.isThePrimaryGeneratedJavaElement((Element)it_1);
                Iterable<MutableFieldDeclaration> fields = IterableExtensions.filter(it.getDeclaredFields(), _function);
                util.addEquals(it, fields, util.hasSuperEquals(it));
                util.addHashCode(it, fields, util.hasSuperHashCode(it));
            }
        }
    }

    @Beta
    public static class Util {
        private static final int PRIME_VALUE = 31;
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasHashCode(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("hashCode", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public boolean hasEquals(ClassDeclaration it) {
            Functions.Function1<MethodDeclaration, Boolean> _function = it_1 -> Objects.equal(it_1.getSimpleName(), "equals") && IterableExtensions.size(it_1.getParameters()) == 1 && Objects.equal(IterableExtensions.head(it_1.getParameters()).getType(), this.context.getObject());
            return IterableExtensions.exists(it.getDeclaredMethods(), _function);
        }

        public boolean hasSuperEquals(ClassDeclaration cls) {
            boolean _xblockexpression = false;
            Type _type = cls.getExtendedClass().getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            boolean _equals = this.context.newTypeReference(superClass, new TypeReference[0]).equals(this.context.getObject());
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasEquals = this.hasEquals(superClass);
                _xifexpression_1 = _hasEquals ? true : this.hasSuperEquals(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public boolean hasSuperHashCode(ClassDeclaration cls) {
            boolean _xblockexpression = false;
            Type _type = cls.getExtendedClass().getType();
            ClassDeclaration superClass = (ClassDeclaration)_type;
            boolean _xifexpression = false;
            boolean _equals = this.context.newTypeReference(superClass, new TypeReference[0]).equals(this.context.getObject());
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasHashCode = this.hasHashCode(superClass);
                _xifexpression_1 = _hasHashCode ? true : this.hasSuperHashCode(superClass);
                _xifexpression = _xifexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public void addEquals(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = it -> {
                this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement(cls));
                it.setReturnType(this.context.getPrimitiveBoolean());
                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                it.addAnnotation(this.context.newAnnotationReference(Pure.class));
                it.addParameter("obj", this.context.getObject());
                StringConcatenationClient _client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        int _size;
                        boolean _greaterThan;
                        _builder.append("if (this == obj)");
                        _builder.newLine();
                        _builder.append("  ");
                        _builder.append("return true;");
                        _builder.newLine();
                        _builder.append("if (obj == null)");
                        _builder.newLine();
                        _builder.append("  ");
                        _builder.append("return false;");
                        _builder.newLine();
                        _builder.append("if (getClass() != obj.getClass())");
                        _builder.newLine();
                        _builder.append("  ");
                        _builder.append("return false;");
                        _builder.newLine();
                        if (includeSuper) {
                            _builder.append("if (!super.equals(obj))");
                            _builder.newLine();
                            _builder.append("  ");
                            _builder.append("return false;");
                            _builder.newLine();
                        }
                        boolean bl = _greaterThan = (_size = IterableExtensions.size(includedFields)) > 0;
                        if (_greaterThan) {
                            TypeReference _newWildCardSelfTypeReference = this.newWildCardSelfTypeReference(cls);
                            _builder.append(_newWildCardSelfTypeReference);
                            _builder.append(" other = (");
                            TypeReference _newWildCardSelfTypeReference_1 = this.newWildCardSelfTypeReference(cls);
                            _builder.append(_newWildCardSelfTypeReference_1);
                            _builder.append(") obj;");
                            _builder.newLineIfNotEmpty();
                        }
                        for (FieldDeclaration field : includedFields) {
                            StringConcatenationClient _contributeToEquals = this.contributeToEquals(field);
                            _builder.append(_contributeToEquals);
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("return true;");
                        _builder.newLine();
                    }
                };
                it.setBody(_client);
            };
            cls.addMethod("equals", _function);
        }

        private TypeReference newWildCardSelfTypeReference(ClassDeclaration cls) {
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = it -> this.context.newWildcardTypeReference(this.context.getObject());
            return this.context.newTypeReference(cls, (TypeReference[])Conversions.unwrapArray(IterableExtensions.map(cls.getTypeParameters(), _function), TypeReference.class));
        }

        public StringConcatenationClient contributeToEquals(final FieldDeclaration it) {
            String _name_2;
            StringConcatenationClient _switchResult = null;
            String _name = this.orObject(it.getType()).getName();
            boolean _matched = false;
            String _name_1 = Double.TYPE.getName();
            if (Objects.equal(_name, _name_1)) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("if (");
                        _builder.append(Double.class);
                        _builder.append(".doubleToLongBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(") != ");
                        _builder.append(Double.class);
                        _builder.append(".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("  ");
                        _builder.append("return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched && Objects.equal(_name, _name_2 = Float.TYPE.getName())) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("if (");
                        _builder.append(Float.class);
                        _builder.append(".floatToIntBits(other.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(") != ");
                        _builder.append(Float.class);
                        _builder.append(".floatToIntBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append("))");
                        _builder.newLineIfNotEmpty();
                        _builder.append("  ");
                        _builder.append("return false; ");
                        _builder.newLine();
                    }
                };
            }
            if (!_matched) {
                String _name_8;
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4;
                String _name_3 = Boolean.TYPE.getName();
                if (Objects.equal(_name, _name_3)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_4 = Integer.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_5 = Character.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_6 = Byte.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_7 = Short.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_8 = Long.TYPE.getName())) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_2;
                    _switchResult = _client_2 = new StringConcatenationClient(){

                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append("if (other.");
                            String _simpleName = it.getSimpleName();
                            _builder.append(_simpleName);
                            _builder.append(" != this.");
                            String _simpleName_1 = it.getSimpleName();
                            _builder.append(_simpleName_1);
                            _builder.append(")");
                            _builder.newLineIfNotEmpty();
                            _builder.append("  ");
                            _builder.append("return false;");
                            _builder.newLine();
                        }
                    };
                }
            }
            if (!_matched) {
                StringConcatenationClient _client_3;
                _switchResult = _client_3 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("if (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(" == null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("  ");
                        _builder.append("if (other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1, "  ");
                        _builder.append(" != null)");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("return false;");
                        _builder.newLine();
                        _builder.append("} else if (!");
                        StringConcatenationClient _deepEquals = this.deepEquals(it);
                        _builder.append(_deepEquals);
                        _builder.append(")");
                        _builder.newLineIfNotEmpty();
                        _builder.append("  ");
                        _builder.append("return false;");
                        _builder.newLine();
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepEquals(final FieldDeclaration it) {
            StringConcatenationClient _xifexpression = null;
            boolean _isArray = it.getType().isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                boolean _isPrimitive = it.getType().getArrayComponentType().isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append(".equals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append(".deepEquals(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(", other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(".equals(other.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(")");
                    }
                };
            }
            return _xifexpression;
        }

        public void addHashCode(MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, boolean includeSuper) {
            String _xifexpression = null;
            _xifexpression = includeSuper ? "super.hashCode()" : "1";
            final String defaultBase = _xifexpression;
            final int fields = IterableExtensions.size(includedFields);
            Procedures.Procedure1<MutableMethodDeclaration> _function = it -> {
                this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement(cls));
                it.setReturnType(this.context.getPrimitiveInt());
                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                it.addAnnotation(this.context.newAnnotationReference(Pure.class));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        if (fields >= 2) {
                            _builder.append("final int prime = ");
                            _builder.append(31);
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("int result = ");
                            _builder.append(defaultBase);
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, fields, true);
                            for (Integer i : _doubleDotLessThan) {
                                if (i == fields - 1) {
                                    _builder.append("return");
                                } else {
                                    _builder.append("result =");
                                }
                                _builder.append(" prime * result + ");
                                StringConcatenationClient _contributeToHashCode = this.contributeToHashCode(((FieldDeclaration[])Conversions.unwrapArray(includedFields, FieldDeclaration.class))[i]);
                                _builder.append(_contributeToHashCode);
                                _builder.append(";");
                                _builder.newLineIfNotEmpty();
                            }
                        } else if (fields == 1) {
                            _builder.append("return ");
                            _builder.append(31);
                            _builder.append(" * ");
                            _builder.append(defaultBase);
                            _builder.append(" + ");
                            StringConcatenationClient _contributeToHashCode_1 = this.contributeToHashCode((FieldDeclaration)IterableExtensions.head(includedFields));
                            _builder.append(_contributeToHashCode_1);
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("return ");
                            _builder.append(defaultBase);
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                };
                it.setBody(_client);
            };
            cls.addMethod("hashCode", _function);
        }

        public StringConcatenationClient contributeToHashCode(final FieldDeclaration it) {
            String _name_8;
            String _name_3;
            String _name_2;
            StringConcatenationClient _switchResult = null;
            String _name = this.orObject(it.getType()).getName();
            boolean _matched = false;
            String _name_1 = Double.TYPE.getName();
            if (Objects.equal(_name, _name_1)) {
                StringConcatenationClient _client;
                _matched = true;
                _switchResult = _client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("(int) (");
                        _builder.append(Double.class);
                        _builder.append(".doubleToLongBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(") ^ (");
                        _builder.append(Double.class);
                        _builder.append(".doubleToLongBits(this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(") >>> 32))");
                    }
                };
            }
            if (!_matched && Objects.equal(_name, _name_2 = Float.TYPE.getName())) {
                StringConcatenationClient _client_1;
                _matched = true;
                _switchResult = _client_1 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Float.class);
                        _builder.append(".floatToIntBits(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(")");
                    }
                };
            }
            if (!_matched && Objects.equal(_name, _name_3 = Boolean.TYPE.getName())) {
                StringConcatenationClient _client_2;
                _matched = true;
                _switchResult = _client_2 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(" ? 1231 : 1237)");
                    }
                };
            }
            if (!_matched) {
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4 = Integer.TYPE.getName();
                if (Objects.equal(_name, _name_4)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_5 = Character.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_6 = Byte.TYPE.getName())) {
                    _matched = true;
                }
                if (!_matched && Objects.equal(_name, _name_7 = Short.TYPE.getName())) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenationClient _client_3;
                    _switchResult = _client_3 = new StringConcatenationClient(){

                        @Override
                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append("this.");
                            String _simpleName = it.getSimpleName();
                            _builder.append(_simpleName);
                        }
                    };
                }
            }
            if (!_matched && Objects.equal(_name, _name_8 = Long.TYPE.getName())) {
                StringConcatenationClient _client_4;
                _matched = true;
                _switchResult = _client_4 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("(int) (this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(" ^ (this.");
                        String _simpleName_1 = it.getSimpleName();
                        _builder.append(_simpleName_1);
                        _builder.append(" >>> 32))");
                    }
                };
            }
            if (!_matched) {
                StringConcatenationClient _client_5;
                _switchResult = _client_5 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("((this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append("== null) ? 0 : ");
                        StringConcatenationClient _deepHashCode = this.deepHashCode(it);
                        _builder.append(_deepHashCode);
                        _builder.append(")");
                    }
                };
            }
            return _switchResult;
        }

        public StringConcatenationClient deepHashCode(final FieldDeclaration it) {
            StringConcatenationClient _xblockexpression = null;
            TypeReference type = this.orObject(it.getType());
            StringConcatenationClient _xifexpression = null;
            boolean _isArray = type.isArray();
            if (_isArray) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                StringConcatenationClient _xifexpression_1 = null;
                boolean _isPrimitive = type.getArrayComponentType().isPrimitive();
                _xifexpression_1 = _isPrimitive ? (_client = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append(".hashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(")");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append(Arrays.class);
                        _builder.append(".deepHashCode(this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(")");
                    }
                });
                _xifexpression = _xifexpression_1;
            } else {
                StringConcatenationClient _client_2;
                _xifexpression = _client_2 = new StringConcatenationClient(){

                    @Override
                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append("this.");
                        String _simpleName = it.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append(".hashCode()");
                    }
                };
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _object;
            TypeReference _elvis = null;
            _elvis = ref != null ? ref : (_object = this.context.getObject());
            return _elvis;
        }
    }
}

