/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.url;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.url.BundleURLConnection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;

public abstract class BundleResourceHandler
extends URLStreamHandler {
    public static final String OSGI_RESOURCE_URL_PROTOCOL = "bundleresource";
    public static final String OSGI_ENTRY_URL_PROTOCOL = "bundleentry";
    public static final String SECURITY_CHECKED = "SECURITY_CHECKED";
    public static final String SECURITY_UNCHECKED = "SECURITY_UNCHECKED";
    public static final String BID_FWKID_SEPARATOR = ".fwk";
    protected final ModuleContainer container;
    protected BundleEntry bundleEntry;

    public BundleResourceHandler(ModuleContainer container2, BundleEntry bundleEntry) {
        this.container = container2;
        this.bundleEntry = bundleEntry;
    }

    @Override
    protected void parseURL(URL url, String str, int start, int end) {
        int dotIndex;
        if (end < start) {
            return;
        }
        if (url.getPath() != null) {
            this.bundleEntry = null;
        }
        String spec = "";
        if (start < end) {
            spec = str.substring(start, end);
        }
        end -= start;
        String path = url.getPath();
        String host = url.getHost();
        int resIndex = url.getPort();
        if (resIndex < 0) {
            resIndex = 0;
        }
        int pathIdx = 0;
        if (spec.startsWith("//")) {
            int bundleIdEnd;
            int bundleIdIdx = 2;
            pathIdx = spec.indexOf(47, bundleIdIdx);
            if (pathIdx == -1) {
                pathIdx = end;
                path = "";
            }
            if ((bundleIdEnd = spec.indexOf(58, bundleIdIdx)) > pathIdx || bundleIdEnd == -1) {
                bundleIdEnd = pathIdx;
            }
            if (bundleIdEnd < pathIdx - 1) {
                try {
                    resIndex = Integer.parseInt(spec.substring(bundleIdEnd + 1, pathIdx));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            host = spec.substring(bundleIdIdx, bundleIdEnd);
        }
        if (pathIdx < end && spec.charAt(pathIdx) == '/') {
            path = spec.substring(pathIdx, end);
        } else if (end > pathIdx) {
            int last;
            if (path == null || path.equals("")) {
                path = "/";
            }
            path = (last = path.lastIndexOf(47) + 1) == 0 ? spec.substring(pathIdx, end) : String.valueOf(path.substring(0, last)) + spec.substring(pathIdx, end);
        }
        if (path == null) {
            path = "";
        }
        if (path.endsWith("/.") || path.endsWith("/..")) {
            path = String.valueOf(path) + '/';
        }
        while ((dotIndex = path.indexOf("/./")) >= 0) {
            path = String.valueOf(path.substring(0, dotIndex + 1)) + path.substring(dotIndex + 3);
        }
        while ((dotIndex = path.indexOf("/../")) >= 0) {
            path = dotIndex != 0 ? String.valueOf(path.substring(0, path.lastIndexOf(47, dotIndex - 1))) + path.substring(dotIndex + 3) : path.substring(dotIndex + 3);
        }
        while ((dotIndex = path.indexOf("//")) >= 0) {
            path = String.valueOf(path.substring(0, dotIndex + 1)) + path.substring(dotIndex + 2);
        }
        String authorized = SECURITY_UNCHECKED;
        long bundleId = this.getBundleID(host);
        Module module = this.getModule(bundleId);
        if (this.checkAuthorization(module)) {
            authorized = SECURITY_CHECKED;
        }
        host = String.valueOf(Long.toString(bundleId)) + BID_FWKID_SEPARATOR + Integer.toString(this.container.hashCode());
        this.setURL(url, url.getProtocol(), host, resIndex, authorized, null, path, null, url.getRef());
    }

    private Module getModule(long id) {
        return this.container.getModule(id);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        long bundleID;
        if (this.bundleEntry != null) {
            return new BundleURLConnection(url, this.bundleEntry);
        }
        String host = url.getHost();
        if (host == null) {
            throw new IOException(NLS.bind(Msg.URL_NO_BUNDLE_ID, url.toExternalForm()));
        }
        try {
            bundleID = this.getBundleID(host);
        }
        catch (NumberFormatException nfe) {
            throw (MalformedURLException)new MalformedURLException(NLS.bind(Msg.URL_INVALID_BUNDLE_ID, host)).initCause(nfe);
        }
        Module module = this.getModule(bundleID);
        if (module == null) {
            throw new IOException(NLS.bind(Msg.URL_NO_BUNDLE_FOUND, url.toExternalForm()));
        }
        if (!url.getAuthority().equals(SECURITY_CHECKED)) {
            this.checkAuthorization(module);
        }
        return new BundleURLConnection(url, this.findBundleEntry(url, module));
    }

    protected abstract BundleEntry findBundleEntry(URL var1, Module var2) throws IOException;

    @Override
    protected String toExternalForm(URL url) {
        String ref;
        String path;
        int index;
        StringBuilder result = new StringBuilder(url.getProtocol());
        result.append("://");
        String host = url.getHost();
        if (host != null && host.length() > 0) {
            result.append(host);
        }
        if ((index = url.getPort()) > 0) {
            result.append(':').append(index);
        }
        if ((path = url.getPath()) != null) {
            if (path.length() > 0 && path.charAt(0) != '/') {
                result.append("/");
            }
            result.append(path);
        }
        if ((ref = url.getRef()) != null && ref.length() > 0) {
            result.append('#').append(ref);
        }
        return result.toString();
    }

    @Override
    protected int hashCode(URL url) {
        String host;
        int hash = 0;
        String protocol = url.getProtocol();
        if (protocol != null) {
            hash += protocol.hashCode();
        }
        if ((host = url.getHost()) != null) {
            hash += host.hashCode();
        }
        hash += url.getPort();
        String path = url.getPath();
        if (path != null) {
            hash += path.hashCode();
        }
        return hash += this.container.hashCode();
    }

    @Override
    protected boolean equals(URL url1, URL url2) {
        return this.sameFile(url1, url2);
    }

    @Override
    protected synchronized InetAddress getHostAddress(URL url) {
        return null;
    }

    @Override
    protected boolean hostsEqual(URL url1, URL url2) {
        String host1 = url1.getHost();
        String host2 = url2.getHost();
        if (host1 != null && host2 != null) {
            return host1.equalsIgnoreCase(host2);
        }
        return host1 == null && host2 == null;
    }

    @Override
    protected boolean sameFile(URL url1, URL url2) {
        String path2;
        String p2;
        if (url1.hashCode() != url2.hashCode()) {
            return false;
        }
        String p1 = url1.getProtocol();
        if (!(p1 == (p2 = url2.getProtocol()) || p1 != null && p1.equalsIgnoreCase(p2))) {
            return false;
        }
        if (!this.hostsEqual(url1, url2)) {
            return false;
        }
        if (url1.getPort() != url2.getPort()) {
            return false;
        }
        String path1 = url1.getPath();
        return path1 == (path2 = url2.getPath()) || path1 != null && path1.equals(path2);
    }

    protected boolean checkAuthorization(Module module) {
        Bundle bundle;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        Bundle bundle2 = bundle = module == null ? null : module.getBundle();
        if (bundle == null) {
            return false;
        }
        sm.checkPermission(new AdminPermission(bundle, "resource"));
        return true;
    }

    private long getBundleID(String host) {
        int dotIndex = host.indexOf(46);
        return dotIndex >= 0 && dotIndex < host.length() - 1 ? Long.parseLong(host.substring(0, dotIndex)) : Long.parseLong(host);
    }
}

