/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.hookregistry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Dictionary;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;

public abstract class StorageHookFactory<S, L, H extends StorageHook<S, L>> {
    protected final String KEY = this.getClass().getName().intern();

    public int getStorageVersion() {
        return 0;
    }

    public final String getKey() {
        return this.KEY;
    }

    public boolean isCompatibleWith(int version2) {
        return this.getStorageVersion() == version2;
    }

    public S createSaveContext() {
        return null;
    }

    public L createLoadContext(int version2) {
        return null;
    }

    protected H createStorageHook(BundleInfo.Generation generation) {
        return null;
    }

    public final H createStorageHookAndValidateFactoryClass(BundleInfo.Generation generation) {
        Class factoryClassOfStorageHook;
        H result = this.createStorageHook(generation);
        if (result == null) {
            return result;
        }
        Class<?> factoryClass = this.getClass();
        if (!factoryClass.equals(factoryClassOfStorageHook = ((StorageHook)result).getFactoryClass())) {
            throw new IllegalStateException(String.format("The factory class '%s' of storage hook '%s' does not match the creating factory class of '%s'", factoryClassOfStorageHook.getName(), result, factoryClass.getName()));
        }
        return result;
    }

    public URLConnection handleContentConnection(Module module, String location, InputStream in) throws IOException {
        return null;
    }

    public static class StorageHook<S, L> {
        private final Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> factoryClass;
        private final BundleInfo.Generation generation;

        public StorageHook(BundleInfo.Generation generation, Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> factoryClass) {
            this.generation = generation;
            this.factoryClass = factoryClass;
        }

        public BundleInfo.Generation getGeneration() {
            return this.generation;
        }

        public void initialize(Dictionary<String, String> manifest) throws BundleException {
        }

        public ModuleRevisionBuilder adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent operation, Module origin, ModuleRevisionBuilder builder) {
            return null;
        }

        public void load(L loadContext, DataInputStream is) throws IOException {
        }

        public void save(S saveContext, DataOutputStream os) throws IOException {
        }

        public void deletingGeneration() {
        }

        public void validate() throws IllegalStateException {
        }

        public Class<? extends StorageHookFactory<S, L, ? extends StorageHook<S, L>>> getFactoryClass() {
            return this.factoryClass;
        }
    }
}

