/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.HashAlgorithm;

class RSAUtil {
    RSAUtil() {
    }

    static String getDigestSigAlgName(String string) {
        int n = string.indexOf(45);
        if (n > 0 && !string.startsWith("SHA3")) {
            return string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    static AlgorithmParameterSpec getPSSParameterSpec(short s2, String string, JcaJceHelper jcaJceHelper) {
        MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(string);
        return new PSSParameterSpec(string, "MGF1", mGF1ParameterSpec, HashAlgorithm.getOutputSize(s2), 1);
    }
}

