/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;

public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final int BUF_SIZE = 32768;
    private static final boolean canDoAEAD = JceAEADCipherImpl.checkForAEAD();
    private final JcaJceHelper helper;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private final String algorithmParamsName;
    private SecretKey key;

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private static String getAlgParamsName(JcaJceHelper jcaJceHelper, String string) {
        try {
            String string2 = string.contains("CCM") ? "CCM" : "GCM";
            jcaJceHelper.createAlgorithmParameters(string2);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JceAEADCipherImpl(JcaJceHelper jcaJceHelper, String string, String string2, int n, boolean bl) throws GeneralSecurityException {
        this.helper = jcaJceHelper;
        this.cipher = jcaJceHelper.createCipher(string);
        this.algorithm = string2;
        this.keySize = n;
        this.cipherMode = bl ? 1 : 2;
        this.algorithmParamsName = JceAEADCipherImpl.getAlgParamsName(jcaJceHelper, string);
    }

    public void setKey(byte[] byArray, int n, int n2) {
        if (this.keySize != n2) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(byArray, n, n2, this.algorithm);
    }

    public void init(byte[] byArray, int n, byte[] byArray2) {
        try {
            if (canDoAEAD && this.algorithmParamsName != null) {
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters(this.algorithmParamsName);
                algorithmParameters.init(new GCMParameters(byArray, n).getEncoded());
                this.cipher.init(this.cipherMode, (Key)this.key, algorithmParameters);
                if (byArray2 != null && byArray2.length > 0) {
                    this.cipher.updateAAD(byArray2);
                }
            } else {
                this.cipher.init(this.cipherMode, (Key)this.key, new AEADParameterSpec(byArray, n * 8, byArray2));
            }
        }
        catch (Exception exception) {
            throw Exceptions.illegalStateException(exception.getMessage(), exception);
        }
    }

    public int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, int n3) throws IOException {
        int n4 = byArray2.length;
        if (n4 > 0 && 1 != this.cipherMode) {
            throw new TlsFatalAlert(80);
        }
        try {
            int n5 = this.updateCipher(byArray, n, n2, byArray3, n3);
            if (n4 > 0) {
                n5 += this.updateCipher(byArray2, 0, n4, byArray3, n3 + n5);
            }
            n5 += this.cipher.doFinal(byArray3, n3 + n5);
            return n5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("", generalSecurityException);
        }
    }

    protected int updateCipher(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws GeneralSecurityException {
        int n4;
        int n5 = 0;
        for (int i = 0; i < n2; i += n4) {
            n4 = Math.min(32768, n2 - i);
            n5 += this.cipher.update(byArray, n + i, n4, byArray2, n3 + n5);
        }
        return n5;
    }
}

