/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static JcaTlsCertificate getEndEntity(JcaTlsCrypto jcaTlsCrypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return JcaTlsCertificate.convert(jcaTlsCrypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner tlsSigner;
        String string = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(string) || "RSASSA-PSS".equalsIgnoreCase(string)) {
            PublicKey publicKey;
            if (signatureAndHashAlgorithm != null) {
                short s2 = signatureAndHashAlgorithm.getSignature();
                switch (s2) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return new JcaTlsRSAPSSSigner(jcaTlsCrypto, privateKey, s2);
                    }
                }
            }
            try {
                publicKey = JcaDefaultTlsCredentialedSigner.getEndEntity(jcaTlsCrypto, certificate).getPubKeyRSA();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            tlsSigner = new JcaTlsRSASigner(jcaTlsCrypto, privateKey, publicKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsDSASigner(jcaTlsCrypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            tlsSigner = new JcaTlsECDSASigner(jcaTlsCrypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd25519Signer(jcaTlsCrypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(string)) {
            tlsSigner = new JcaTlsEd448Signer(jcaTlsCrypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return tlsSigner;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters tlsCryptoParameters, JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(tlsCryptoParameters, JcaDefaultTlsCredentialedSigner.makeSigner(jcaTlsCrypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

