/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.GenericSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsRSASigner
extends BcTlsSigner {
    private final RSAKeyParameters publicKey;

    public BcTlsRSASigner(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        super(bcTlsCrypto, rSAKeyParameters);
        this.publicKey = rSAKeyParameters2;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        Signer signer;
        Digest digest = this.crypto.createDigest((short)0);
        if (signatureAndHashAlgorithm != null) {
            if (signatureAndHashAlgorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
            }
            signer = new RSADigestSigner(digest, TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), digest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(byArray, 0, byArray.length);
        try {
            byte[] byArray2 = signer.generateSignature();
            signer.init(false, this.publicKey);
            signer.update(byArray, 0, byArray.length);
            if (signer.verifySignature(byArray2)) {
                return byArray2;
            }
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
        throw new TlsFatalAlert(80);
    }
}

