/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAPSSVerifier
extends BcTlsVerifier {
    private final short signatureAlgorithm;

    public BcTlsRSAPSSVerifier(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, short s2) {
        super(bcTlsCrypto, rSAKeyParameters);
        if (!SignatureAlgorithm.isRSAPSS(s2)) {
            throw new IllegalArgumentException("signatureAlgorithm");
        }
        this.signatureAlgorithm = s2;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.signatureAlgorithm || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        short s2 = SignatureAlgorithm.getRSAPSSHashAlgorithm(this.signatureAlgorithm);
        Digest digest = this.crypto.createDigest(s2);
        PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), digest, digest.getDigestSize());
        pSSSigner.init(false, this.publicKey);
        return new BcTlsStreamVerifier(pSSSigner, digitallySigned.getSignature());
    }
}

