/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;

public class BcTlsRSAPSSSigner
extends BcTlsSigner {
    private final short signatureAlgorithm;

    public BcTlsRSAPSSSigner(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, short s2) {
        super(bcTlsCrypto, rSAKeyParameters);
        if (!SignatureAlgorithm.isRSAPSS(s2)) {
            throw new IllegalArgumentException("signatureAlgorithm");
        }
        this.signatureAlgorithm = s2;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.signatureAlgorithm || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        short s2 = SignatureAlgorithm.getRSAPSSHashAlgorithm(this.signatureAlgorithm);
        Digest digest = this.crypto.createDigest(s2);
        PSSSigner pSSSigner = new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), digest, HashAlgorithm.getOutputSize(s2));
        pSSSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        return new BcTlsStreamSigner(pSSSigner);
    }
}

