/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;

public abstract class TlsCryptoUtils {
    private static final byte[] TLS13_PREFIX = new byte[]{116, 108, 115, 49, 51, 32};

    public static TlsSecret hkdfExpandLabel(TlsSecret tlsSecret, short s2, String string, byte[] byArray, int n) throws IOException {
        int n2 = string.length();
        if (n2 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n3 = byArray.length;
        int n4 = TLS13_PREFIX.length + n2;
        byte[] byArray2 = new byte[2 + (1 + n4) + (1 + n3)];
        TlsUtils.checkUint16(n);
        TlsUtils.writeUint16(n, byArray2, 0);
        TlsUtils.checkUint8(n4);
        TlsUtils.writeUint8(n4, byArray2, 2);
        System.arraycopy(TLS13_PREFIX, 0, byArray2, 3, TLS13_PREFIX.length);
        int n5 = 2 + (1 + TLS13_PREFIX.length);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            byArray2[n5 + i] = (byte)c;
        }
        TlsUtils.writeOpaque8(byArray, byArray2, 2 + (1 + n4));
        return tlsSecret.hkdfExpand(s2, byArray2, n);
    }
}

