/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.IdentifierType;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TrustedAuthority {
    protected short identifierType;
    protected Object identifier;

    public TrustedAuthority(short s2, Object object) {
        if (!TrustedAuthority.isCorrectType(s2, object)) {
            throw new IllegalArgumentException("'identifier' is not an instance of the correct type");
        }
        this.identifierType = s2;
        this.identifier = object;
    }

    public short getIdentifierType() {
        return this.identifierType;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public byte[] getCertSHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public byte[] getKeySHA1Hash() {
        return Arrays.clone((byte[])this.identifier);
    }

    public X500Name getX509Name() {
        this.checkCorrectType((short)2);
        return (X500Name)this.identifier;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.identifierType, outputStream);
        switch (this.identifierType) {
            case 1: 
            case 3: {
                byte[] byArray = (byte[])this.identifier;
                outputStream.write(byArray);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                X500Name x500Name = (X500Name)this.identifier;
                byte[] byArray = x500Name.getEncoded("DER");
                TlsUtils.writeOpaque16(byArray, outputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static TrustedAuthority parse(InputStream inputStream) throws IOException {
        Object object;
        short s2 = TlsUtils.readUint8(inputStream);
        switch (s2) {
            case 1: 
            case 3: {
                object = TlsUtils.readFully(20, inputStream);
                break;
            }
            case 0: {
                object = null;
                break;
            }
            case 2: {
                byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
                ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray);
                object = X500Name.getInstance(aSN1Primitive);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new TrustedAuthority(s2, object);
    }

    protected void checkCorrectType(short s2) {
        if (this.identifierType != s2 || !TrustedAuthority.isCorrectType(s2, this.identifier)) {
            throw new IllegalStateException("TrustedAuthority is not of type " + IdentifierType.getName(s2));
        }
    }

    protected static boolean isCorrectType(short s2, Object object) {
        switch (s2) {
            case 1: 
            case 3: {
                return TrustedAuthority.isSHA1Hash(object);
            }
            case 0: {
                return object == null;
            }
            case 2: {
                return object instanceof X500Name;
            }
        }
        throw new IllegalArgumentException("'identifierType' is an unsupported IdentifierType");
    }

    protected static boolean isSHA1Hash(Object object) {
        return object instanceof byte[] && ((byte[])object).length == 20;
    }
}

