/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;

class HandshakeMessageOutput
extends ByteArrayOutputStream {
    static int getLength(int n) {
        return 4 + n;
    }

    static void send(TlsProtocol tlsProtocol, short s2, byte[] byArray) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(s2, byArray.length);
        handshakeMessageOutput.write(byArray);
        handshakeMessageOutput.send(tlsProtocol);
    }

    HandshakeMessageOutput(short s2) throws IOException {
        this(s2, 60);
    }

    HandshakeMessageOutput(short s2, int n) throws IOException {
        super(HandshakeMessageOutput.getLength(n));
        TlsUtils.checkUint8(s2);
        TlsUtils.writeUint8(s2, (OutputStream)this);
        this.count += 3;
    }

    void send(TlsProtocol tlsProtocol) throws IOException {
        int n = this.count - 4;
        TlsUtils.checkUint24(n);
        TlsUtils.writeUint24(n, this.buf, 1);
        tlsProtocol.writeHandshakeMessage(this.buf, 0, this.count);
        this.buf = null;
    }
}

