/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Shorts;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext tlsContext) {
        this.context = tlsContext;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    private DeferredHash(TlsContext tlsContext, Hashtable hashtable) {
        this.context = tlsContext;
        this.buf = null;
        this.hashes = hashtable;
        this.forceBuffering = false;
        this.sealed = true;
    }

    public void copyBufferTo(OutputStream outputStream) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyTo(outputStream);
    }

    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    public void notifyPRFDetermined() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.checkTrackingHash(Shorts.valueOf((short)1));
                this.checkTrackingHash(Shorts.valueOf((short)2));
                break;
            }
            default: {
                this.checkTrackingHash(Shorts.valueOf(securityParameters.getPRFHashAlgorithm()));
                if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break;
                this.sealHashAlgorithms();
            }
        }
    }

    public void trackHashAlgorithm(short s2) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf(s2));
    }

    public void sealHashAlgorithms() {
        if (this.sealed) {
            throw new IllegalStateException("Already sealed");
        }
        this.sealed = true;
        this.checkStopBuffering();
    }

    public TlsHandshakeHash stopTracking() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Hashtable hashtable = new Hashtable();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.cloneHash(hashtable, (short)1);
                this.cloneHash(hashtable, (short)2);
                break;
            }
            default: {
                this.cloneHash(hashtable, securityParameters.getPRFHashAlgorithm());
            }
        }
        return new DeferredHash(this.context, hashtable);
    }

    public TlsHash forkPRFHash() {
        TlsHash tlsHash;
        this.checkStopBuffering();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                tlsHash = new CombinedHash(this.context, this.cloneHash((short)1), this.cloneHash((short)2));
                break;
            }
            default: {
                tlsHash = this.cloneHash(securityParameters.getPRFHashAlgorithm());
            }
        }
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash;
    }

    public byte[] getFinalHash(short s2) {
        TlsHash tlsHash = (TlsHash)this.hashes.get(Shorts.valueOf(s2));
        if (tlsHash == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(s2) + " is not being tracked");
        }
        this.checkStopBuffering();
        tlsHash = (TlsHash)tlsHash.clone();
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash.calculateHash();
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.buf != null) {
            this.buf.write(byArray, n, n2);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.update(byArray, n, n2);
        }
    }

    public byte[] calculateHash() {
        throw new IllegalStateException("Use fork() to get a definite hash");
    }

    public Object clone() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.reset();
        }
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration enumeration = this.hashes.elements();
            while (enumeration.hasMoreElements()) {
                TlsHash tlsHash = (TlsHash)enumeration.nextElement();
                this.buf.updateDigest(tlsHash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short s2) {
        if (!this.hashes.containsKey(s2)) {
            TlsHash tlsHash = this.context.getCrypto().createHash(s2);
            this.hashes.put(s2, tlsHash);
        }
    }

    protected TlsHash cloneHash(short s2) {
        return this.cloneHash(Shorts.valueOf(s2));
    }

    protected TlsHash cloneHash(Short s2) {
        return (TlsHash)((TlsHash)this.hashes.get(s2)).clone();
    }

    protected void cloneHash(Hashtable hashtable, short s2) {
        this.cloneHash(hashtable, Shorts.valueOf(s2));
    }

    protected void cloneHash(Hashtable hashtable, Short s2) {
        TlsHash tlsHash = this.cloneHash(s2);
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        hashtable.put(s2, tlsHash);
    }
}

