/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.NullOutputStream;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl) {
        this.verifyRequests = bl;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        return this.accept(tlsServer, datagramTransport, null);
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport, DTLSRequest dTLSRequest) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.server = tlsServer;
        serverHandshakeState.serverContext = new TlsServerContextImpl(tlsServer.getCrypto());
        tlsServer.init(serverHandshakeState.serverContext);
        serverHandshakeState.serverContext.handshakeBeginning(tlsServer);
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = tlsServer.shouldUseExtendedPadding();
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(serverHandshakeState.serverContext, serverHandshakeState.server, datagramTransport);
        tlsServer.notifyCloseHandle(dTLSRecordLayer);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, dTLSRecordLayer, dTLSRequest);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s2) {
        dTLSRecordLayer.fail(s2);
        this.invalidateSession(serverHandshakeState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DTLSTransport serverHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer, DTLSRequest dTLSRequest) throws IOException {
        byte[] byArray;
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParametersHandshake();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(serverHandshakeState.serverContext, dTLSRecordLayer, serverHandshakeState.server.getHandshakeTimeoutMillis(), dTLSRequest);
        DTLSReliableHandshake.Message message = null;
        if (null == dTLSRequest) {
            message = dTLSReliableHandshake.receiveMessage();
            if (message.getType() != 1) throw new TlsFatalAlert(10);
            this.processClientHello(serverHandshakeState, message.getBody());
        } else {
            this.processClientHello(serverHandshakeState, dTLSRequest.getClientHello());
        }
        serverHandshakeState.tlsSession = TlsUtils.importSession(TlsUtils.EMPTY_BYTES, null);
        serverHandshakeState.sessionParameters = null;
        serverHandshakeState.sessionMasterSecret = null;
        securityParameters.sessionID = serverHandshakeState.tlsSession.getSessionID();
        serverHandshakeState.server.notifySession(serverHandshakeState.tlsSession);
        byte[] byArray2 = this.generateServerHello(serverHandshakeState, dTLSRecordLayer);
        Object object = serverHandshakeState.serverContext.getServerVersion();
        dTLSRecordLayer.setReadVersion((ProtocolVersion)object);
        dTLSRecordLayer.setWriteVersion((ProtocolVersion)object);
        dTLSReliableHandshake.sendMessage((short)2, byArray2);
        dTLSReliableHandshake.getHandshakeHash().notifyPRFDetermined();
        Vector vector = serverHandshakeState.server.getServerSupplementalData();
        if (vector != null) {
            object = DTLSServerProtocol.generateSupplementalData(vector);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object);
        }
        serverHandshakeState.keyExchange = TlsUtils.initKeyExchangeServer(serverHandshakeState.serverContext, serverHandshakeState.server);
        serverHandshakeState.serverCredentials = TlsUtils.establishServerCredentials(serverHandshakeState.server);
        object = null;
        Object object2 = new ByteArrayOutputStream();
        if (serverHandshakeState.serverCredentials == null) {
            serverHandshakeState.keyExchange.skipServerCredentials();
        } else {
            serverHandshakeState.keyExchange.processServerCredentials(serverHandshakeState.serverCredentials);
            object = serverHandshakeState.serverCredentials.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(serverHandshakeState.serverContext, dTLSReliableHandshake, (Certificate)object, (OutputStream)object2);
        }
        securityParameters.tlsServerEndPoint = ((ByteArrayOutputStream)object2).toByteArray();
        if (object == null || ((Certificate)object).isEmpty()) {
            securityParameters.statusRequestVersion = 0;
        }
        if (securityParameters.getStatusRequestVersion() > 0 && (object = serverHandshakeState.server.getCertificateStatus()) != null) {
            object2 = this.generateCertificateStatus(serverHandshakeState, (CertificateStatus)object);
            dTLSReliableHandshake.sendMessage((short)22, (byte[])object2);
        }
        if ((object = (Object)serverHandshakeState.keyExchange.generateServerKeyExchange()) != null) {
            dTLSReliableHandshake.sendMessage((short)12, (byte[])object);
        }
        if (serverHandshakeState.serverCredentials != null) {
            serverHandshakeState.certificateRequest = serverHandshakeState.server.getCertificateRequest();
            if (null == serverHandshakeState.certificateRequest) {
                if (!serverHandshakeState.keyExchange.requiresCertificateVerify()) {
                    throw new TlsFatalAlert(80);
                }
            } else {
                if (TlsUtils.isTLSv12(serverHandshakeState.serverContext) != (serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                serverHandshakeState.certificateRequest = TlsUtils.validateCertificateRequest(serverHandshakeState.certificateRequest, serverHandshakeState.keyExchange);
                TlsUtils.establishServerSigAlgs(securityParameters, serverHandshakeState.certificateRequest);
                TlsUtils.trackHashAlgorithms(dTLSReliableHandshake.getHandshakeHash(), securityParameters.getServerSigAlgs());
                object2 = this.generateCertificateRequest(serverHandshakeState, serverHandshakeState.certificateRequest);
                dTLSReliableHandshake.sendMessage((short)13, (byte[])object2);
            }
        }
        dTLSReliableHandshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        boolean bl = false;
        TlsUtils.sealHandshakeHash(serverHandshakeState.serverContext, dTLSReliableHandshake.getHandshakeHash(), bl);
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processClientSupplementalData(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            serverHandshakeState.server.processClientSupplementalData(null);
        }
        if (serverHandshakeState.certificateRequest == null) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else if (message.getType() == 11) {
            this.processClientCertificate(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12(serverHandshakeState.serverContext)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(serverHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(serverHandshakeState, message.getBody());
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(dTLSReliableHandshake.getHandshakeHash());
        TlsProtocol.establishMasterSecret(serverHandshakeState.serverContext, serverHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(serverHandshakeState.serverContext));
        Object object3 = dTLSReliableHandshake.prepareToFinish();
        if (this.expectCertificateVerifyMessage(serverHandshakeState)) {
            byArray = dTLSReliableHandshake.receiveMessageBody((short)15);
            this.processCertificateVerify(serverHandshakeState, byArray, (TlsHandshakeHash)object3);
        }
        securityParameters.peerVerifyData = TlsUtils.calculateVerifyData(serverHandshakeState.serverContext, dTLSReliableHandshake.getHandshakeHash(), false);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        if (serverHandshakeState.expectSessionTicket) {
            object3 = serverHandshakeState.server.getNewSessionTicket();
            byArray = this.generateNewSessionTicket(serverHandshakeState, (NewSessionTicket)object3);
            dTLSReliableHandshake.sendMessage((short)4, byArray);
        }
        securityParameters.localVerifyData = TlsUtils.calculateVerifyData(serverHandshakeState.serverContext, dTLSReliableHandshake.getHandshakeHash(), true);
        dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        dTLSReliableHandshake.finish();
        serverHandshakeState.sessionMasterSecret = securityParameters.getMasterSecret();
        serverHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(serverHandshakeState.serverContext.getCrypto().adoptSecret(serverHandshakeState.sessionMasterSecret)).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(serverHandshakeState.serverExtensions).build();
        serverHandshakeState.tlsSession = TlsUtils.importSession(serverHandshakeState.tlsSession.getSessionID(), serverHandshakeState.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
        serverHandshakeState.serverContext.handshakeComplete(serverHandshakeState.server, serverHandshakeState.tlsSession);
        dTLSRecordLayer.initHeartbeat(serverHandshakeState.heartbeat, 1 == serverHandshakeState.heartbeatPolicy);
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState serverHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(serverHandshakeState.serverContext, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState serverHandshakeState, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState serverHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = serverHandshakeState.server.getServerVersion();
        if (!ProtocolVersion.contains(tlsServerContextImpl.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.negotiatedVersion = protocolVersion;
        TlsUtils.negotiatedVersionDTLSServer(tlsServerContextImpl);
        int n = ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(protocolVersion) && serverHandshakeState.server.shouldUseGMTUnixTime() ? 1 : 0;
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(n != 0, tlsServerContextImpl);
        if (!protocolVersion.equals(ProtocolVersion.getLatestDTLS(serverHandshakeState.server.getProtocolVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        if (!TlsUtils.isValidCipherSuiteSelection(serverHandshakeState.offeredCipherSuites, n = DTLSServerProtocol.validateSelectedCipherSuite(serverHandshakeState.server.getSelectedCipherSuite(), (short)80)) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        serverHandshakeState.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(serverHandshakeState.server.getServerExtensions());
        serverHandshakeState.server.getServerExtensionsForConnection(serverHandshakeState.serverExtensions);
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
            protocolVersion2 = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionServer(serverHandshakeState.serverExtensions, protocolVersion);
        }
        if (securityParameters.isSecureRenegotiation()) {
            boolean bl;
            object = TlsUtils.getExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl2 = bl = null == object;
            if (bl) {
                serverHandshakeState.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            securityParameters.extendedMasterSecret = true;
        } else {
            boolean bl = securityParameters.extendedMasterSecret = serverHandshakeState.offeredExtendedMasterSecret && serverHandshakeState.server.shouldUseExtendedMasterSecret();
            if (securityParameters.isExtendedMasterSecret()) {
                TlsExtensionsUtils.addExtendedMasterSecretExtension(serverHandshakeState.serverExtensions);
            } else {
                if (serverHandshakeState.server.requiresExtendedMasterSecret()) {
                    throw new TlsFatalAlert(40);
                }
                if (serverHandshakeState.resumedSession && !serverHandshakeState.server.allowLegacyResumption()) {
                    throw new TlsFatalAlert(80);
                }
            }
        }
        if (null != serverHandshakeState.heartbeat || 1 == serverHandshakeState.heartbeatPolicy) {
            TlsExtensionsUtils.addHeartbeatExtension(serverHandshakeState.serverExtensions, new HeartbeatExtension(serverHandshakeState.heartbeatPolicy));
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(serverHandshakeState.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        if (!serverHandshakeState.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(serverHandshakeState.serverExtensions);
            securityParameters.maxFragmentLength = DTLSServerProtocol.evaluateMaxFragmentLengthExtension(serverHandshakeState.resumedSession, serverHandshakeState.clientExtensions, serverHandshakeState.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(serverHandshakeState.serverExtensions);
            if (!serverHandshakeState.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2, (short)80)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80)) {
                    securityParameters.statusRequestVersion = 1;
                }
            }
            serverHandshakeState.expectSessionTicket = !serverHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        DTLSServerProtocol.applyMaxFragmentLengthExtension(dTLSRecordLayer, securityParameters.getMaxFragmentLength());
        object = new ServerHello(protocolVersion2, securityParameters.getServerRandom(), serverHandshakeState.tlsSession.getSessionID(), securityParameters.getCipherSuite(), serverHandshakeState.serverExtensions);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object.encode(serverHandshakeState.serverContext, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState serverHandshakeState) {
        if (serverHandshakeState.sessionMasterSecret != null) {
            serverHandshakeState.sessionMasterSecret.destroy();
            serverHandshakeState.sessionMasterSecret = null;
        }
        if (serverHandshakeState.sessionParameters != null) {
            serverHandshakeState.sessionParameters.clear();
            serverHandshakeState.sessionParameters = null;
        }
        if (serverHandshakeState.tlsSession != null) {
            serverHandshakeState.tlsSession.invalidate();
            serverHandshakeState.tlsSession = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState serverHandshakeState, Certificate certificate) throws IOException {
        if (null == serverHandshakeState.certificateRequest) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.processClientCertificate(serverHandshakeState.serverContext, certificate, serverHandshakeState.keyExchange, serverHandshakeState.server);
    }

    protected void processClientCertificate(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(serverHandshakeState.serverContext, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(serverHandshakeState, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState serverHandshakeState, byte[] byArray, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsServerContextImpl, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerifyClient(tlsServerContextImpl, serverHandshakeState.certificateRequest, digitallySigned, tlsHandshakeHash);
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClientHello clientHello = ClientHello.parse(byteArrayInputStream, NullOutputStream.INSTANCE);
        this.processClientHello(serverHandshakeState, clientHello);
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, ClientHello clientHello) throws IOException {
        Object object;
        ProtocolVersion protocolVersion = clientHello.getVersion();
        serverHandshakeState.offeredCipherSuites = clientHello.getCipherSuites();
        serverHandshakeState.clientExtensions = clientHello.getExtensions();
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(47);
        }
        tlsServerContextImpl.setRSAPreMasterSecretVersion(protocolVersion);
        tlsServerContextImpl.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(serverHandshakeState.clientExtensions));
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (null == tlsServerContextImpl.getClientSupportedVersions()) {
            if (protocolVersion2.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                protocolVersion2 = ProtocolVersion.DTLSv12;
            }
            tlsServerContextImpl.setClientSupportedVersions(protocolVersion2.downTo(ProtocolVersion.DTLSv10));
        } else {
            protocolVersion2 = ProtocolVersion.getLatestDTLS(tlsServerContextImpl.getClientSupportedVersions());
        }
        if (!ProtocolVersion.SERVER_EARLIEST_SUPPORTED_DTLS.isEqualOrEarlierVersionOf(protocolVersion2)) {
            throw new TlsFatalAlert(70);
        }
        tlsServerContextImpl.setClientVersion(protocolVersion2);
        serverHandshakeState.server.notifyClientVersion(tlsServerContextImpl.getClientVersion());
        securityParameters.clientRandom = clientHello.getRandom();
        serverHandshakeState.server.notifyFallback(Arrays.contains(serverHandshakeState.offeredCipherSuites, 22016));
        serverHandshakeState.server.notifyOfferedCipherSuites(serverHandshakeState.offeredCipherSuites);
        if (Arrays.contains(serverHandshakeState.offeredCipherSuites, 255)) {
            securityParameters.secureRenegotiation = true;
        }
        if ((object = TlsUtils.getExtensionData(serverHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        serverHandshakeState.server.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        serverHandshakeState.offeredExtendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(serverHandshakeState.clientExtensions);
        if (serverHandshakeState.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(serverHandshakeState.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(serverHandshakeState.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion2)) {
                TlsUtils.establishClientSigAlgs(securityParameters, serverHandshakeState.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(serverHandshakeState.clientExtensions);
            object = TlsExtensionsUtils.getHeartbeatExtension(serverHandshakeState.clientExtensions);
            if (null != object) {
                if (1 == ((HeartbeatExtension)object).getMode()) {
                    serverHandshakeState.heartbeat = serverHandshakeState.server.getHeartbeat();
                }
                serverHandshakeState.heartbeatPolicy = serverHandshakeState.server.getHeartbeatPolicy();
            }
            serverHandshakeState.server.processClientExtensions(serverHandshakeState.clientExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        serverHandshakeState.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        serverHandshakeState.server.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState serverHandshakeState) {
        if (null == serverHandshakeState.certificateRequest) {
            return false;
        }
        Certificate certificate = serverHandshakeState.serverContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && (null == serverHandshakeState.keyExchange || serverHandshakeState.keyExchange.requiresCertificateVerify());
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        TlsSecret sessionMasterSecret = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean offeredExtendedMasterSecret = false;
        boolean resumedSession = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsCredentials serverCredentials = null;
        CertificateRequest certificateRequest = null;
        TlsHeartbeat heartbeat = null;
        short heartbeatPolicy = (short)2;

        protected ServerHandshakeState() {
        }
    }
}

