/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class CertificateRequest {
    protected final byte[] certificateRequestContext;
    protected final short[] certificateTypes;
    protected final Vector supportedSignatureAlgorithms;
    protected final Vector supportedSignatureAlgorithmsCert;
    protected final Vector certificateAuthorities;

    private static Vector checkSupportedSignatureAlgorithms(Vector vector, short s2) throws IOException {
        if (null == vector) {
            throw new TlsFatalAlert(s2, "'signature_algorithms' is required");
        }
        return vector;
    }

    public CertificateRequest(short[] sArray, Vector vector, Vector vector2) {
        this(null, sArray, vector, null, vector2);
    }

    public CertificateRequest(byte[] byArray, Vector vector, Vector vector2, Vector vector3) throws IOException {
        this(byArray, null, CertificateRequest.checkSupportedSignatureAlgorithms(vector, (short)80), vector2, vector3);
    }

    private CertificateRequest(byte[] byArray, short[] sArray, Vector vector, Vector vector2, Vector vector3) {
        if (null != byArray && !TlsUtils.isValidUint8(byArray.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (!(null == sArray || sArray.length >= 1 && TlsUtils.isValidUint8(sArray.length))) {
            throw new IllegalArgumentException("'certificateTypes' should have length from 1 to 255");
        }
        this.certificateRequestContext = TlsUtils.clone(byArray);
        this.certificateTypes = sArray;
        this.supportedSignatureAlgorithms = vector;
        this.supportedSignatureAlgorithmsCert = vector2;
        this.certificateAuthorities = vector3;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public Vector getSupportedSignatureAlgorithmsCert() {
        return this.supportedSignatureAlgorithmsCert;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public boolean hasCertificateRequestContext(byte[] byArray) {
        return Arrays.areEqual(this.certificateRequestContext, byArray);
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        ProtocolVersion protocolVersion = tlsContext.getServerVersion();
        boolean bl = TlsUtils.isTLSv12(protocolVersion);
        boolean bl2 = TlsUtils.isTLSv13(protocolVersion);
        if (bl2 != (null != this.certificateRequestContext) || bl2 != (null == this.certificateTypes) || bl != (null != this.supportedSignatureAlgorithms) || !bl2 && null != this.supportedSignatureAlgorithmsCert) {
            throw new IllegalStateException();
        }
        if (bl2) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, outputStream);
            Hashtable hashtable = new Hashtable();
            TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, this.supportedSignatureAlgorithms);
            if (null != this.supportedSignatureAlgorithmsCert) {
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(hashtable, this.supportedSignatureAlgorithmsCert);
            }
            if (null != this.certificateAuthorities) {
                TlsExtensionsUtils.addCertificateAuthoritiesExtension(hashtable, this.certificateAuthorities);
            }
            byte[] byArray = TlsProtocol.writeExtensionsData(hashtable);
            TlsUtils.writeOpaque16(byArray, outputStream);
            return;
        }
        TlsUtils.writeUint8ArrayWithUint8Length(this.certificateTypes, outputStream);
        if (bl) {
            TlsUtils.encodeSupportedSignatureAlgorithms(this.supportedSignatureAlgorithms, outputStream);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, outputStream);
        } else {
            Object object;
            int n;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n2 = 0;
            for (n = 0; n < this.certificateAuthorities.size(); ++n) {
                object = (X500Name)this.certificateAuthorities.elementAt(n);
                byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                vector.addElement(byArray);
                n2 += byArray.length + 2;
            }
            TlsUtils.checkUint16(n2);
            TlsUtils.writeUint16(n2, outputStream);
            for (n = 0; n < vector.size(); ++n) {
                object = (byte[])vector.elementAt(n);
                TlsUtils.writeOpaque16((byte[])object, outputStream);
            }
        }
    }

    public static CertificateRequest parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        ProtocolVersion protocolVersion = tlsContext.getServerVersion();
        boolean bl = TlsUtils.isTLSv13(protocolVersion);
        if (bl) {
            byte[] byArray = TlsUtils.readOpaque8(inputStream);
            byte[] byArray2 = TlsUtils.readOpaque16(inputStream);
            Hashtable hashtable = TlsProtocol.readExtensionsData13(13, byArray2);
            Vector vector = CertificateRequest.checkSupportedSignatureAlgorithms(TlsExtensionsUtils.getSignatureAlgorithmsExtension(hashtable), (short)109);
            Vector vector2 = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(hashtable);
            Vector vector3 = TlsExtensionsUtils.getCertificateAuthoritiesExtension(hashtable);
            return new CertificateRequest(byArray, vector, vector2, vector3);
        }
        boolean bl2 = TlsUtils.isTLSv12(protocolVersion);
        short[] sArray = TlsUtils.readUint8ArrayWithUint8Length(inputStream, 1);
        Vector vector = null;
        if (bl2) {
            vector = TlsUtils.parseSupportedSignatureAlgorithms(inputStream);
        }
        Vector<X500Name> vector4 = null;
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        if (byArray.length > 0) {
            vector4 = new Vector<X500Name>();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            do {
                byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream, 1);
                ASN1Primitive aSN1Primitive = TlsUtils.readDERObject(byArray3);
                vector4.addElement(X500Name.getInstance(aSN1Primitive));
            } while (byteArrayInputStream.available() > 0);
        }
        return new CertificateRequest(sArray, vector, vector4);
    }
}

