/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.JsseUtils;

class ProvX509Key
implements BCX509Key {
    private final PrivateKey privateKey;
    private final X509Certificate[] certificateChain;

    static ProvX509Key from(X509KeyManager x509KeyManager, String string) {
        if (null == x509KeyManager) {
            throw new NullPointerException("'x509KeyManager' cannot be null");
        }
        if (null == string) {
            return null;
        }
        PrivateKey privateKey = x509KeyManager.getPrivateKey(string);
        if (null == privateKey) {
            return null;
        }
        X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(string);
        if (null == x509CertificateArray || x509CertificateArray.length < 1) {
            return null;
        }
        if (JsseUtils.containsNull(x509CertificateArray = (X509Certificate[])x509CertificateArray.clone())) {
            return null;
        }
        return new ProvX509Key(privateKey, x509CertificateArray);
    }

    ProvX509Key(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.privateKey = privateKey;
        this.certificateChain = x509CertificateArray;
    }

    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

