/*
 * Decompiled with CFR 0.152.
 */
package java_cup.runtime;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java_cup.runtime.XMLElement;

public class SyntaxTreeXPath {
    public static List<XMLElement> query(String query, XMLElement element) {
        if (query.startsWith("/")) {
            query = query.substring(1);
        }
        return SyntaxTreeXPath.query0(new LinkedList<String>(Arrays.asList(query.split("/"))), 0, element, 0);
    }

    private static List<XMLElement> query0(List<String> q, int idx, XMLElement element, int seq) {
        if (q.get(idx).isEmpty()) {
            return SyntaxTreeXPath.matchDeeperDescendant(q, idx + 1, element, seq);
        }
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        if (!SyntaxTreeXPath.match(q.get(idx), element, seq)) {
            return new LinkedList<XMLElement>();
        }
        if (q.size() - 1 == idx) {
            return SyntaxTreeXPath.singleton(element);
        }
        List<XMLElement> children = element.getChildren();
        int i = 0;
        while (i < children.size()) {
            XMLElement child = children.get(i);
            l.addAll(SyntaxTreeXPath.query0(q, idx + 1, child, i));
            ++i;
        }
        return l;
    }

    private static List<XMLElement> matchDeeperDescendant(List<String> query, int idx, XMLElement element, int seq) {
        if (query.size() <= idx) {
            return SyntaxTreeXPath.singleton(element);
        }
        boolean matches = SyntaxTreeXPath.match(query.get(idx), element, seq);
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        List<XMLElement> children = element.getChildren();
        if (matches) {
            return SyntaxTreeXPath.query0(query, idx, element, seq);
        }
        int i = 0;
        while (i < children.size()) {
            XMLElement child = children.get(i);
            l.addAll(SyntaxTreeXPath.matchDeeperDescendant(query, idx, child, i));
            ++i;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean match(String m3, XMLElement elem, int seq) {
        boolean result = true;
        String[] name = m3.split("\\[");
        String[] tag = name[0].split("\\*");
        result = tag[0].isEmpty() ? (tag.length > 2 ? (result &= elem.tagname.contains(tag[1])) : (tag.length == 2 ? (result &= elem.tagname.endsWith(tag[1])) : (result &= false))) : (tag.length == 2 ? (result &= elem.tagname.startsWith(tag[1])) : elem.tagname.equals(tag[0]));
        int i = 1;
        while (i < name.length) {
            String predicate = name[i];
            if (!predicate.endsWith("]")) {
                return false;
            }
            if ((predicate = predicate.substring(0, predicate.length() - 1)).startsWith("@")) {
                if (!predicate.substring(1).startsWith("variant")) return false;
                if (!(elem instanceof XMLElement.NonTerminal) || Integer.parseInt(predicate.substring(9)) != ((XMLElement.NonTerminal)elem).getVariant()) return false;
                result &= true;
            } else {
                if (!predicate.matches("\\d+")) return false;
                result &= Integer.parseInt(predicate) == seq;
            }
            ++i;
        }
        return result;
    }

    private static List<XMLElement> singleton(XMLElement elem) {
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        l.add(elem);
        return l;
    }
}

