/*
 * Decompiled with CFR 0.152.
 */
package inference;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import wpds.impl.Weight;

public class InferenceWeight
extends Weight {
    private final Set<SootMethod> invokedMethods;
    private final String rep;
    private static InferenceWeight one;
    private static InferenceWeight zero;

    private InferenceWeight(String rep) {
        this.rep = rep;
        this.invokedMethods = null;
    }

    private InferenceWeight(Set<SootMethod> res) {
        this.invokedMethods = res;
        this.rep = null;
    }

    public InferenceWeight(SootMethod m3) {
        this.invokedMethods = Collections.singleton(m3);
        this.rep = null;
    }

    @Override
    public Weight extendWith(Weight other) {
        if (other.equals(InferenceWeight.one())) {
            return this;
        }
        if (this.equals(InferenceWeight.one())) {
            return other;
        }
        if (other.equals(InferenceWeight.zero()) || this.equals(InferenceWeight.zero())) {
            return InferenceWeight.zero();
        }
        InferenceWeight func = (InferenceWeight)other;
        Set<SootMethod> otherInvokedMethods = func.invokedMethods;
        HashSet<SootMethod> res = new HashSet<SootMethod>(this.invokedMethods);
        res.addAll(otherInvokedMethods);
        return new InferenceWeight(res);
    }

    @Override
    public Weight combineWith(Weight other) {
        return this.extendWith(other);
    }

    public static InferenceWeight one() {
        if (one == null) {
            one = new InferenceWeight("ONE");
        }
        return one;
    }

    public static InferenceWeight zero() {
        if (zero == null) {
            zero = new InferenceWeight("ZERO");
        }
        return zero;
    }

    public String toString() {
        if (this.rep != null) {
            return this.rep;
        }
        return "{Func:" + this.invokedMethods.toString() + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        result = 31 * result + (this.invokedMethods == null ? 0 : this.invokedMethods.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InferenceWeight other = (InferenceWeight)obj;
        if (this.rep == null ? other.rep != null : !this.rep.equals(other.rep)) {
            return false;
        }
        return !(this.invokedMethods == null ? other.invokedMethods != null : !this.invokedMethods.equals(other.invokedMethods));
    }
}

