/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.callgraph.BoomerangICFG;
import boomerang.callgraph.ObservableICFG;
import boomerang.callgraph.ObservableStaticICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Field;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALSeedTimeout;
import ideal.IDEALWeightFunctions;
import ideal.NonOneFlowListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import sync.pds.solver.EmptyStackWitnessListener;
import sync.pds.solver.OneWeightFunctions;
import sync.pds.solver.WeightFunctions;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.ConnectPushListener;
import wpds.impl.NormalRule;
import wpds.impl.PushRule;
import wpds.impl.Rule;
import wpds.impl.StackListener;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public class IDEALSeedSolver<W extends Weight> {
    private final IDEALAnalysisDefinition<W> analysisDefinition;
    private final ForwardQuery seed;
    private final IDEALWeightFunctions<W> idealWeightFunctions;
    private final W zero;
    private final W one;
    private final WeightedBoomerang<W> phase1Solver;
    private final WeightedBoomerang<W> phase2Solver;
    private final Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
    private final SeedFactory<W> seedFactory;
    private Multimap<Node<Statement, Val>, Statement> affectedStrongUpdateStmt = HashMultimap.create();
    private Set<Node<Statement, Val>> weakUpdates = Sets.newHashSet();

    public IDEALSeedSolver(IDEALAnalysisDefinition<W> analysisDefinition, ForwardQuery seed, SeedFactory<W> seedFactory) {
        this.analysisDefinition = analysisDefinition;
        this.seed = seed;
        this.seedFactory = seedFactory;
        this.idealWeightFunctions = new IDEALWeightFunctions<W>(analysisDefinition.weightFunctions(), analysisDefinition.enableStrongUpdates());
        this.zero = analysisDefinition.weightFunctions().getZero();
        this.one = analysisDefinition.weightFunctions().getOne();
        this.phase1Solver = this.createSolver(Phases.ObjectFlow);
        this.phase2Solver = this.createSolver(Phases.ValueFlow);
    }

    public ForwardBoomerangResults<W> run() {
        ForwardBoomerangResults<W> resultPhase1 = this.runPhase(this.phase1Solver, Phases.ObjectFlow);
        if (resultPhase1.isTimedout()) {
            if (this.analysisStopwatch.isRunning()) {
                this.analysisStopwatch.stop();
            }
            throw new IDEALSeedTimeout(this, this.phase1Solver, resultPhase1);
        }
        ForwardBoomerangResults<W> resultPhase2 = this.runPhase(this.phase2Solver, Phases.ValueFlow);
        if (resultPhase2.isTimedout()) {
            if (this.analysisStopwatch.isRunning()) {
                this.analysisStopwatch.stop();
            }
            throw new IDEALSeedTimeout(this, this.phase2Solver, resultPhase2);
        }
        return resultPhase2;
    }

    private WeightedBoomerang<W> createSolver(final Phases phase) {
        return new WeightedBoomerang<W>(this.analysisDefinition.boomerangOptions()){

            @Override
            public ObservableICFG<Unit, SootMethod> icfg() {
                if (IDEALSeedSolver.this.analysisDefinition.icfg() == null) {
                    ((IDEALSeedSolver)IDEALSeedSolver.this).analysisDefinition.icfg = new ObservableStaticICFG(new BoomerangICFG(false));
                }
                return IDEALSeedSolver.this.analysisDefinition.icfg();
            }

            @Override
            public Debugger<W> createDebugger() {
                return IDEALSeedSolver.this.analysisDefinition.debugger(IDEALSeedSolver.this);
            }

            @Override
            protected WeightFunctions<Statement, Val, Statement, W> getForwardCallWeights(ForwardQuery sourceQuery) {
                if (sourceQuery.equals(IDEALSeedSolver.this.seed)) {
                    return IDEALSeedSolver.this.idealWeightFunctions;
                }
                return new OneWeightFunctions(IDEALSeedSolver.this.zero, IDEALSeedSolver.this.one);
            }

            @Override
            protected WeightFunctions<Statement, Val, Field, W> getForwardFieldWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.zero, IDEALSeedSolver.this.one);
            }

            @Override
            protected WeightFunctions<Statement, Val, Field, W> getBackwardFieldWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.zero, IDEALSeedSolver.this.one);
            }

            @Override
            protected WeightFunctions<Statement, Val, Statement, W> getBackwardCallWeights() {
                return new OneWeightFunctions(IDEALSeedSolver.this.zero, IDEALSeedSolver.this.one);
            }

            @Override
            public SeedFactory<W> getSeedFactory() {
                return IDEALSeedSolver.this.seedFactory;
            }

            @Override
            public boolean preventCallRuleAdd(ForwardQuery sourceQuery, Rule<Statement, INode<Val>, W> rule) {
                return phase.equals((Object)Phases.ValueFlow) && sourceQuery.equals(IDEALSeedSolver.this.seed) && IDEALSeedSolver.this.preventStrongUpdateFlows(rule);
            }
        };
    }

    protected boolean preventStrongUpdateFlows(Rule<Statement, INode<Val>, W> rule) {
        PushRule pushRule;
        Statement callSite;
        if (rule.getS1().equals(rule.getS2()) && this.idealWeightFunctions.isStrongUpdateStatement(rule.getL2()) && this.idealWeightFunctions.isKillFlow(new Node<Statement, Val>(rule.getL2(), rule.getS2().fact()))) {
            return true;
        }
        return rule instanceof PushRule && this.idealWeightFunctions.isStrongUpdateStatement(callSite = (Statement)(pushRule = (PushRule)rule).getCallSite()) && this.idealWeightFunctions.isKillFlow(new Node<Statement, Val>(callSite, rule.getS1().fact()));
    }

    private ForwardBoomerangResults<W> runPhase(final WeightedBoomerang<W> boomerang, final Phases phase) {
        this.analysisStopwatch.start();
        this.idealWeightFunctions.setPhase(phase);
        WeightedPAutomaton<Statement, INode<Val>, W> callAutomaton = boomerang.getSolvers().getOrCreate(this.seed).getCallAutomaton();
        if (phase.equals((Object)Phases.ValueFlow)) {
            this.registerIndirectFlowListener(boomerang.getSolvers().getOrCreate(this.seed));
        }
        callAutomaton.registerConnectPushListener(new ConnectPushListener<Statement, INode<Val>, W>(){

            @Override
            public void connect(Statement predOfCall, Statement callSite, INode<Val> returnedFact, W w) {
                if (!callSite.getMethod().equals(returnedFact.fact().m())) {
                    return;
                }
                if (!boomerang.getSolvers().getOrCreate(IDEALSeedSolver.this.seed).valueUsedInStatement(callSite.getUnit().get(), returnedFact.fact())) {
                    return;
                }
                if (!w.equals(IDEALSeedSolver.this.one)) {
                    IDEALSeedSolver.this.idealWeightFunctions.addOtherThanOneWeight(new Node<Statement, Val>(callSite, returnedFact.fact()));
                }
            }
        });
        this.idealWeightFunctions.registerListener(new NonOneFlowListener(){

            @Override
            public void nonOneFlow(Node<Statement, Val> curr) {
                if (phase.equals((Object)Phases.ValueFlow)) {
                    return;
                }
                AbstractBoomerangSolver seedSolver = boomerang.getSolvers().getOrCreate(IDEALSeedSolver.this.seed);
                seedSolver.getFieldAutomaton().registerListener(new TriggerBackwardQuery(seedSolver, boomerang, curr));
            }
        });
        ForwardBoomerangResults<W> res = boomerang.solve(this.seed);
        if (phase.equals((Object)Phases.ValueFlow)) {
            boomerang.debugOutput();
        }
        this.analysisStopwatch.stop();
        return res;
    }

    protected void addAffectedPotentialStrongUpdate(Node<Statement, Val> strongUpdateNode, Statement stmt) {
        if (this.affectedStrongUpdateStmt.put(strongUpdateNode, stmt)) {
            this.idealWeightFunctions.potentialStrongUpdate(stmt);
            if (this.weakUpdates.contains(strongUpdateNode)) {
                this.idealWeightFunctions.weakUpdate(stmt);
            }
        }
    }

    private void setWeakUpdate(Node<Statement, Val> curr) {
        if (this.weakUpdates.add(curr)) {
            for (Statement s2 : Lists.newArrayList(this.affectedStrongUpdateStmt.get(curr))) {
                this.idealWeightFunctions.weakUpdate(s2);
            }
        }
    }

    private void registerIndirectFlowListener(final AbstractBoomerangSolver<W> solver) {
        WeightedPAutomaton<Statement, INode<Val>, W> callAutomaton = solver.getCallAutomaton();
        callAutomaton.registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

            @Override
            public void onWeightAdded(Transition<Statement, INode<Val>> t, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                if (t.getStart() instanceof GeneratedState) {
                    return;
                }
                Node source = new Node(t.getLabel(), ((INode)t.getStart()).fact());
                Collection<Node<Statement, Val>> indirectFlows = IDEALSeedSolver.this.idealWeightFunctions.getAliasesFor(source);
                for (Node<Statement, Val> indirectFlow : indirectFlows) {
                    solver.addCallRule(new NormalRule<Location, SingleNode<Val>, Weight>(new SingleNode(source.fact()), (Location)source.stmt(), new SingleNode<Val>(indirectFlow.fact()), indirectFlow.stmt(), IDEALSeedSolver.this.one));
                    solver.addFieldRule(new NormalRule<Field, INode<Node<Statement, Val>>, Weight>(solver.asFieldFact(source), solver.fieldWildCard(), solver.asFieldFact(indirectFlow), solver.fieldWildCard(), IDEALSeedSolver.this.one));
                }
            }
        });
    }

    public WeightedBoomerang<W> getPhase1Solver() {
        return this.phase1Solver;
    }

    public WeightedBoomerang<W> getPhase2Solver() {
        return this.phase2Solver;
    }

    public Stopwatch getAnalysisStopwatch() {
        return this.analysisStopwatch;
    }

    public Query getSeed() {
        return this.seed;
    }

    public static enum Phases {
        ObjectFlow,
        ValueFlow;

    }

    private final class TriggerBackwardQuery
    extends WPAStateListener<Field, INode<Node<Statement, Val>>, W> {
        private final AbstractBoomerangSolver<W> seedSolver;
        private final WeightedBoomerang<W> boomerang;
        private final Node<Statement, Val> strongUpdateNode;

        private TriggerBackwardQuery(AbstractBoomerangSolver<W> seedSolver, WeightedBoomerang<W> boomerang, Node<Statement, Val> curr) {
            super(new SingleNode<Node<Statement, Val>>(curr));
            this.seedSolver = seedSolver;
            this.boomerang = boomerang;
            this.strongUpdateNode = curr;
        }

        @Override
        public void onOutTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> weightedPAutomaton) {
            if (!((Field)t.getLabel()).equals(Field.empty())) {
                return;
            }
            IDEALSeedSolver.this.addAffectedPotentialStrongUpdate(this.strongUpdateNode, this.strongUpdateNode.stmt());
            for (Unit u : IDEALSeedSolver.this.analysisDefinition.icfg().getPredsOf(this.strongUpdateNode.stmt().getUnit().get())) {
                BackwardQuery query = new BackwardQuery(new Statement((Stmt)u, this.strongUpdateNode.stmt().getMethod()), this.strongUpdateNode.fact());
                BackwardBoomerangResults queryResults = this.boomerang.backwardSolveUnderScope(query, IDEALSeedSolver.this.seed, this.strongUpdateNode);
                Set<ForwardQuery> queryAllocationSites = queryResults.getAllocationSites().keySet();
                this.setWeakUpdateIfNecessary();
                this.injectAliasesAtStrongUpdates(queryAllocationSites);
                this.injectAliasesAtStrongUpdatesAtCallStack(queryAllocationSites);
            }
        }

        private void injectAliasesAtStrongUpdatesAtCallStack(final Set<ForwardQuery> queryAllocationSites) {
            this.seedSolver.getCallAutomaton().registerListener(new StackListener<Statement, INode<Val>, W>(this.seedSolver.getCallAutomaton(), new SingleNode<Val>(this.strongUpdateNode.fact()), this.strongUpdateNode.stmt()){

                @Override
                public void anyContext(Statement end) {
                }

                @Override
                public void stackElement(Statement callSite) {
                    TriggerBackwardQuery.this.boomerang.checkTimeout();
                    IDEALSeedSolver.this.addAffectedPotentialStrongUpdate(TriggerBackwardQuery.this.strongUpdateNode, callSite);
                    for (ForwardQuery e : queryAllocationSites) {
                        AbstractBoomerangSolver solver = TriggerBackwardQuery.this.boomerang.getSolvers().get(e);
                        solver.getCallAutomaton().registerConnectPushListener(new IndirectFlowsAtCallSite(solver, callSite));
                    }
                }
            });
        }

        private void injectAliasesAtStrongUpdates(Set<ForwardQuery> queryAllocationSites) {
            for (ForwardQuery e : queryAllocationSites) {
                AbstractBoomerangSolver solver = this.boomerang.getSolvers().get(e);
                solver.getCallAutomaton().registerListener(new WPAUpdateListener<Statement, INode<Val>, W>(){

                    @Override
                    public void onWeightAdded(Transition<Statement, INode<Val>> t, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
                        if (((Statement)t.getLabel()).equals(TriggerBackwardQuery.this.strongUpdateNode.stmt())) {
                            IDEALSeedSolver.this.idealWeightFunctions.addNonKillFlow(TriggerBackwardQuery.this.strongUpdateNode);
                            IDEALSeedSolver.this.idealWeightFunctions.addIndirectFlow(TriggerBackwardQuery.this.strongUpdateNode, new Node<Statement, Val>((Statement)TriggerBackwardQuery.this.strongUpdateNode.stmt(), (Val)((INode)t.getStart()).fact()));
                        }
                    }
                });
            }
        }

        private void setWeakUpdateIfNecessary() {
            for (final Map.Entry e : this.boomerang.getSolvers().entrySet()) {
                if (!(e.getKey() instanceof ForwardQuery)) continue;
                e.getValue().synchedEmptyStackReachable(this.strongUpdateNode, new EmptyStackWitnessListener<Statement, Val>(){

                    @Override
                    public void witnessFound(Node<Statement, Val> targetFact) {
                        if (!((Query)e.getKey()).asNode().equals(IDEALSeedSolver.this.seed.asNode())) {
                            IDEALSeedSolver.this.setWeakUpdate(TriggerBackwardQuery.this.strongUpdateNode);
                        }
                    }
                });
            }
        }

        @Override
        public void onInTransitionAdded(Transition<Field, INode<Node<Statement, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<Statement, Val>>, W> weightedPAutomaton) {
        }
    }

    private final class IndirectFlowsAtCallSite
    implements ConnectPushListener<Statement, INode<Val>, W> {
        private final AbstractBoomerangSolver<W> solver;
        private final Statement cs;

        private IndirectFlowsAtCallSite(AbstractBoomerangSolver<W> solver, Statement cs) {
            this.solver = solver;
            this.cs = cs;
        }

        @Override
        public void connect(Statement predOfCall, Statement callSite, INode<Val> returnedFact, W w) {
            if (!this.solver.valueUsedInStatement(callSite.getUnit().get(), returnedFact.fact())) {
                return;
            }
            if (callSite.equals(this.cs)) {
                this.solver.getCallAutomaton().registerListener(new AddIndirectFlowAtCallSite(callSite, returnedFact.fact()));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cs == null ? 0 : this.cs.hashCode());
            result = 31 * result + (this.solver == null ? 0 : this.solver.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndirectFlowsAtCallSite other = (IndirectFlowsAtCallSite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cs == null ? other.cs != null : !this.cs.equals(other.cs)) {
                return false;
            }
            return !(this.solver == null ? other.solver != null : !this.solver.equals(other.solver));
        }

        private IDEALSeedSolver getOuterType() {
            return IDEALSeedSolver.this;
        }
    }

    private final class AddIndirectFlowAtCallSite
    implements WPAUpdateListener<Statement, INode<Val>, W> {
        private final Statement callSite;
        private final Val returnedFact;

        private AddIndirectFlowAtCallSite(Statement callSite, Val returnedFact) {
            this.callSite = callSite;
            this.returnedFact = returnedFact;
        }

        @Override
        public void onWeightAdded(Transition<Statement, INode<Val>> t, W w, WeightedPAutomaton<Statement, INode<Val>, W> aut) {
            if (((Statement)t.getLabel()).equals(this.callSite)) {
                IDEALSeedSolver.this.idealWeightFunctions.addNonKillFlow(new Node<Statement, Val>(this.callSite, this.returnedFact));
                IDEALSeedSolver.this.idealWeightFunctions.addIndirectFlow(new Node<Statement, Val>(this.callSite, this.returnedFact), new Node<Statement, Val>(this.callSite, (Val)((INode)t.getStart()).fact()));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            result = 31 * result + (this.returnedFact == null ? 0 : this.returnedFact.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddIndirectFlowAtCallSite other = (AddIndirectFlowAtCallSite)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.callSite == null ? other.callSite != null : !this.callSite.equals(other.callSite)) {
                return false;
            }
            return !(this.returnedFact == null ? other.returnedFact != null : !this.returnedFact.equals(other.returnedFact));
        }

        private IDEALSeedSolver getOuterType() {
            return IDEALSeedSolver.this;
        }
    }
}

