/*
 * Decompiled with CFR 0.152.
 */
package ideal;

import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.results.ForwardBoomerangResults;
import boomerang.seedfactory.SeedFactory;
import com.google.common.base.Stopwatch;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALSeedSolver;
import ideal.IDEALSeedTimeout;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import typestate.TransitionFunction;
import wpds.impl.Weight;

public class IDEALAnalysis<W extends Weight> {
    private static final Logger logger = LoggerFactory.getLogger(IDEALAnalysis.class);
    public static boolean PRINT_OPTIONS = false;
    protected final IDEALAnalysisDefinition<W> analysisDefinition;
    private final SeedFactory<W> seedFactory;
    private int seedCount;
    private Map<WeightedForwardQuery<W>, Stopwatch> analysisTime = new HashMap<WeightedForwardQuery<W>, Stopwatch>();
    private Set<WeightedForwardQuery<W>> timedoutSeeds = new HashSet<WeightedForwardQuery<W>>();

    public IDEALAnalysis(final IDEALAnalysisDefinition<W> analysisDefinition) {
        this.analysisDefinition = analysisDefinition;
        this.seedFactory = new SeedFactory<W>(){

            @Override
            protected Collection<WeightedForwardQuery<W>> generate(SootMethod method, Stmt stmt) {
                return analysisDefinition.generate(method, stmt);
            }

            @Override
            public ObservableICFG<Unit, SootMethod> icfg() {
                return analysisDefinition.icfg();
            }
        };
    }

    public void run() {
        this.printOptions();
        Collection<Query> initialSeeds = this.seedFactory.computeSeeds();
        if (initialSeeds.isEmpty()) {
            System.out.println("No seeds found!");
        } else {
            System.out.println("Analysing " + initialSeeds.size() + " seeds!");
        }
        for (Query s2 : initialSeeds) {
            if (!(s2 instanceof WeightedForwardQuery)) continue;
            WeightedForwardQuery seed = (WeightedForwardQuery)s2;
            ++this.seedCount;
            logger.info("Analyzing " + seed);
            Stopwatch watch = Stopwatch.createStarted();
            this.analysisTime.put(seed, watch);
            if (this.analysisDefinition.icfg() != null) {
                this.analysisDefinition.icfg().resetCallGraph();
            }
            ForwardBoomerangResults<W> res = this.run(seed);
            watch.stop();
            System.out.println("Analyzed (finished,timedout): \t (" + (this.seedCount - this.timedoutSeeds.size()) + "," + this.timedoutSeeds.size() + ") of " + initialSeeds.size() + " seeds! ");
            this.analysisDefinition.getResultHandler().report(seed, res);
        }
    }

    public ForwardBoomerangResults<W> run(ForwardQuery seed) {
        ForwardBoomerangResults<Weight> res;
        IDEALSeedSolver<W> idealAnalysis = new IDEALSeedSolver<W>(this.analysisDefinition, seed, this.seedFactory);
        try {
            if (this.analysisDefinition.icfg() != null) {
                this.analysisDefinition.icfg().addUnbalancedMethod(seed.stmt().getMethod());
            }
            res = idealAnalysis.run();
        }
        catch (IDEALSeedTimeout e) {
            res = e.getLastResults();
            this.timedoutSeeds.add((WeightedForwardQuery)seed);
        }
        this.analysisDefinition.getResultHandler().report((WeightedForwardQuery)seed, res);
        return res;
    }

    private void printOptions() {
        if (PRINT_OPTIONS) {
            System.out.println(this.analysisDefinition);
        }
    }

    public Collection<Query> computeSeeds() {
        return this.seedFactory.computeSeeds();
    }

    public Stopwatch getAnalysisTime(WeightedForwardQuery<TransitionFunction> key) {
        return this.analysisTime.get(key);
    }

    public boolean isTimedout(WeightedForwardQuery<TransitionFunction> key) {
        return this.timedoutSeeds.contains(key);
    }
}

