/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Booleans;
import fj.function.Characters;
import java.util.regex.Pattern;

public final class LazyString
implements CharSequence {
    private final Stream<Character> s;
    public static final LazyString empty = LazyString.str("");
    public static final F<LazyString, Stream<Character>> toStream = new F<LazyString, Stream<Character>>(){

        @Override
        public Stream<Character> f(LazyString string) {
            return string.toStream();
        }
    };
    public static final F<LazyString, String> toString = new F<LazyString, String>(){

        @Override
        public String f(LazyString string) {
            return string.toString();
        }
    };
    public static final F<Stream<Character>, LazyString> fromStream = new F<Stream<Character>, LazyString>(){

        @Override
        public LazyString f(Stream<Character> s2) {
            return LazyString.fromStream(s2);
        }
    };
    private static final Equal<Stream<Character>> eqS = Equal.streamEqual(Equal.charEqual);

    private LazyString(Stream<Character> s2) {
        this.s = s2;
    }

    public static LazyString str(String s2) {
        return new LazyString(Stream.unfold(new F<P2<String, Integer>, Option<P2<Character, P2<String, Integer>>>>(){

            @Override
            public Option<P2<Character, P2<String, Integer>>> f(P2<String, Integer> o) {
                String s2 = o._1();
                int n = o._2();
                Option<P2<Character, P2<String, Integer>>> none = Option.none();
                return s2.length() <= n ? none : Option.some(P.p(Character.valueOf(s2.charAt(n)), P.p(s2, n + 1)));
            }
        }, P.p(s2, 0)));
    }

    public static LazyString fromStream(Stream<Character> s2) {
        return new LazyString(s2);
    }

    public Stream<Character> toStream() {
        return this.s;
    }

    @Override
    public int length() {
        return this.s.length();
    }

    @Override
    public char charAt(int index) {
        return this.s.index(index).charValue();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return LazyString.fromStream(this.s.drop(start).take(end - start));
    }

    @Override
    public String toString() {
        return new StringBuilder(this).toString();
    }

    public LazyString append(LazyString cs) {
        return LazyString.fromStream(this.s.append(cs.s));
    }

    public LazyString append(String s2) {
        return this.append(LazyString.str(s2));
    }

    public boolean contains(LazyString cs) {
        return Booleans.or(this.s.tails().map(Function.compose(LazyString.startsWith().f(cs), fromStream)));
    }

    public boolean endsWith(LazyString cs) {
        return this.reverse().startsWith(cs.reverse());
    }

    public boolean startsWith(LazyString cs) {
        return cs.isEmpty() || !this.isEmpty() && Equal.charEqual.eq(Character.valueOf(this.head()), Character.valueOf(cs.head())) && this.tail().startsWith(cs.tail());
    }

    public static F<LazyString, F<LazyString, Boolean>> startsWith() {
        return Function.curry(new F2<LazyString, LazyString, Boolean>(){

            @Override
            public Boolean f(LazyString needle, LazyString haystack) {
                return haystack.startsWith(needle);
            }
        });
    }

    public char head() {
        return this.s.head().charValue();
    }

    public LazyString tail() {
        return LazyString.fromStream(this.s.tail()._1());
    }

    @Override
    public boolean isEmpty() {
        return this.s.isEmpty();
    }

    public LazyString reverse() {
        return LazyString.fromStream(this.s.reverse());
    }

    public Option<Integer> indexOf(char c) {
        return this.s.indexOf(Equal.charEqual.eq(Character.valueOf(c)));
    }

    public Option<Integer> indexOf(LazyString cs) {
        return this.s.substreams().indexOf(eqS.eq(cs.s));
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public Stream<LazyString> split(final F<Character, Boolean> p) {
        Stream<Character> findIt = this.s.dropWhile(p);
        final P2<Stream<Character>, Stream<Character>> ws = findIt.split(p);
        return findIt.isEmpty() ? Stream.nil() : Stream.cons(LazyString.fromStream(ws._1()), new P1<Stream<LazyString>>(){

            @Override
            public Stream<LazyString> _1() {
                return LazyString.fromStream((Stream)ws._2()).split(p);
            }
        });
    }

    public Stream<LazyString> split(char c) {
        return this.split(Equal.charEqual.eq(Character.valueOf(c)));
    }

    public Stream<LazyString> words() {
        return this.split(Characters.isSpaceChar);
    }

    public Stream<LazyString> lines() {
        return this.split('\n');
    }

    public static LazyString unlines(Stream<LazyString> str) {
        return LazyString.fromStream(Stream.join(str.intersperse(LazyString.str("\n")).map(toStream)));
    }

    public static LazyString unwords(Stream<LazyString> str) {
        return LazyString.fromStream(Stream.join(str.intersperse(LazyString.str(" ")).map(toStream)));
    }
}

