/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.Function;
import fj.Hash;
import fj.P;
import fj.P2;
import fj.Unit;
import fj.data.Array;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class HashMap<K, V>
implements Iterable<K> {
    private final java.util.HashMap<Key<K>, V> m;
    private final Equal<K> e;
    private final Hash<K> h;

    @Override
    public Iterator<K> iterator() {
        return this.keys().iterator();
    }

    public HashMap(Equal<K> e, Hash<K> h2) {
        this.m = new java.util.HashMap();
        this.e = e;
        this.h = h2;
    }

    public HashMap(Map<K, V> map, Equal<K> e, Hash<K> h2) {
        this(e, h2);
        for (K key : map.keySet()) {
            this.set(key, map.get(key));
        }
    }

    public HashMap(Equal<K> e, Hash<K> h2, int initialCapacity) {
        this.m = new java.util.HashMap(initialCapacity);
        this.e = e;
        this.h = h2;
    }

    public HashMap(Map<K, V> map) {
        this(map, Equal.anyEqual(), Hash.anyHash());
    }

    public HashMap(Equal<K> e, Hash<K> h2, int initialCapacity, float loadFactor) {
        this.m = new java.util.HashMap(initialCapacity, loadFactor);
        this.e = e;
        this.h = h2;
    }

    public static <K, V> HashMap<K, V> hashMap() {
        Equal e = Equal.anyEqual();
        Hash h2 = Hash.anyHash();
        return new HashMap(e, h2);
    }

    public boolean eq(K k1, K k2) {
        return this.e.eq(k1, k2);
    }

    public int hash(K k) {
        return this.h.hash(k);
    }

    public Option<V> get(K k) {
        return Option.fromNull(this.m.get(new Key<K>(k, this.e, this.h)));
    }

    public F<K, Option<V>> get() {
        return new F<K, Option<V>>(){

            @Override
            public Option<V> f(K k) {
                return HashMap.this.get(k);
            }
        };
    }

    public void clear() {
        this.m.clear();
    }

    public boolean contains(K k) {
        return this.m.containsKey(new Key<K>(k, this.e, this.h));
    }

    public List<K> keys() {
        List.Buffer<K> b = new List.Buffer<K>();
        for (Key<K> k : this.m.keySet()) {
            b.snoc(k.k());
        }
        return b.toList();
    }

    public List<V> values() {
        return this.keys().map(new F<K, V>(){

            @Override
            public V f(K k) {
                return HashMap.this.m.get(new Key(k, HashMap.this.e, HashMap.this.h));
            }
        });
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public int size() {
        return this.m.size();
    }

    public void set(K k, V v) {
        if (v != null) {
            this.m.put(new Key<K>(k, this.e, this.h), v);
        }
    }

    public void delete(K k) {
        this.m.remove(new Key<K>(k, this.e, this.h));
    }

    public Option<V> getDelete(K k) {
        return Option.fromNull(this.m.remove(new Key<K>(k, this.e, this.h)));
    }

    public <A, B> HashMap<A, B> map(F<K, A> keyFunction, F<V, B> valueFunction, Equal<A> equal, Hash<A> hash) {
        HashMap<A, B> hashMap = new HashMap<A, B>(equal, hash);
        for (K key : this.keys()) {
            A newKey = keyFunction.f(key);
            B newValue = valueFunction.f(this.get(key).some());
            hashMap.set(newKey, newValue);
        }
        return hashMap;
    }

    public <A, B> HashMap<A, B> map(F<K, A> keyFunction, F<V, B> valueFunction) {
        return this.map(keyFunction, valueFunction, Equal.anyEqual(), Hash.anyHash());
    }

    public <A, B> HashMap<A, B> map(F<P2<K, V>, P2<A, B>> function, Equal<A> equal, Hash<A> hash) {
        return HashMap.from(this.toStream().map(function), equal, hash);
    }

    public <A, B> HashMap<A, B> map(F<P2<K, V>, P2<A, B>> function) {
        return HashMap.from(this.toStream().map(function));
    }

    public <A> HashMap<A, V> mapKeys(F<K, A> keyFunction, Equal<A> equal, Hash<A> hash) {
        return this.map(keyFunction, Function.identity(), equal, hash);
    }

    public <A> HashMap<A, V> mapKeys(F<K, A> function) {
        return this.mapKeys(function, Equal.anyEqual(), Hash.anyHash());
    }

    public <B> HashMap<K, B> mapValues(F<V, B> function) {
        return this.map(Function.identity(), function, this.e, this.h);
    }

    public void foreachDoEffect(Effect1<P2<K, V>> effect) {
        this.toStream().foreachDoEffect(effect);
    }

    public void foreach(F<P2<K, V>, Unit> function) {
        this.toStream().foreach(function);
    }

    public List<P2<K, V>> toList() {
        return this.keys().map(new F<K, P2<K, V>>(){

            @Override
            public P2<K, V> f(K k) {
                return P.p(k, HashMap.this.get(k).some());
            }
        });
    }

    public Collection<P2<K, V>> toCollection() {
        return this.toList().toCollection();
    }

    public Stream<P2<K, V>> toStream() {
        return this.toList().toStream();
    }

    public Option<P2<K, V>> toOption() {
        return this.toList().toOption();
    }

    public Array<P2<K, V>> toArray() {
        return this.toList().toArray();
    }

    public Map<K, V> toMap() {
        java.util.HashMap<K, V> result = new java.util.HashMap<K, V>();
        for (K key : this.keys()) {
            result.put(key, this.get(key).some());
        }
        return result;
    }

    public static <K, V> HashMap<K, V> from(Iterable<P2<K, V>> entries) {
        return HashMap.from(entries, Equal.anyEqual(), Hash.anyHash());
    }

    public static <K, V> HashMap<K, V> from(Iterable<P2<K, V>> entries, Equal<K> equal, Hash<K> hash) {
        HashMap<K, V> map = new HashMap<K, V>(equal, hash);
        for (P2<K, V> entry : entries) {
            map.set(entry._1(), entry._2());
        }
        return map;
    }

    private final class Key<K> {
        private final K k;
        private final Equal<K> e;
        private final Hash<K> h;

        Key(K k, Equal<K> e, Hash<K> h2) {
            this.k = k;
            this.e = e;
            this.h = h2;
        }

        K k() {
            return this.k;
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.e.eq(this.k, ((Key)o).k());
        }

        public int hashCode() {
            return this.h.hash(this.k);
        }
    }
}

