/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.Ordering;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Enumerator<A> {
    private final F<A, Option<A>> successor;
    private final F<A, Option<A>> predecessor;
    private final Option<A> max;
    private final Option<A> min;
    private final Ord<A> order;
    private final F<A, F<Long, Option<A>>> plus;
    public static final Enumerator<Boolean> booleanEnumerator = Enumerator.enumerator(new F<Boolean, Option<Boolean>>(){

        @Override
        public Option<Boolean> f(Boolean b) {
            return b != false ? Option.none() : Option.some(true);
        }
    }, new F<Boolean, Option<Boolean>>(){

        @Override
        public Option<Boolean> f(Boolean b) {
            return b != false ? Option.some(false) : Option.none();
        }
    }, Option.some(true), Option.some(false), Ord.booleanOrd);
    public static final Enumerator<Byte> byteEnumerator = Enumerator.enumerator(new F<Byte, Option<Byte>>(){

        @Override
        public Option<Byte> f(Byte b) {
            return b == 127 ? Option.none() : Option.some((byte)(b + 1));
        }
    }, new F<Byte, Option<Byte>>(){

        @Override
        public Option<Byte> f(Byte b) {
            return b == -128 ? Option.none() : Option.some((byte)(b - 1));
        }
    }, Option.some((byte)127), Option.some((byte)-128), Ord.byteOrd);
    public static final Enumerator<Character> charEnumerator = Enumerator.enumerator(new F<Character, Option<Character>>(){

        @Override
        public Option<Character> f(Character c) {
            return c.charValue() == '\uffff' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() + '\u0001')));
        }
    }, new F<Character, Option<Character>>(){

        @Override
        public Option<Character> f(Character c) {
            return c.charValue() == '\u0000' ? Option.none() : Option.some(Character.valueOf((char)(c.charValue() - '\u0001')));
        }
    }, Option.some(Character.valueOf('\uffff')), Option.some(Character.valueOf('\u0000')), Ord.charOrd);
    public static final Enumerator<Double> doubleEnumerator = Enumerator.enumerator(new F<Double, Option<Double>>(){

        @Override
        public Option<Double> f(Double d) {
            return d == Double.MAX_VALUE ? Option.none() : Option.some(d + 1.0);
        }
    }, new F<Double, Option<Double>>(){

        @Override
        public Option<Double> f(Double d) {
            return d == Double.MIN_VALUE ? Option.none() : Option.some(d - 1.0);
        }
    }, Option.some(Double.MAX_VALUE), Option.some(Double.MIN_VALUE), Ord.doubleOrd);
    public static final Enumerator<Float> floatEnumerator = Enumerator.enumerator(new F<Float, Option<Float>>(){

        @Override
        public Option<Float> f(Float f) {
            return f.floatValue() == Float.MAX_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() + 1.0f));
        }
    }, new F<Float, Option<Float>>(){

        @Override
        public Option<Float> f(Float f) {
            return f.floatValue() == Float.MIN_VALUE ? Option.none() : Option.some(Float.valueOf(f.floatValue() - 1.0f));
        }
    }, Option.some(Float.valueOf(Float.MAX_VALUE)), Option.some(Float.valueOf(Float.MIN_VALUE)), Ord.floatOrd);
    public static final Enumerator<Integer> intEnumerator = Enumerator.enumerator(new F<Integer, Option<Integer>>(){

        @Override
        public Option<Integer> f(Integer i) {
            return i == Integer.MAX_VALUE ? Option.none() : Option.some(i + 1);
        }
    }, new F<Integer, Option<Integer>>(){

        @Override
        public Option<Integer> f(Integer i) {
            return i == Integer.MIN_VALUE ? Option.none() : Option.some(i - 1);
        }
    }, Option.some(Integer.MAX_VALUE), Option.some(Integer.MIN_VALUE), Ord.intOrd);
    public static final Enumerator<BigInteger> bigintEnumerator = Enumerator.enumerator(new F<BigInteger, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger i) {
            return Option.some(i.add(BigInteger.ONE));
        }
    }, new F<BigInteger, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger i) {
            return Option.some(i.subtract(BigInteger.ONE));
        }
    }, Option.none(), Option.none(), Ord.bigintOrd, Function.curry(new F2<BigInteger, Long, Option<BigInteger>>(){

        @Override
        public Option<BigInteger> f(BigInteger i, Long l) {
            return Option.some(i.add(BigInteger.valueOf(l)));
        }
    }));
    public static final Enumerator<BigDecimal> bigdecimalEnumerator = Enumerator.enumerator(new F<BigDecimal, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal i) {
            return Option.some(i.add(BigDecimal.ONE));
        }
    }, new F<BigDecimal, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal i) {
            return Option.some(i.subtract(BigDecimal.ONE));
        }
    }, Option.none(), Option.none(), Ord.bigdecimalOrd, Function.curry(new F2<BigDecimal, Long, Option<BigDecimal>>(){

        @Override
        public Option<BigDecimal> f(BigDecimal d, Long l) {
            return Option.some(d.add(BigDecimal.valueOf(l)));
        }
    }));
    public static final Enumerator<Long> longEnumerator = Enumerator.enumerator(new F<Long, Option<Long>>(){

        @Override
        public Option<Long> f(Long i) {
            return i == Long.MAX_VALUE ? Option.none() : Option.some(i + 1L);
        }
    }, new F<Long, Option<Long>>(){

        @Override
        public Option<Long> f(Long i) {
            return i == Long.MIN_VALUE ? Option.none() : Option.some(i - 1L);
        }
    }, Option.some(Long.MAX_VALUE), Option.some(Long.MIN_VALUE), Ord.longOrd);
    public static final Enumerator<Short> shortEnumerator = Enumerator.enumerator(new F<Short, Option<Short>>(){

        @Override
        public Option<Short> f(Short i) {
            return i == Short.MAX_VALUE ? Option.none() : Option.some((short)(i + 1));
        }
    }, new F<Short, Option<Short>>(){

        @Override
        public Option<Short> f(Short i) {
            return i == Short.MIN_VALUE ? Option.none() : Option.some((short)(i - 1));
        }
    }, Option.some((short)Short.MAX_VALUE), Option.some((short)Short.MIN_VALUE), Ord.shortOrd);
    public static final Enumerator<Ordering> orderingEnumerator = Enumerator.enumerator(new F<Ordering, Option<Ordering>>(){

        @Override
        public Option<Ordering> f(Ordering o) {
            return o == Ordering.LT ? Option.some(Ordering.EQ) : (o == Ordering.EQ ? Option.some(Ordering.GT) : Option.none());
        }
    }, new F<Ordering, Option<Ordering>>(){

        @Override
        public Option<Ordering> f(Ordering o) {
            return o == Ordering.GT ? Option.some(Ordering.EQ) : (o == Ordering.EQ ? Option.some(Ordering.LT) : Option.none());
        }
    }, Option.some(Ordering.GT), Option.some(Ordering.LT), Ord.orderingOrd);
    public static final Enumerator<Natural> naturalEnumerator = Enumerator.enumerator(new F<Natural, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural n) {
            return Option.some(n.succ());
        }
    }, new F<Natural, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural n) {
            return n.pred();
        }
    }, Option.none(), Option.some(Natural.ZERO), Ord.naturalOrd, Function.curry(new F2<Natural, Long, Option<Natural>>(){

        @Override
        public Option<Natural> f(Natural n, Long l) {
            return Option.some(n).apply(Natural.natural(l).map(Function.curry(new F2<Natural, Natural, Natural>(){

                @Override
                public Natural f(Natural n1, Natural n2) {
                    return n1.add(n2);
                }
            })));
        }
    }));

    private Enumerator(F<A, Option<A>> successor, F<A, Option<A>> predecessor, Option<A> max, Option<A> min2, Ord<A> order, F<A, F<Long, Option<A>>> plus) {
        this.successor = successor;
        this.predecessor = predecessor;
        this.max = max;
        this.min = min2;
        this.order = order;
        this.plus = plus;
    }

    public F<A, Option<A>> successor() {
        return this.successor;
    }

    public Option<A> successor(A a) {
        return this.successor.f(a);
    }

    public F<A, Option<A>> predecessor() {
        return this.predecessor;
    }

    public Option<A> predecessor(A a) {
        return this.predecessor.f(a);
    }

    public Option<A> max() {
        return this.max;
    }

    public Option<A> min() {
        return this.min;
    }

    public F<A, F<Long, Option<A>>> plus() {
        return this.plus;
    }

    public F<Long, Option<A>> plus(A a) {
        return this.plus.f(a);
    }

    public F<A, Option<A>> plus(long l) {
        return Function.flip(this.plus).f(l);
    }

    public Option<A> plus(A a, long l) {
        return this.plus.f(a).f(l);
    }

    public Ord<A> order() {
        return this.order;
    }

    public <B> Enumerator<B> xmap(final F<A, B> f, F<B, A> g2) {
        F of = new F<Option<A>, Option<B>>(){

            @Override
            public Option<B> f(Option<A> o) {
                return o.map(f);
            }
        };
        return Enumerator.enumerator(Function.compose(Function.compose(of, this.successor), g2), Function.compose(Function.compose(of, this.predecessor), g2), this.max.map(f), this.min.map(f), this.order.comap(g2), Function.compose(Function.compose(Function.compose().f(of), this.plus), g2));
    }

    public Stream<A> toStream(A a) {
        F id = Function.identity();
        return Stream.fromFunction(this, id, a);
    }

    public Enumerator<A> setMin(Option<A> min2) {
        return Enumerator.enumerator(this.successor, this.predecessor, this.max, min2, this.order, this.plus);
    }

    public Enumerator<A> setMax(Option<A> max) {
        return Enumerator.enumerator(this.successor, this.predecessor, max, this.min, this.order, this.plus);
    }

    public static <A> Enumerator<A> enumerator(F<A, Option<A>> successor, F<A, Option<A>> predecessor, Option<A> max, Option<A> min2, Ord<A> order, F<A, F<Long, Option<A>>> plus) {
        return new Enumerator<A>(successor, predecessor, max, min2, order, plus);
    }

    public static <A> Enumerator<A> enumerator(final F<A, Option<A>> successor, final F<A, Option<A>> predecessor, Option<A> max, Option<A> min2, Ord<A> order) {
        return new Enumerator<A>(successor, predecessor, max, min2, order, Function.curry(new F2<A, Long, Option<A>>(){

            @Override
            public Option<A> f(A a, Long l) {
                if (l == 0L) {
                    return Option.some(a);
                }
                if (l < 0L) {
                    Object aa = a;
                    for (long x = l.longValue(); x < 0L; ++x) {
                        Option s2 = (Option)predecessor.f(aa);
                        if (s2.isNone()) {
                            return Option.none();
                        }
                        aa = s2.some();
                    }
                    return Option.some(aa);
                }
                Object aa = a;
                for (long x = l.longValue(); x > 0L; --x) {
                    Option s3 = (Option)successor.f(aa);
                    if (s3.isNone()) {
                        return Option.none();
                    }
                    aa = s3.some();
                }
                return Option.some(aa);
            }
        }));
    }
}

