/*
 * Decompiled with CFR 0.152.
 */
package de.darmstadt.tu.crossing.scoping;

import de.darmstadt.tu.crossing.crySL.Domainmodel;
import de.darmstadt.tu.crossing.crySL.ForbMethod;
import de.darmstadt.tu.crossing.crySL.LiteralExpression;
import de.darmstadt.tu.crossing.crySL.Method;
import de.darmstadt.tu.crossing.scoping.AbstractCrySLScopeProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

public class CrySLScopeProvider
extends AbstractCrySLScopeProvider {
    @Override
    public IScope getScope(EObject context, EReference reference) {
        IScope scope = this.polymorphicFindScopeForReferenceName(context, reference);
        if (scope == null && (scope = this.polymorphicFindScopeForClassName(context, reference)) == null && (scope = this.delegateGetScope(context, reference)) instanceof SelectableBasedScope && context instanceof LiteralExpression) {
            ArrayList scopeElements = new ArrayList();
            ArrayList<IEObjectDescription> locals = new ArrayList<IEObjectDescription>();
            scope.getAllElements().forEach(scopeElements::add);
            for (IEObjectDescription desc : scopeElements) {
                if (desc.toString().equals("void")) {
                    locals.clear();
                    break;
                }
                if (desc.toString().contains(".")) break;
                locals.add(desc);
            }
            if (!locals.isEmpty()) {
                scope = new SimpleScope(locals);
            }
        }
        return scope;
    }

    IScope scope_ForbMethod_javaMeth(ForbMethod fm, EReference reference) {
        JvmType jvmType;
        EObject cont = fm.eContainer().eContainer();
        Set<IEObjectDescription> descriptions = new HashSet<IEObjectDescription>();
        if (cont instanceof Domainmodel && (jvmType = ((Domainmodel)cont).getJavaType()) instanceof JvmGenericType) {
            descriptions = this.iterateThroughSuperTypes((JvmGenericType)jvmType, descriptions, true);
        }
        return new SimpleScope(descriptions);
    }

    IScope scope_Method_methName(Method fm, EReference reference) {
        JvmType jvmType;
        EObject cont = fm.eContainer().eContainer().eContainer();
        Set<IEObjectDescription> descriptions = new HashSet<IEObjectDescription>();
        if (cont instanceof Domainmodel && (jvmType = ((Domainmodel)cont).getJavaType()) instanceof JvmGenericType) {
            descriptions = this.iterateThroughSuperTypes((JvmGenericType)jvmType, descriptions, false);
        }
        return new SimpleScope(descriptions);
    }

    private Set<IEObjectDescription> iterateThroughSuperTypes(JvmGenericType jvmType, Set<IEObjectDescription> descriptions, boolean FQN) {
        if (FQN) {
            descriptions.addAll(this.collectMethodsFQN(jvmType));
        } else {
            descriptions.addAll(this.collectMethodsSimpleName(jvmType));
        }
        for (JvmTypeReference superType : jvmType.getSuperTypes()) {
            descriptions.addAll(this.iterateThroughSuperTypes((JvmGenericType)superType.getType(), descriptions, FQN));
        }
        for (JvmTypeReference superType : jvmType.getExtendedInterfaces()) {
            descriptions.addAll(this.iterateThroughSuperTypes((JvmGenericType)superType.getType(), descriptions, FQN));
        }
        return descriptions;
    }

    private Set<IEObjectDescription> collectMethodsFQN(JvmGenericType jvmType) {
        String name;
        String classdotname;
        String memidentifier;
        HashSet<IEObjectDescription> methods = new HashSet<IEObjectDescription>();
        for (JvmConstructor jvmConstructor : jvmType.getDeclaredConstructors()) {
            memidentifier = jvmConstructor.getIdentifier();
            classdotname = memidentifier.substring(memidentifier.indexOf(jvmType.getSimpleName()));
            name = classdotname.substring(classdotname.indexOf(".") + 1);
            methods.add(EObjectDescription.create(name.replace(".", "_"), (EObject)jvmConstructor));
        }
        for (JvmOperation jvmOperation : jvmType.getDeclaredOperations()) {
            memidentifier = jvmOperation.getIdentifier();
            classdotname = memidentifier.substring(memidentifier.indexOf(jvmType.getSimpleName()));
            name = classdotname.substring(classdotname.indexOf(".") + 1);
            methods.add(EObjectDescription.create(name.replace(".", "_"), (EObject)jvmOperation));
        }
        return methods;
    }

    private Set<IEObjectDescription> collectMethodsSimpleName(JvmGenericType gt) {
        HashSet<IEObjectDescription> descriptions = new HashSet<IEObjectDescription>();
        for (JvmConstructor jvmConstructor : gt.getDeclaredConstructors()) {
            descriptions.add(EObjectDescription.create(jvmConstructor.getSimpleName(), (EObject)jvmConstructor));
        }
        for (JvmOperation jvmOperation : gt.getDeclaredOperations()) {
            descriptions.add(EObjectDescription.create(jvmOperation.getSimpleName(), (EObject)jvmOperation));
        }
        return descriptions;
    }
}

