/*
 * Decompiled with CFR 0.152.
 */
package crypto.typestate;

import boomerang.jimple.Statement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import crypto.rules.CrySLMethod;
import crypto.rules.StateMachineGraph;
import crypto.rules.StateNode;
import crypto.rules.TransitionEdge;
import crypto.typestate.CrySLMethodToSootMethod;
import crypto.typestate.ErrorStateNode;
import crypto.typestate.LabeledMatcherTransition;
import crypto.typestate.ReportingErrorStateNode;
import crypto.typestate.WrappedState;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import typestate.TransitionFunction;
import typestate.finiteautomata.MatcherTransition;
import typestate.finiteautomata.State;

public class SootBasedStateMachineGraph {
    private Set<MatcherTransition> transition = new HashSet<MatcherTransition>();
    private Collection<SootMethod> edgeLabelMethods = Sets.newHashSet();
    private final StateMachineGraph stateMachineGraph;
    private Multimap<State, SootMethod> outTransitions = HashMultimap.create();
    private Collection<SootMethod> initialTransitonLabel;
    private List<CrySLMethod> crySLinitialTransitionLabel;
    private LabeledMatcherTransition initialTransiton;

    public SootBasedStateMachineGraph(StateMachineGraph fsm) {
        this.stateMachineGraph = fsm;
        for (TransitionEdge transitionEdge : this.stateMachineGraph.getAllTransitions()) {
            WrappedState from = this.wrappedState(transitionEdge.from());
            WrappedState to = this.wrappedState(transitionEdge.to());
            LabeledMatcherTransition trans = new LabeledMatcherTransition((State)from, transitionEdge.getLabel(), MatcherTransition.Parameter.This, (State)to, MatcherTransition.Type.OnCallOrOnCallToReturn);
            this.addTransition(trans);
            this.outTransitions.putAll(from, this.convert(transitionEdge.getLabel()));
            if (!this.stateMachineGraph.getInitialTransition().equals(transitionEdge)) continue;
            this.initialTransiton = trans;
        }
        this.crySLinitialTransitionLabel = this.stateMachineGraph.getInitialTransition().getLabel();
        this.initialTransitonLabel = this.convert(this.stateMachineGraph.getInitialTransition().getLabel());
        for (StateNode stateNode : this.stateMachineGraph.getNodes()) {
            WrappedState wrapped = this.wrappedState(stateNode);
            Collection<SootMethod> remaining = this.getInvolvedMethods();
            Collection<SootMethod> expected = this.outTransitions.get(wrapped);
            if (expected == null) continue;
            remaining.removeAll(expected);
            ReportingErrorStateNode repErrorState = new ReportingErrorStateNode(expected);
            this.addTransition(new MatcherTransition((State)wrapped, remaining, MatcherTransition.Parameter.This, (State)new ReportingErrorStateNode(expected), MatcherTransition.Type.OnCallOrOnCallToReturn));
            ErrorStateNode errorState = new ErrorStateNode();
            this.addTransition(new MatcherTransition((State)repErrorState, this.getInvolvedMethods(), MatcherTransition.Parameter.This, (State)errorState, MatcherTransition.Type.OnCallOrOnCallToReturn));
        }
    }

    private WrappedState wrappedState(StateNode t) {
        return new WrappedState(t, this.stateMachineGraph.getInitialTransition().from().equals(t));
    }

    public Collection<SootMethod> getEdgesOutOf(State n) {
        return this.outTransitions.get(n);
    }

    public void addTransition(MatcherTransition trans) {
        this.transition.add(trans);
    }

    private Collection<SootMethod> convert(List<CrySLMethod> label) {
        Collection<SootMethod> converted = CrySLMethodToSootMethod.v().convert(label);
        this.edgeLabelMethods.addAll(converted);
        return converted;
    }

    public Collection<SootMethod> getInvolvedMethods() {
        return Sets.newHashSet(this.edgeLabelMethods);
    }

    public TransitionFunction getInitialWeight(Statement stmt) {
        return new TransitionFunction(this.initialTransiton, Collections.singleton(stmt));
    }

    public List<MatcherTransition> getAllTransitions() {
        return Lists.newArrayList(this.transition);
    }

    public Collection<SootMethod> initialTransitonLabel() {
        return Lists.newArrayList(this.initialTransitonLabel);
    }

    public List<CrySLMethod> getInitialTransition() {
        return this.crySLinitialTransitionLabel;
    }
}

