/*
 * Decompiled with CFR 0.152.
 */
package crypto.typestate;

import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedForwardQuery;
import boomerang.callgraph.ObservableICFG;
import boomerang.debugger.Debugger;
import boomerang.jimple.Statement;
import boomerang.jimple.Val;
import boomerang.results.ForwardBoomerangResults;
import com.google.common.collect.Maps;
import crypto.analysis.CrySLResultsReporter;
import crypto.analysis.IAnalysisSeed;
import crypto.boomerang.CogniCryptBoomerangOptions;
import crypto.typestate.FiniteStateMachineToTypestateChangeFunction;
import crypto.typestate.SootBasedStateMachineGraph;
import ideal.IDEALAnalysis;
import ideal.IDEALAnalysisDefinition;
import ideal.IDEALSeedSolver;
import ideal.IDEALSeedTimeout;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;
import sync.pds.solver.WeightFunctions;
import typestate.TransitionFunction;

public abstract class ExtendedIDEALAnaylsis {
    private FiniteStateMachineToTypestateChangeFunction changeFunction;
    private final IDEALAnalysis<TransitionFunction> analysis = new IDEALAnalysis<TransitionFunction>(new IDEALAnalysisDefinition<TransitionFunction>(){

        @Override
        public Collection<WeightedForwardQuery<TransitionFunction>> generate(SootMethod method, Unit stmt) {
            return ExtendedIDEALAnaylsis.this.getOrCreateTypestateChangeFunction().generateSeed(method, stmt);
        }

        @Override
        public WeightFunctions<Statement, Val, Statement, TransitionFunction> weightFunctions() {
            return ExtendedIDEALAnaylsis.this.getOrCreateTypestateChangeFunction();
        }

        @Override
        public ObservableICFG<Unit, SootMethod> icfg() {
            return ExtendedIDEALAnaylsis.this.icfg();
        }

        @Override
        public boolean enableStrongUpdates() {
            return true;
        }

        @Override
        public Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> solver) {
            return ExtendedIDEALAnaylsis.this.debugger(solver);
        }

        @Override
        public BoomerangOptions boomerangOptions() {
            return new CogniCryptBoomerangOptions();
        }
    });
    private ForwardBoomerangResults<TransitionFunction> results;
    private HashSet seeds;

    private FiniteStateMachineToTypestateChangeFunction getOrCreateTypestateChangeFunction() {
        if (this.changeFunction == null) {
            this.changeFunction = new FiniteStateMachineToTypestateChangeFunction(this.getStateMachine());
        }
        return this.changeFunction;
    }

    public abstract SootBasedStateMachineGraph getStateMachine();

    public void run(ForwardQuery query) {
        block2: {
            CrySLResultsReporter reports = this.analysisListener();
            try {
                this.results = this.analysis.run(query);
            }
            catch (IDEALSeedTimeout e) {
                if (reports == null || !(query instanceof IAnalysisSeed)) break block2;
                reports.onSeedTimeout(((IAnalysisSeed)query).asNode());
            }
        }
    }

    protected abstract ObservableICFG<Unit, SootMethod> icfg();

    protected abstract Debugger<TransitionFunction> debugger(IDEALSeedSolver<TransitionFunction> var1);

    public void log(String string) {
    }

    public abstract CrySLResultsReporter analysisListener();

    public Collection<WeightedForwardQuery<TransitionFunction>> computeSeeds(SootMethod method) {
        HashSet<WeightedForwardQuery<TransitionFunction>> seeds = new HashSet<WeightedForwardQuery<TransitionFunction>>();
        if (!method.hasActiveBody()) {
            return seeds;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            seeds.addAll(this.getOrCreateTypestateChangeFunction().generateSeed(method, u));
        }
        return seeds;
    }

    public Map<WeightedForwardQuery<TransitionFunction>, ForwardBoomerangResults<TransitionFunction>> run() {
        HashSet<WeightedForwardQuery<TransitionFunction>> seeds = new HashSet<WeightedForwardQuery<TransitionFunction>>();
        ReachableMethods rm = Scene.v().getReachableMethods();
        QueueReader<MethodOrMethodContext> listener = rm.listener();
        while (listener.hasNext()) {
            MethodOrMethodContext next = listener.next();
            seeds.addAll(this.computeSeeds(next.method()));
        }
        HashMap<WeightedForwardQuery<TransitionFunction>, ForwardBoomerangResults<TransitionFunction>> seedToSolver = Maps.newHashMap();
        for (Query query : seeds) {
            if (!(query instanceof WeightedForwardQuery)) continue;
            WeightedForwardQuery seed = (WeightedForwardQuery)query;
            this.run(seed);
            if (this.getResults() == null) continue;
            seedToSolver.put(seed, this.getResults());
        }
        return seedToSolver;
    }

    public ForwardBoomerangResults<TransitionFunction> getResults() {
        return this.results;
    }
}

