/*
 * Decompiled with CFR 0.152.
 */
package crypto.rules;

import com.google.common.collect.Sets;
import crypto.interfaces.ISLConstraint;
import crypto.rules.CrySLForbiddenMethod;
import crypto.rules.CrySLPredicate;
import crypto.rules.StateMachineGraph;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.SootMethod;

public class CrySLRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final List<Map.Entry<String, String>> objects;
    protected final List<CrySLForbiddenMethod> forbiddenMethods;
    protected final StateMachineGraph usagePattern;
    protected final List<ISLConstraint> constraints;
    protected final List<CrySLPredicate> predicates;

    public CrySLRule(String _className, List<Map.Entry<String, String>> defObjects, List<CrySLForbiddenMethod> _forbiddenMethods, StateMachineGraph _usagePattern, List<ISLConstraint> _constraints, List<CrySLPredicate> _predicates) {
        this.className = _className;
        this.objects = defObjects;
        this.forbiddenMethods = _forbiddenMethods;
        this.usagePattern = _usagePattern;
        this.constraints = _constraints;
        this.predicates = _predicates;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CrySLRule) {
            return ((CrySLRule)obj).getClassName().equals(this.className);
        }
        return false;
    }

    public boolean isLeafRule() {
        for (ISLConstraint con : this.constraints) {
            if (!(con instanceof CrySLPredicate)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 31 * this.className.hashCode();
    }

    public String getClassName() {
        return this.className;
    }

    public List<Map.Entry<String, String>> getObjects() {
        return this.objects;
    }

    public List<CrySLForbiddenMethod> getForbiddenMethods() {
        return this.forbiddenMethods;
    }

    public StateMachineGraph getUsagePattern() {
        return this.usagePattern;
    }

    public List<ISLConstraint> getConstraints() {
        return this.constraints;
    }

    public List<CrySLPredicate> getPredicates() {
        return this.predicates;
    }

    public List<CrySLPredicate> getRequiredPredicates() {
        LinkedList<CrySLPredicate> requires = new LinkedList<CrySLPredicate>();
        for (ISLConstraint con : this.constraints) {
            if (!(con instanceof CrySLPredicate)) continue;
            requires.add((CrySLPredicate)con);
        }
        return requires;
    }

    public String toString() {
        StringBuilder outputSB = new StringBuilder();
        outputSB.append(this.className);
        outputSB.append("\nforbiddenMethods:");
        for (CrySLForbiddenMethod forbMethSig : this.forbiddenMethods) {
            outputSB.append(forbMethSig);
            outputSB.append(",");
        }
        outputSB.append("\nUsage Pattern:");
        outputSB.append(this.usagePattern);
        outputSB.append("\nConstraints:");
        for (ISLConstraint constraint : this.constraints) {
            outputSB.append(constraint);
            outputSB.append(",");
        }
        if (this.predicates != null) {
            outputSB.append("\nPredicates:");
            for (CrySLPredicate predicate : this.predicates) {
                outputSB.append(predicate);
                outputSB.append(",");
            }
        }
        return outputSB.toString();
    }

    public static Collection<String> toSubSignatures(Collection<SootMethod> methods) {
        HashSet<String> subSignatures = Sets.newHashSet();
        for (SootMethod m3 : methods) {
            subSignatures.add(m3.getName());
        }
        return subSignatures;
    }
}

