/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import crypto.reporting.ReportStatistics;
import crypto.reporting.SourceCodeLocater;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import soot.SootClass;

public class SARIFHelper {
    private final Map<String, String> rulesMap = new HashMap<String, String>();
    private final SourceCodeLocater sourceLocater;

    public SARIFHelper() {
        this.initialize();
        this.sourceLocater = null;
    }

    public SARIFHelper(SourceCodeLocater sourceLocater) {
        this.sourceLocater = sourceLocater;
    }

    private void initialize() {
        this.rulesMap.put("ConstraintError", "A constraint of a CrySL rule is violated, e.g., a key is generated with the wrong key size.");
        this.rulesMap.put("ForbiddenMethodError", "A method that is forbidden (CrySL block FORBIDDEN) to be called under some circumstances was found.");
        this.rulesMap.put("ImpreciseValueExtractionError", "The static analysis was not able to extract all information required within the CrySL CONSTRAINT block. For example the key size could be supplied as a value listed in a configuration file. The static analysis does not model the file's content and may not constraint on the value.");
        this.rulesMap.put("IncompleteOperationError", "The usage of an object may be incomplete: For example a Cipherobject may be initialized but never used for en- or decryption, this may render the code dead. This error heavily depends on the computed call graph (CHA by default)");
        this.rulesMap.put("NeverTypeOfError", "Reported when a value was found to be of a certain reference type: For example, a character array containing a password should never be converted from a String");
        this.rulesMap.put("RequiredPredicateError", "An object A expects an object B to have been used correctly (CrySL blocks REQUIRES and ENSURES). For example a Cipher object requires a SecretKey object to be correctly and securely generated.");
        this.rulesMap.put("TypestateError", "The ORDER block of CrySL is violated, i.e., the expected method sequence call to be made is incorrect. For example, a Signature object expects a call to initSign(key) prior to update(data).");
    }

    public JSONObject initialJson() {
        JSONObject json = new JSONObject();
        json.put("version", "1.0.0");
        json.put("runs", new JSONArray().add(this.getRuns()));
        return json;
    }

    private JSONObject getRuns() {
        JSONObject jsonRuns = new JSONObject();
        jsonRuns.put("tool", this.getToolInfo());
        return jsonRuns;
    }

    public JSONObject getToolInfo() {
        JSONObject tool = new JSONObject();
        tool.put("name", "CryptoAnalysis");
        tool.put("version", this.getClass().getPackage().getImplementationVersion());
        tool.put("semanticVersion", this.getClass().getPackage().getImplementationVersion());
        tool.put("language", "en-US");
        return tool;
    }

    public JSONObject getMessage(String text, String richText) {
        JSONObject message = new JSONObject();
        message.put("text", text);
        message.put("richText", richText);
        return message;
    }

    public String getFileName(SootClass c) {
        return this.sourceLocater == null ? c.getName().replace(".", "/") + ".java" : this.sourceLocater.getAbsolutePath(c);
    }

    public JSONArray getLocations(SootClass c, String methodName, int lineNumber, String method, String statement) {
        JSONArray locations = new JSONArray();
        JSONObject location = new JSONObject();
        JSONObject region = new JSONObject();
        region.put("startLine", lineNumber);
        region.put("method", method);
        region.put("statement", statement);
        JSONObject uri = new JSONObject();
        uri.put("uri", this.getFileName(c));
        JSONObject physicalLocation = new JSONObject();
        physicalLocation.put("fileLocation", uri);
        physicalLocation.put("region", region);
        location.put("physicalLocation", physicalLocation);
        String fullyQualifiedLogicalName = c.getName().replace(".", "::") + "::" + methodName;
        location.put("fullyQualifiedLogicalName", fullyQualifiedLogicalName);
        locations.add(location);
        return locations;
    }

    public String getRuleDescription(String ruleId) {
        return this.rulesMap.get(ruleId);
    }

    public JSONObject getStatisticsInfo(ReportStatistics statistics) {
        JSONObject statisticField = new JSONObject();
        statisticField.put("SoftwareID", statistics.getSoftwareID());
        statisticField.put("SeedObjectCount", statistics.getSeedObjectCount());
        statisticField.put("CryptoAnalysisTime", statistics.getAnalysisTime());
        statisticField.put("CallgraphConstructionTime", statistics.getCallgraphTime());
        statisticField.put("CallgraphReachableMethods", statistics.getCallgraphReachableMethods());
        statisticField.put("CallgraphRechableMethodsWithActiveBodies", statistics.getCallgraphReachableMethodsWithActiveBodies());
        statisticField.put("DataflowVisitedMethods", statistics.getDataflowVisitedMethods());
        return statisticField;
    }
}

