/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.collect.Table;
import crypto.analysis.IAnalysisSeed;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ErrorWithObjectAllocation;
import crypto.reporting.ReportStatistics;
import crypto.rules.CrySLRule;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.SootClass;
import soot.SootMethod;

public class ReporterHelper {
    public static String generateReport(List<CrySLRule> rules, Collection<IAnalysisSeed> objects, List<IAnalysisSeed> secureObjects, Table<SootClass, SootMethod, Set<AbstractError>> errorMarkers, Map<Class, Integer> errorMarkerCount, ReportStatistics statistics) {
        String report = "";
        report = report + "Ruleset: \n";
        for (CrySLRule crySLRule : rules) {
            report = report + String.format("\t%s\n", crySLRule.getClassName());
        }
        report = report + "\n";
        report = report + "Analyzed Objects: \n";
        for (IAnalysisSeed iAnalysisSeed : objects) {
            report = report + String.format("\tObject:\n", new Object[0]);
            report = report + String.format("\t\tVariable: %s\n", iAnalysisSeed.var().value());
            report = report + String.format("\t\tType: %s\n", iAnalysisSeed.getType());
            report = report + String.format("\t\tStatement: %s\n", iAnalysisSeed.stmt().getUnit().get());
            report = report + String.format("\t\tMethod: %s\n", iAnalysisSeed.getMethod());
            report = report + String.format("\t\tSHA-256: %s\n", iAnalysisSeed.getObjectId());
            report = report + String.format("\t\tSecure: %s\n", secureObjects.contains(iAnalysisSeed));
        }
        report = report + "\n";
        for (SootClass sootClass : errorMarkers.rowKeySet()) {
            report = report + String.format("Findings in Java Class: %s\n", sootClass.getName());
            for (Map.Entry<SootMethod, Set<AbstractError>> e : errorMarkers.row(sootClass).entrySet()) {
                report = report + String.format("\n\t in Method: %s\n", e.getKey().getSubSignature());
                for (AbstractError marker : e.getValue()) {
                    report = report + String.format("\t\t%s violating CrySL rule for %s", marker.getClass().getSimpleName(), marker.getRule().getClassName());
                    report = marker instanceof ErrorWithObjectAllocation ? report + String.format(" (on Object #%s)\n", ((ErrorWithObjectAllocation)marker).getObjectLocation().getObjectId()) : report + "\n";
                    report = report + String.format("\t\t\t%s\n", marker.toErrorMarkerString());
                    report = report + String.format("\t\t\tat statement: %s\n", marker.getErrorLocation().getUnit().get());
                    report = report + String.format("\t\t\tat line: %d\n\n", marker.getErrorLocation().getUnit().get().getJavaSourceStartLineNumber());
                }
            }
            report = report + "\n";
        }
        report = report + "======================= CryptoAnalysis Summary ==========================\n";
        report = report + String.format("\tNumber of CrySL rules: %s\n", rules.size());
        report = report + String.format("\tNumber of Objects Analyzed: %s\n", objects.size());
        if (errorMarkers.rowKeySet().isEmpty()) {
            report = report + "No violation of any of the rules found.\n";
        } else {
            report = report + "\n\tCryptoAnalysis found the following violations. For details see description above.\n";
            for (Map.Entry entry : errorMarkerCount.entrySet()) {
                report = report + String.format("\t%s: %s\n", ((Class)entry.getKey()).getSimpleName(), entry.getValue());
            }
        }
        if (statistics != null) {
            report = report + "\n\tAdditional analysis statistics:\n";
            report = report + String.format("\t\tSoftwareID: %s\n", statistics.getSoftwareID());
            report = report + String.format("\t\tSeedObjectCount: %d\n", statistics.getSeedObjectCount());
            report = report + String.format("\t\tCryptoAnalysisTime (in ms): %d\n", statistics.getAnalysisTime());
            report = report + String.format("\t\tCallgraphConstructionTime (in ms): %d\n", statistics.getCallgraphTime());
            report = report + String.format("\t\tCallgraphReachableMethods: %d\n", statistics.getCallgraphReachableMethods());
            report = report + String.format("\t\tCallgraphReachableMethodsWithActiveBodies: %d\n", statistics.getCallgraphReachableMethodsWithActiveBodies());
            report = report + String.format("\t\tDataflowVisitedMethods: %d\n", statistics.getDataflowVisitedMethods());
        }
        report = report + "=========================================================================";
        return report;
    }
}

