/*
 * Decompiled with CFR 0.152.
 */
package crypto.reporting;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import crypto.analysis.errors.AbstractError;
import crypto.analysis.errors.ConstraintError;
import crypto.analysis.errors.ForbiddenMethodError;
import crypto.analysis.errors.HardCodedError;
import crypto.analysis.errors.ImpreciseValueExtractionError;
import crypto.analysis.errors.IncompleteOperationError;
import crypto.analysis.errors.NeverTypeOfError;
import crypto.analysis.errors.RequiredPredicateError;
import crypto.analysis.errors.TypestateError;
import crypto.reporting.Reporter;
import crypto.rules.CrySLRule;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVSummaryReporter
extends Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVSummaryReporter.class);
    private static final String CSV_SEPARATOR = ";";
    private Set<AbstractError> errors = Sets.newHashSet();
    private List<String> headers = Lists.newArrayList();
    private Map<String, String> headersToValues = Maps.newHashMap();
    private static final String REPORT_NAME = "CryptoAnalysis-Report-Summary.csv";

    public CSVSummaryReporter(String reportDir, String softwareId, List<CrySLRule> rules, long callGraphConstructionTime, boolean includeStatistics) {
        super(reportDir != null ? new File(reportDir) : new File(System.getProperty("user.dir")), softwareId, rules, callGraphConstructionTime, includeStatistics);
        if (this.includeStatistics()) {
            for (Headers h2 : Headers.values()) {
                this.headers.add(h2.toString());
            }
            this.put(Headers.SoftwareID, (Object)this.getStatistics().getSoftwareID());
            this.put(Headers.CallGraphTime_ms, (Object)this.getStatistics().getCallgraphTime());
            this.put(Headers.CallGraphReachableMethods, (Object)this.getStatistics().getCallgraphReachableMethods());
            this.put(Headers.CallGraphReachableMethods_ActiveBodies, (Object)this.getStatistics().getCallgraphReachableMethodsWithActiveBodies());
        }
        this.addDynamicHeader(ConstraintError.class.getSimpleName());
        this.addDynamicHeader(NeverTypeOfError.class.getSimpleName());
        this.addDynamicHeader(HardCodedError.class.getSimpleName());
        this.addDynamicHeader(TypestateError.class.getSimpleName());
        this.addDynamicHeader(RequiredPredicateError.class.getSimpleName());
        this.addDynamicHeader(IncompleteOperationError.class.getSimpleName());
        this.addDynamicHeader(ImpreciseValueExtractionError.class.getSimpleName());
        this.addDynamicHeader(ForbiddenMethodError.class.getSimpleName());
    }

    private void addDynamicHeader(String name) {
        this.headers.add(name + "_sum");
        for (CrySLRule r : this.getRules()) {
            this.headers.add(name + "_" + r.getClassName());
        }
    }

    private void put(Headers key, Object val) {
        this.put(key.toString(), val);
    }

    private void put(String key, Object val) {
        if (!this.headers.contains(key)) {
            LOGGER.error("Did not create a header to this value " + key);
        } else if (val == null) {
            LOGGER.info(key + " is null");
        } else {
            this.headersToValues.put(key, val.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleAnalysisResults() {
        if (this.includeStatistics()) {
            this.put(Headers.DataflowVisitedMethod, (Object)this.getStatistics().getDataflowVisitedMethods());
            this.put(Headers.CryptoAnalysisTime_ms, (Object)this.getStatistics().getAnalysisTime());
            this.put(Headers.SeedObjectCount, (Object)this.getStatistics().getSeedObjectCount());
        }
        HashBasedTable<Class<?>, CrySLRule, Integer> errorTable = HashBasedTable.create();
        for (AbstractError abstractError : this.errors) {
            Integer n;
            void var4_11;
            Integer n2 = (Integer)errorTable.get(abstractError.getClass(), abstractError.getRule());
            if (n2 == null) {
                Integer n3 = 0;
            }
            void var5_16 = var4_11;
            Integer n4 = n = Integer.valueOf(var4_11.intValue() + 1);
            errorTable.put(abstractError.getClass(), abstractError.getRule(), n);
        }
        for (Table.Cell cell : errorTable.cellSet()) {
            this.put(((Class)cell.getRowKey()).getSimpleName() + "_" + ((CrySLRule)cell.getColumnKey()).getClassName(), cell.getValue());
        }
        HashMap errorsAccumulated = Maps.newHashMap();
        for (Table.Cell cell : errorTable.cellSet()) {
            Integer integer = (Integer)errorsAccumulated.get(cell.getRowKey());
            if (integer == null) {
                integer = 0;
            }
            integer = integer + (Integer)cell.getValue();
            errorsAccumulated.put(cell.getRowKey(), integer);
        }
        for (Map.Entry entry : errorsAccumulated.entrySet()) {
            this.put(((Class)entry.getKey()).getSimpleName() + "_sum", entry.getValue());
        }
        this.writeToFile();
    }

    private void writeToFile() {
        try {
            FileWriter writer = new FileWriter(this.getOutputFolder() + File.separator + REPORT_NAME);
            writer.write(Joiner.on(CSV_SEPARATOR).join(this.headers) + "\n");
            ArrayList<String> line = Lists.newArrayList();
            for (String h2 : this.headers) {
                String string = this.headersToValues.get(h2);
                if (string == null) {
                    string = "";
                }
                line.add(string);
            }
            writer.write(Joiner.on(CSV_SEPARATOR).join(line) + "\n");
            writer.write("\nCryptoAnalysis\n");
            String version2 = this.getClass().getPackage().getImplementationVersion();
            if (version2 == null) {
                version2 = "Version is not known";
            }
            writer.write(version2);
            writer.close();
            LOGGER.info("CSV Report generated to file : " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME);
        }
        catch (IOException e) {
            LOGGER.error("Could not write to " + this.getOutputFolder().getAbsolutePath() + File.separator + REPORT_NAME, e);
        }
    }

    @Override
    public void reportError(AbstractError error) {
        this.errors.add(error);
    }

    private static enum Headers {
        SoftwareID,
        SeedObjectCount,
        CryptoAnalysisTime_ms,
        CallGraphTime_ms,
        CallGraphReachableMethods,
        CallGraphReachableMethods_ActiveBodies,
        DataflowVisitedMethod;

    }
}

